/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.timing;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.Comm;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;

public class TimeBcastByte {
    private static final DecimalFormat FMT3 = new DecimalFormat("0.00E0");
    static Comm world;
    static int size;
    static int rank;
    static int reps;
    static int numn;
    static int[] n;

    private TimeBcastByte() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        world = Comm.world();
        size = world.size();
        rank = world.rank();
        if (stringArray.length < 2) {
            TimeBcastByte.usage();
        }
        reps = Integer.parseInt(stringArray[0]);
        numn = stringArray.length - 1;
        TimeBcastByte.n = new int[numn];
        for (n = 0; n < numn; ++n) {
            TimeBcastByte.n[n] = Integer.parseInt(stringArray[n + 1]);
        }
        if (rank == 0) {
            System.out.println("java -Dpj.np=" + size + " edu.rit.clu.timing.TimeBcastByte " + reps);
            System.out.println(new Date());
            System.out.println("n\ttime1\ttime2\tBcast time (sec)");
        }
        for (n = 0; n < numn; ++n) {
            int n2 = TimeBcastByte.n[n];
            byte[] byArray = new byte[n2];
            ByteBuf byteBuf = ByteBuf.buffer(byArray);
            long l = -System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                TimeBcastByte.fill(n2, byArray, byteBuf);
            }
            l += System.currentTimeMillis();
            long l2 = -System.currentTimeMillis();
            for (int i = 0; i < reps; ++i) {
                TimeBcastByte.fillBroadcast(n2, byArray, byteBuf);
            }
            l2 += System.currentTimeMillis();
            if (rank != 0) continue;
            double d = (double)(l2 - l) / (double)reps / (double)size / 1000.0;
            System.out.print(n2);
            System.out.print('\t');
            System.out.print(l);
            System.out.print('\t');
            System.out.print(l2);
            System.out.print('\t');
            System.out.print(FMT3.format(d));
            System.out.println();
        }
    }

    private static void fill(int n, byte[] byArray, ByteBuf byteBuf) {
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)i;
        }
    }

    private static void fillBroadcast(int n, byte[] byArray, ByteBuf byteBuf) throws IOException {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = (byte)n2;
        }
        for (n2 = size; n2 > 0; --n2) {
            world.broadcast(n2 % size, byteBuf);
        }
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.np=<K> edu.rit.clu.timing.TimeBcastByte <reps> <n1> [<n2> ...]");
        System.err.println("<K> = Number of processors, <K> >= 2");
        System.err.println("<reps> = Number of repetitions for each value of <n>");
        System.err.println("<n1> = First value of <n>");
        System.err.println("<n2> = Second value of <n> . . .");
        System.exit(1);
    }
}

