/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Random;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.CfsSubsetEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class AttributeSelection
implements Serializable {
    private Instances m_trainInstances;
    private ASEvaluation m_ASEvaluator;
    private ASSearch m_searchMethod;
    private int m_numFolds;
    private StringBuffer m_selectionResults;
    private boolean m_doRank;
    private boolean m_doXval;
    private int m_seed;
    private int m_numToSelect;
    private int[] m_selectedAttributeSet;
    private double[][] m_attributeRanking;
    private AttributeTransformer m_transformer = null;
    private Remove m_attributeFilter = null;
    private double[][] m_rankResults = null;
    private double[] m_subsetResults = null;
    private int m_trials = 0;
    static /* synthetic */ Class class$weka$attributeSelection$ASEvaluation;

    public int numberAttributesSelected() throws Exception {
        int[] nArray = this.selectedAttributes();
        return nArray.length - 1;
    }

    public int[] selectedAttributes() throws Exception {
        if (this.m_selectedAttributeSet == null) {
            throw new Exception("Attribute selection has not been performed yet!");
        }
        return this.m_selectedAttributeSet;
    }

    public double[][] rankedAttributes() throws Exception {
        if (this.m_attributeRanking == null) {
            throw new Exception("Ranking has not been performed");
        }
        return this.m_attributeRanking;
    }

    public void setEvaluator(ASEvaluation aSEvaluation) {
        this.m_ASEvaluator = aSEvaluation;
    }

    public void setSearch(ASSearch aSSearch) {
        this.m_searchMethod = aSSearch;
        if (this.m_searchMethod instanceof RankedOutputSearch) {
            this.setRanking(((RankedOutputSearch)((Object)this.m_searchMethod)).getGenerateRanking());
        }
    }

    public void setFolds(int n) {
        this.m_numFolds = n;
    }

    public void setRanking(boolean bl) {
        this.m_doRank = bl;
    }

    public void setXval(boolean bl) {
        this.m_doXval = bl;
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public String toResultsString() {
        return this.m_selectionResults.toString();
    }

    public Instances reduceDimensionality(Instances instances) throws Exception {
        if (this.m_attributeFilter == null) {
            throw new Exception("No feature selection has been performed yet!");
        }
        if (this.m_transformer != null) {
            Instances instances2 = new Instances(this.m_transformer.transformedHeader(), instances.numInstances());
            for (int i = 0; i < instances.numInstances(); ++i) {
                instances2.add(this.m_transformer.convertInstance(instances.instance(i)));
            }
            return Filter.useFilter(instances2, this.m_attributeFilter);
        }
        return Filter.useFilter(instances, this.m_attributeFilter);
    }

    public Instance reduceDimensionality(Instance instance) throws Exception {
        if (this.m_attributeFilter == null) {
            throw new Exception("No feature selection has been performed yet!");
        }
        if (this.m_transformer != null) {
            instance = this.m_transformer.convertInstance(instance);
        }
        this.m_attributeFilter.input(instance);
        this.m_attributeFilter.batchFinished();
        Instance instance2 = this.m_attributeFilter.output();
        return instance2;
    }

    public AttributeSelection() {
        this.setFolds(10);
        this.setRanking(false);
        this.setXval(false);
        this.setSeed(1);
        this.setEvaluator(new CfsSubsetEval());
        this.setSearch(new GreedyStepwise());
        this.m_selectionResults = new StringBuffer();
        this.m_selectedAttributeSet = null;
        this.m_attributeRanking = null;
    }

    public static String SelectAttributes(ASEvaluation aSEvaluation, String[] stringArray) throws Exception {
        String string;
        Instances instances = null;
        ASSearch aSSearch = null;
        String[] stringArray2 = (String[])stringArray.clone();
        boolean bl = false;
        try {
            string = Utils.getOption('i', stringArray);
            bl = Utils.getFlag('h', stringArray2);
            if (bl || string.length() == 0) {
                String string2 = Utils.getOption('s', stringArray2);
                if (string2.length() != 0) {
                    String[] stringArray3 = Utils.splitOptions(string2);
                    aSSearch = (ASSearch)Class.forName(stringArray3[0]).newInstance();
                }
                if (bl) {
                    throw new Exception("Help requested.");
                }
                throw new Exception("No training file given.");
            }
        }
        catch (Exception exception) {
            throw new Exception('\n' + exception.getMessage() + AttributeSelection.makeOptionString(aSEvaluation, aSSearch));
        }
        instances = new Instances(new FileReader(string));
        return AttributeSelection.SelectAttributes(aSEvaluation, stringArray, instances);
    }

    public String CVResultsString() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_subsetResults == null && this.m_rankResults == null || this.m_trainInstances == null) {
            throw new Exception("Attribute selection has not been performed yet!");
        }
        int n = (int)(Math.log(this.m_trainInstances.numAttributes()) + 1.0);
        stringBuffer.append("\n\n=== Attribute selection " + this.m_numFolds + " fold cross-validation ");
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) && this.m_trainInstances.classAttribute().isNominal()) {
            stringBuffer.append("(stratified), seed: ");
            stringBuffer.append(this.m_seed + " ===\n\n");
        } else {
            stringBuffer.append("seed: " + this.m_seed + " ===\n\n");
        }
        if (this.m_searchMethod instanceof RankedOutputSearch && this.m_doRank) {
            stringBuffer.append("average merit      average rank  attribute\n");
            for (int i = 0; i < this.m_rankResults[0].length; ++i) {
                double[] dArray = this.m_rankResults[0];
                int n2 = i;
                dArray[n2] = dArray[n2] / (double)this.m_numFolds;
                double d = this.m_rankResults[0][i] * this.m_rankResults[0][i] * (double)this.m_numFolds;
                d = this.m_rankResults[2][i] - d;
                if ((d /= (double)this.m_numFolds) <= 0.0) {
                    d = 0.0;
                    this.m_rankResults[2][i] = 0.0;
                } else {
                    this.m_rankResults[2][i] = Math.sqrt(d);
                }
                double[] dArray2 = this.m_rankResults[1];
                int n3 = i;
                dArray2[n3] = dArray2[n3] / (double)this.m_numFolds;
                d = this.m_rankResults[1][i] * this.m_rankResults[1][i] * (double)this.m_numFolds;
                d = this.m_rankResults[3][i] - d;
                d /= (double)this.m_numFolds;
                if (d <= 0.0) {
                    d = 0.0;
                    this.m_rankResults[3][i] = 0.0;
                    continue;
                }
                this.m_rankResults[3][i] = Math.sqrt(d);
            }
            int[] nArray = Utils.sort(this.m_rankResults[1]);
            for (int i = 0; i < nArray.length; ++i) {
                if (!(this.m_rankResults[1][nArray[i]] > 0.0)) continue;
                stringBuffer.append(Utils.doubleToString(Math.abs(this.m_rankResults[0][nArray[i]]), 6, 3) + " +-" + Utils.doubleToString(this.m_rankResults[2][nArray[i]], 6, 3) + "   " + Utils.doubleToString(this.m_rankResults[1][nArray[i]], n + 2, 1) + " +-" + Utils.doubleToString(this.m_rankResults[3][nArray[i]], 5, 2) + "  " + Utils.doubleToString(nArray[i] + 1, n, 0) + " " + this.m_trainInstances.attribute(nArray[i]).name() + "\n");
            }
        } else {
            stringBuffer.append("number of folds (%)  attribute\n");
            for (int i = 0; i < this.m_subsetResults.length; ++i) {
                if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && i == this.m_trainInstances.classIndex()) continue;
                stringBuffer.append(Utils.doubleToString(this.m_subsetResults[i], 12, 0) + "(" + Utils.doubleToString(this.m_subsetResults[i] / (double)this.m_numFolds * 100.0, 3, 0) + " %)  " + Utils.doubleToString(i + 1, n, 0) + " " + this.m_trainInstances.attribute(i).name() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void selectAttributesCVSplit(Instances instances) throws Exception {
        double[][] dArray = null;
        if (this.m_trainInstances == null) {
            this.m_trainInstances = instances;
        }
        if (this.m_rankResults == null && this.m_subsetResults == null) {
            this.m_subsetResults = new double[instances.numAttributes()];
            this.m_rankResults = new double[4][instances.numAttributes()];
        }
        this.m_ASEvaluator.buildEvaluator(instances);
        int[] nArray = this.m_searchMethod.search(this.m_ASEvaluator, instances);
        nArray = this.m_ASEvaluator.postProcess(nArray);
        if (this.m_searchMethod instanceof RankedOutputSearch && this.m_doRank) {
            dArray = ((RankedOutputSearch)((Object)this.m_searchMethod)).rankedAttributes();
            for (int i = 0; i < dArray.length; ++i) {
                double[] dArray2 = this.m_rankResults[0];
                int n = (int)dArray[i][0];
                dArray2[n] = dArray2[n] + dArray[i][1];
                double[] dArray3 = this.m_rankResults[2];
                int n2 = (int)dArray[i][0];
                dArray3[n2] = dArray3[n2] + dArray[i][1] * dArray[i][1];
                double[] dArray4 = this.m_rankResults[1];
                int n3 = (int)dArray[i][0];
                dArray4[n3] = dArray4[n3] + (double)(i + 1);
                double[] dArray5 = this.m_rankResults[3];
                int n4 = (int)dArray[i][0];
                dArray5[n4] = dArray5[n4] + (double)((i + 1) * (i + 1));
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                this.m_subsetResults[n] = this.m_subsetResults[n] + 1.0;
            }
        }
        ++this.m_trials;
    }

    public String CrossValidateAttributes() throws Exception {
        Instances instances = new Instances(this.m_trainInstances);
        double[][] dArray = null;
        Random random = new Random(this.m_seed);
        instances.randomize(random);
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) && instances.classAttribute().isNominal()) {
            instances.stratify(this.m_numFolds);
        }
        for (int i = 0; i < this.m_numFolds; ++i) {
            Instances instances2 = instances.trainCV(this.m_numFolds, i, random);
            this.selectAttributesCVSplit(instances2);
        }
        return this.CVResultsString();
    }

    public void SelectAttributes(Instances instances) throws Exception {
        this.m_transformer = null;
        this.m_attributeFilter = null;
        this.m_trainInstances = instances;
        if (this.m_doXval && this.m_ASEvaluator instanceof AttributeTransformer) {
            throw new Exception("Can't cross validate an attribute transformer.");
        }
        if (this.m_ASEvaluator instanceof SubsetEvaluator && this.m_searchMethod instanceof Ranker) {
            throw new Exception(this.m_ASEvaluator.getClass().getName() + " must use a search method other than Ranker");
        }
        if (this.m_ASEvaluator instanceof AttributeEvaluator && !(this.m_searchMethod instanceof Ranker)) {
            throw new Exception("AttributeEvaluators must use the Ranker search method");
        }
        if (this.m_searchMethod instanceof RankedOutputSearch) {
            this.m_doRank = ((RankedOutputSearch)((Object)this.m_searchMethod)).getGenerateRanking();
        }
        if (!(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && this.m_trainInstances.classIndex() < 0) {
            this.m_trainInstances.setClassIndex(this.m_trainInstances.numAttributes() - 1);
        }
        this.m_ASEvaluator.buildEvaluator(this.m_trainInstances);
        if (this.m_ASEvaluator instanceof AttributeTransformer) {
            this.m_trainInstances = ((AttributeTransformer)((Object)this.m_ASEvaluator)).transformedHeader();
            this.m_transformer = (AttributeTransformer)((Object)this.m_ASEvaluator);
        }
        int n = (int)(Math.log(this.m_trainInstances.numAttributes()) + 1.0);
        int[] nArray = this.m_searchMethod.search(this.m_ASEvaluator, this.m_trainInstances);
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.m_searchMethod.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Class[] classArray;
                ASEvaluation aSEvaluation;
                String string = propertyDescriptorArray[i].getDisplayName();
                Method method = propertyDescriptorArray[i].getReadMethod();
                Class<?> clazz = method.getReturnType();
                if (!clazz.equals(class$weka$attributeSelection$ASEvaluation == null ? AttributeSelection.class$("weka.attributeSelection.ASEvaluation") : class$weka$attributeSelection$ASEvaluation) || !((aSEvaluation = (ASEvaluation)method.invoke((Object)this.m_searchMethod, (Object[])(classArray = new Class[0]))) instanceof AttributeTransformer)) continue;
                this.m_trainInstances = ((AttributeTransformer)((Object)aSEvaluation)).transformedHeader();
                this.m_transformer = (AttributeTransformer)((Object)aSEvaluation);
            }
        }
        catch (IntrospectionException introspectionException) {
            System.err.println("AttributeSelection: Couldn't introspect");
        }
        nArray = this.m_ASEvaluator.postProcess(nArray);
        if (!this.m_doRank) {
            this.m_selectionResults.append(this.printSelectionResults());
        }
        if (this.m_searchMethod instanceof RankedOutputSearch && this.m_doRank) {
            int n2;
            this.m_attributeRanking = ((RankedOutputSearch)((Object)this.m_searchMethod)).rankedAttributes();
            this.m_selectionResults.append(this.printSelectionResults());
            this.m_selectionResults.append("Ranked attributes:\n");
            this.m_numToSelect = ((RankedOutputSearch)((Object)this.m_searchMethod)).getCalculatedNumToSelect();
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < this.m_numToSelect; ++n2) {
                double d = Math.abs(this.m_attributeRanking[n2][1]) - (double)((int)Math.abs(this.m_attributeRanking[n2][1]));
                double d2 = (int)Math.abs(this.m_attributeRanking[n2][1]);
                if (d > 0.0) {
                    d = Math.abs(Math.log(Math.abs(d)) / Math.log(10.0)) + 3.0;
                }
                if (d > (double)n3) {
                    n3 = (int)d;
                }
                if (d2 == 0.0) {
                    if (n4 >= 2) continue;
                    n4 = 2;
                    continue;
                }
                if (!(Math.abs(Math.log(Math.abs(this.m_attributeRanking[n2][1])) / Math.log(10.0)) + 1.0 > (double)n4) || !(this.m_attributeRanking[n2][1] > 0.0)) continue;
                n4 = (int)Math.abs(Math.log(Math.abs(this.m_attributeRanking[n2][1])) / Math.log(10.0)) + 1;
            }
            for (n2 = 0; n2 < this.m_numToSelect; ++n2) {
                this.m_selectionResults.append(Utils.doubleToString(this.m_attributeRanking[n2][1], n3 + n4 + 1, n3) + Utils.doubleToString(this.m_attributeRanking[n2][0] + 1.0, n + 1, 0) + " " + this.m_trainInstances.attribute((int)this.m_attributeRanking[n2][0]).name() + "\n");
            }
            if (this.m_trainInstances.classIndex() >= 0) {
                if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) || this.m_ASEvaluator instanceof AttributeTransformer) {
                    this.m_selectedAttributeSet = new int[this.m_numToSelect + 1];
                    this.m_selectedAttributeSet[this.m_numToSelect] = this.m_trainInstances.classIndex();
                } else {
                    this.m_selectedAttributeSet = new int[this.m_numToSelect];
                }
            } else {
                this.m_selectedAttributeSet = new int[this.m_numToSelect];
            }
            this.m_selectionResults.append("\nSelected attributes: ");
            for (n2 = 0; n2 < this.m_numToSelect; ++n2) {
                this.m_selectedAttributeSet[n2] = (int)this.m_attributeRanking[n2][0];
                if (n2 == this.m_numToSelect - 1) {
                    this.m_selectionResults.append((int)this.m_attributeRanking[n2][0] + 1 + " : " + (n2 + 1) + "\n");
                    continue;
                }
                this.m_selectionResults.append((int)this.m_attributeRanking[n2][0] + 1);
                this.m_selectionResults.append(",");
            }
        } else {
            int n5;
            if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator) || this.m_trainInstances.classIndex() >= 0) {
                this.m_selectedAttributeSet = new int[nArray.length + 1];
                this.m_selectedAttributeSet[nArray.length] = this.m_trainInstances.classIndex();
            } else {
                this.m_selectedAttributeSet = new int[nArray.length];
            }
            for (n5 = 0; n5 < nArray.length; ++n5) {
                this.m_selectedAttributeSet[n5] = nArray[n5];
            }
            this.m_selectionResults.append("Selected attributes: ");
            for (n5 = 0; n5 < nArray.length; ++n5) {
                if (n5 == nArray.length - 1) {
                    this.m_selectionResults.append(nArray[n5] + 1 + " : " + nArray.length + "\n");
                    continue;
                }
                this.m_selectionResults.append(nArray[n5] + 1 + ",");
            }
            for (n5 = 0; n5 < nArray.length; ++n5) {
                this.m_selectionResults.append("                     " + this.m_trainInstances.attribute(nArray[n5]).name() + "\n");
            }
        }
        if (this.m_doXval) {
            this.m_selectionResults.append(this.CrossValidateAttributes());
        }
        if (this.m_selectedAttributeSet != null && !this.m_doXval) {
            this.m_attributeFilter = new Remove();
            this.m_attributeFilter.setAttributeIndicesArray(this.m_selectedAttributeSet);
            this.m_attributeFilter.setInvertSelection(true);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
        }
        this.m_trainInstances = new Instances(this.m_trainInstances, 0);
    }

    public static String SelectAttributes(ASEvaluation aSEvaluation, String[] stringArray, Instances instances) throws Exception {
        int n = 1;
        int n2 = 10;
        String[] stringArray2 = null;
        ASSearch aSSearch = null;
        boolean bl = false;
        int n3 = -1;
        double d = -1.7976931348623157E308;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        Range range = new Range();
        AttributeSelection attributeSelection = new AttributeSelection();
        try {
            String string;
            String string2;
            String string3;
            if (Utils.getFlag('h', stringArray)) {
                bl2 = true;
            }
            if ((string3 = Utils.getOption('c', stringArray)).length() != 0) {
                n3 = string3.equals("first") ? 1 : (string3.equals("last") ? instances.numAttributes() : Integer.parseInt(string3));
            }
            if (n3 != -1 && (n3 == 0 || n3 > instances.numAttributes())) {
                throw new Exception("Class index out of range.");
            }
            if (n3 != -1) {
                instances.setClassIndex(n3 - 1);
            }
            if ((string2 = Utils.getOption('x', stringArray)).length() != 0) {
                n2 = Integer.parseInt(string2);
                bl = true;
            }
            attributeSelection.setFolds(n2);
            attributeSelection.setXval(bl);
            String string4 = Utils.getOption('n', stringArray);
            if (string4.length() != 0) {
                n = Integer.parseInt(string4);
            }
            attributeSelection.setSeed(n);
            String string5 = Utils.getOption('s', stringArray);
            if (string5.length() == 0 && !(aSEvaluation instanceof AttributeEvaluator)) {
                throw new Exception("No search method given.");
            }
            if (string5.length() != 0) {
                string5 = string5.trim();
                int n4 = string5.indexOf(32);
                string = string5;
                String string6 = "";
                if (n4 != -1) {
                    string = string5.substring(0, n4);
                    string6 = string5.substring(n4).trim();
                    stringArray2 = Utils.splitOptions(string6);
                }
            } else {
                try {
                    string = new String("weka.attributeSelection.Ranker");
                    aSSearch = (ASSearch)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    throw new Exception("Can't create Ranker object");
                }
            }
            if (aSSearch == null) {
                aSSearch = ASSearch.forName(string, stringArray2);
            }
            attributeSelection.setSearch(aSSearch);
        }
        catch (Exception exception) {
            throw new Exception('\n' + exception.getMessage() + AttributeSelection.makeOptionString(aSEvaluation, aSSearch));
        }
        try {
            if (aSEvaluation instanceof OptionHandler) {
                ((OptionHandler)((Object)aSEvaluation)).setOptions(stringArray);
            }
        }
        catch (Exception exception) {
            throw new Exception("\n" + exception.getMessage() + AttributeSelection.makeOptionString(aSEvaluation, aSSearch));
        }
        try {
            Utils.checkForRemainingOptions(stringArray);
        }
        catch (Exception exception) {
            throw new Exception('\n' + exception.getMessage() + AttributeSelection.makeOptionString(aSEvaluation, aSSearch));
        }
        if (bl2) {
            System.out.println(AttributeSelection.makeOptionString(aSEvaluation, aSSearch));
            System.exit(0);
        }
        attributeSelection.setEvaluator(aSEvaluation);
        attributeSelection.SelectAttributes(instances);
        return attributeSelection.toResultsString();
    }

    private String printSelectionResults() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n=== Attribute Selection on all input data ===\n\nSearch Method:\n");
        stringBuffer.append(this.m_searchMethod.toString());
        stringBuffer.append("\nAttribute ");
        if (this.m_ASEvaluator instanceof SubsetEvaluator) {
            stringBuffer.append("Subset Evaluator (");
        } else {
            stringBuffer.append("Evaluator (");
        }
        if (!(this.m_ASEvaluator instanceof UnsupervisedSubsetEvaluator) && !(this.m_ASEvaluator instanceof UnsupervisedAttributeEvaluator)) {
            stringBuffer.append("supervised, ");
            stringBuffer.append("Class (");
            if (this.m_trainInstances.attribute(this.m_trainInstances.classIndex()).isNumeric()) {
                stringBuffer.append("numeric): ");
            } else {
                stringBuffer.append("nominal): ");
            }
            stringBuffer.append(this.m_trainInstances.classIndex() + 1 + " " + this.m_trainInstances.attribute(this.m_trainInstances.classIndex()).name() + "):\n");
        } else {
            stringBuffer.append("unsupervised):\n");
        }
        stringBuffer.append(this.m_ASEvaluator.toString() + "\n");
        return stringBuffer.toString();
    }

    private static String makeOptionString(ASEvaluation aSEvaluation, ASSearch aSSearch) throws Exception {
        Option option;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n\nGeneral options:\n\n");
        stringBuffer.append("-h display this help\n");
        stringBuffer.append("-i <name of input file>\n");
        stringBuffer.append("\tSets training file.\n");
        stringBuffer.append("-c <class index>\n");
        stringBuffer.append("\tSets the class index for supervised attribute\n");
        stringBuffer.append("\tselection. Default=last column.\n");
        stringBuffer.append("-s <Class name>\n");
        stringBuffer.append("\tSets search method for subset evaluators.\n");
        stringBuffer.append("-x <number of folds>\n");
        stringBuffer.append("\tPerform a cross validation.\n");
        stringBuffer.append("-n <random number seed>\n");
        stringBuffer.append("\tUse in conjunction with -X.\n");
        if (aSEvaluation instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + aSEvaluation.getClass().getName() + ":\n\n");
            enumeration = ((OptionHandler)((Object)aSEvaluation)).listOptions();
            while (enumeration.hasMoreElements()) {
                option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + "\n");
            }
        }
        if (aSSearch != null) {
            if (aSSearch instanceof OptionHandler) {
                stringBuffer.append("\nOptions specific to " + aSSearch.getClass().getName() + ":\n\n");
                enumeration = ((OptionHandler)((Object)aSSearch)).listOptions();
                while (enumeration.hasMoreElements()) {
                    option = (Option)enumeration.nextElement();
                    stringBuffer.append(option.synopsis() + '\n');
                    stringBuffer.append(option.description() + "\n");
                }
            }
        } else if (aSEvaluation instanceof SubsetEvaluator) {
            System.out.println("No search method given.");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the name of an attribute/subset evaluator");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            ASEvaluation aSEvaluation = ASEvaluation.forName(string, null);
            System.out.println(AttributeSelection.SelectAttributes(aSEvaluation, stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

