### R code from vignette source 'specL.Rnw'

###################################################
### code chunk number 1: style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: specL.Rnw:76-78
###################################################
rm(list=ls())
options(width = 80)


###################################################
### code chunk number 3: specL.Rnw:81-83
###################################################
library(specL)
packageVersion('specL')


###################################################
### code chunk number 4: specL.Rnw:97-98
###################################################
summary(peptideStd)


###################################################
### code chunk number 5: specL.Rnw:109-111
###################################################
# plot(peptideStd)
plot(0,0, main='MISSING')


###################################################
### code chunk number 6: specL.Rnw:117-121
###################################################
demoIdx <- 40
# str(peptideStd[[demoIdx]])
#res <- plot(peptideStd[[demoIdx]], ion.axes=TRUE)
plot(0,0, main='MISSING')


###################################################
### code chunk number 7: specL.Rnw:147-148
###################################################
specL:::.mascot2psmSet


###################################################
### code chunk number 8: specL.Rnw:173-183
###################################################
irtFASTAseq <- paste(">zz|ZZ_FGCZCont0260|",
"iRT_Protein_with_AAAAK_spacers concatenated Biognosys\n",
"LGGNEQVTRAAAAKGAGSSEPVTGLDAKAAAAKVEATFGVDESNAKAAAAKYILAGVENS",
"KAAAAKTPVISGGPYEYRAAAAKTPVITGAPYEYRAAAAKDGLDAASYYAPVRAAAAKAD",
"VTPADFSEWSKAAAAKGTFIIDPGGVIRAAAAKGTFIIDPAAVIRAAAAKLFLQFGAQGS",
"PFLK\n")

Tfile <- file();  cat(irtFASTAseq, file = Tfile);
fasta.irtFASTAseq <- read.fasta(Tfile, as.string=TRUE, seqtype="AA")
close(Tfile)


###################################################
### code chunk number 9: specL.Rnw:189-190
###################################################
peptideStd[[demoIdx]]$proteinInformation


###################################################
### code chunk number 10: specL.Rnw:194-196
###################################################
peptideStd <- annotate.protein_id(peptideStd, 
    fasta=fasta.irtFASTAseq)


###################################################
### code chunk number 11: specL.Rnw:202-204
###################################################
(idx<-which(unlist(lapply(peptideStd, 
    function(x){nchar(x$proteinInformation)>0}))))


###################################################
### code chunk number 12: specL.Rnw:210-211
###################################################
peptideStd[[demoIdx]]$proteinInformation


###################################################
### code chunk number 13: specL.Rnw:216-217 (eval = FALSE)
###################################################
## digestPattern = "(([RK])|(^)|(^M))"


###################################################
### code chunk number 14: specL.Rnw:233-235
###################################################
res.genSwathIonLib <- genSwathIonLib(data=peptideStd, 
                                     data.fit=peptideStd.redundant)


###################################################
### code chunk number 15: specL.Rnw:257-258
###################################################
summary(res.genSwathIonLib)


###################################################
### code chunk number 16: specL.Rnw:265-266
###################################################
res.genSwathIonLib@ionlibrary[[demoIdx]]


###################################################
### code chunk number 17: specL.Rnw:270-271
###################################################
plot(res.genSwathIonLib@ionlibrary[[demoIdx]])


###################################################
### code chunk number 18: specL.Rnw:275-288
###################################################
# define customized fragment ions
# for demonstration lets consider only the top five singly charged y ions.

r.genSwathIonLib.top5 <- genSwathIonLib(peptideStd,
    peptideStd.redundant, topN=5,
    fragmentIonFUN=function (b, y) {
      return( cbind(y1_=y) )
      }
    )

             
plot(r.genSwathIonLib.top5@ionlibrary[[demoIdx]])



###################################################
### code chunk number 19: specL.Rnw:321-322 (eval = FALSE)
###################################################
## iRTpeptides


###################################################
### code chunk number 20: specL.Rnw:328-330 (eval = FALSE)
###################################################
## fit <- lm(formula = rt ~ aggregateInputRT * fileName, data=m)
## 


###################################################
### code chunk number 21: specL.Rnw:337-341 (eval = FALSE)
###################################################
## data<-aggregate(df$rt, by=list(df$peptide, df$fileName), FUN=mean)
## data.fit<-aggregate(df.fit$rt, 
##                     by=list(df.fit$peptide, df.fit$fileName), 
##                     FUN=mean)


###################################################
### code chunk number 22: specL.Rnw:346-347 (eval = FALSE)
###################################################
## m <- merge(iRT, data.fit, by.x='peptide', by.y='peptide')


###################################################
### code chunk number 23: specL.Rnw:357-361
###################################################
# calls the plot method for a specLSet object
op<-par(mfrow=c(2,3)) 
plot(res.genSwathIonLib)
par(op)


###################################################
### code chunk number 24: specL.Rnw:372-382
###################################################
idx.iRT<-which(unlist(lapply(peptideStd, function(x){
  if(x$peptideSequence %in% iRTpeptides$peptide){0}else{1}
  })) == 0)

# remove all iRTs and compute ion library
res.genSwathIonLib.no_iRT <- genSwathIonLib(peptideStd[-idx.iRT])
summary(res.genSwathIonLib.no_iRT)
op<-par(mfrow=c(2,3)) 
plot(res.genSwathIonLib.no_iRT)
par(op)


###################################################
### code chunk number 25: specL.Rnw:388-389
###################################################
write.spectronaut(res.genSwathIonLib, file="specL-Spectronaut.txt")


###################################################
### code chunk number 26: specL.Rnw:429-433 (eval = FALSE)
###################################################
## res <- genSwathIonLib(data, data.fit,
##   topN=10, 
##   fragmentIonMzRange=c(200,2000), 
##   fragmentIonRange=c(2,100))


###################################################
### code chunk number 27: sessioninfo
###################################################
toLatex(sessionInfo())


