## ----knitr-options, echo=FALSE, message=FALSE, warning=FALSE---------------
## To render an HTML version that works nicely with github and web pages, do:
## rmarkdown::render("vignettes/vignette.Rmd", "all")
library(knitr)
opts_chunk$set(fig.align = 'center', fig.width = 6, fig.height = 5, dev = 'png',
    warning=FALSE, error=FALSE, message=FALSE)
library(ggplot2)
theme_set(theme_bw(12))

## ----quickstart-load-data, message=FALSE, warning=FALSE--------------------
library(scater)
data("sc_example_counts")
data("sc_example_cell_info")
example_sce <- SingleCellExperiment(
    assays = list(counts = sc_example_counts), 
    colData = sc_example_cell_info
)
example_sce

## ----quickstart-add-exprs, results='hide'----------------------------------
str(counts(example_sce))

## --------------------------------------------------------------------------
example_sce$whee <- sample(LETTERS, ncol(example_sce), replace=TRUE)
colData(example_sce)
rowData(example_sce)$stuff <- runif(nrow(example_sce))
rowData(example_sce)

## ----filter-no-exprs-------------------------------------------------------
keep_feature <- rowSums(counts(example_sce) > 0) > 0
example_sce <- example_sce[keep_feature,]

## --------------------------------------------------------------------------
cpm(example_sce) <- calculateCPM(example_sce)

## --------------------------------------------------------------------------
example_sce <- normalize(example_sce)
assayNames(example_sce)

## --------------------------------------------------------------------------
identical(exprs(example_sce), logcounts(example_sce))

## --------------------------------------------------------------------------
assay(example_sce, "is_expr") <- counts(example_sce)>0

## ---- eval=FALSE-----------------------------------------------------------
#  # Example if in the kallisto/test directory
#  setwd("/home/davis/kallisto/test")
#  kallisto_log <- runKallisto("targets.txt", "transcripts.idx", single_end=FALSE,
#              output_prefix="output", verbose=TRUE, n_bootstrap_samples=10)
#  sce_test <- readKallistoResults(kallisto_log, read_h5=TRUE)
#  sce_test

## --------------------------------------------------------------------------
sessionInfo()

