/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Sample;
import com.compomics.util.experiment.quantification.Quantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ReporterIonQuantification
extends Quantification {
    private HashMap<String, Sample> sampleAssignement = new HashMap();
    private ArrayList<String> controlSamples;
    private HashMap<String, Double> normalisationFactors = new HashMap();
    private ReporterMethod reporterMethod;

    public ReporterIonQuantification(Quantification.QuantificationMethod methodUsed) {
        this.methodUsed = methodUsed;
    }

    public void assignSample(String reporterName, Sample sample) {
        this.sampleAssignement.put(reporterName, sample);
    }

    public Sample getSample(String reporterIonName) {
        return this.sampleAssignement.get(reporterIonName);
    }

    public String getReporterIndex(Sample aSample) {
        for (String ionName : this.sampleAssignement.keySet()) {
            if (!this.sampleAssignement.get(ionName).isSameAs(aSample)) continue;
            return ionName;
        }
        return null;
    }

    public ReporterMethod getReporterMethod() {
        return this.reporterMethod;
    }

    public void setMethod(ReporterMethod reporterMethod) {
        this.reporterMethod = reporterMethod;
    }

    public static String getDefaultReference(String experimentReference, String sampleReference, int replicateNumber) {
        return Util.removeForbiddenCharacters(experimentReference + "_" + sampleReference + "_" + replicateNumber + "_reporterQuant");
    }

    public ArrayList<String> getControlSamples() {
        return this.controlSamples;
    }

    public void setControlSamples(ArrayList<String> controlSamples) {
        this.controlSamples = controlSamples;
    }

    public boolean hasNormalisationFactors() {
        return !this.normalisationFactors.isEmpty();
    }

    public void resetNormalisationFactors() {
        this.normalisationFactors.clear();
    }

    public void addNormalisationFactor(String reporterIonName, double normalisationFactor) {
        this.normalisationFactors.put(reporterIonName, normalisationFactor);
    }

    public double getNormalisationFactor(String reporterIonName) {
        Double normalisationFactor = this.normalisationFactors.get(reporterIonName);
        if (normalisationFactor == null) {
            return 1.0;
        }
        return normalisationFactor;
    }

    public Set<String> getSampleIndexes() {
        return this.sampleAssignement.keySet();
    }
}

