/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cise;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.cise.CiSEEdge;
import org.ivis.layout.cise.CiSEInterClusterEdgeInfo;
import org.ivis.layout.cise.CiSEInterClusterEdgeSort;
import org.ivis.layout.cise.CiSELayout;
import org.ivis.layout.cise.CiSENode;
import org.ivis.layout.cise.CiSENodeSort;
import org.ivis.layout.cise.CiSEOnCircleNodeExt;
import org.ivis.layout.cise.CircularForce;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;
import org.ivis.util.alignment.BasicScoringScheme;
import org.ivis.util.alignment.IncompatibleScoringSchemeException;
import org.ivis.util.alignment.InvalidSequenceException;
import org.ivis.util.alignment.NeedlemanWunsch;

public class CiSECircle
extends LGraph {
    private List<CiSEEdge> intraClusterEdges = null;
    private List<CiSEEdge> interClusterEdges = null;
    private Set<CiSENode> inNodes = new HashSet<CiSENode>();
    private Set<CiSENode> outNodes = new HashSet<CiSENode>();
    private List<CiSENode> onCircleNodes = new ArrayList<CiSENode>();
    private List<CiSENode> inCircleNodes = new ArrayList<CiSENode>();
    private double radius;
    private boolean[][] orderMatrix = null;
    private boolean mayBeReversed = true;

    public CiSECircle(LNode parent, LGraphManager graphMgr, Object vNode) {
        super(parent, graphMgr, vNode);
    }

    public CiSENode getChildAt(int index) {
        return this.getOnCircleNodes().get(index);
    }

    @Override
    public LNode add(LNode newNode) {
        this.onCircleNodes.add((CiSENode)newNode);
        return super.add(newNode);
    }

    public void rotate() {
        CiSENode parentNode = (CiSENode)this.getParent();
        int noOfNodes = this.getOnCircleNodes().size();
        double rotationAmount = parentNode.rotationAmount / (double)noOfNodes;
        CiSELayout layout = (CiSELayout)this.getGraphManager().getLayout();
        if (rotationAmount != 0.0) {
            double teta = rotationAmount / this.radius;
            if (teta > 0.08726646259971647) {
                teta = 0.08726646259971647;
            } else if (teta < -0.08726646259971647) {
                teta = -0.08726646259971647;
            }
            for (int i = 0; i < noOfNodes; ++i) {
                CiSENode onCircleNode = this.getChildAt(i);
                CiSEOnCircleNodeExt onCircleNodeExt = onCircleNode.getOnCircleNodeExt();
                onCircleNodeExt.setAngle(onCircleNodeExt.getAngle() + teta);
                onCircleNodeExt.updatePosition();
            }
            layout.totalDisplacement += parentNode.rotationAmount;
            parentNode.rotationAmount = 0.0;
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public Set<CiSENode> getInNodes() {
        return this.inNodes;
    }

    public Set<CiSENode> getOutNodes() {
        return this.outNodes;
    }

    public List<CiSENode> getOnCircleNodes() {
        return this.onCircleNodes;
    }

    public List<CiSENode> getInCircleNodes() {
        return this.inCircleNodes;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean getOrder(CiSENode nodeA, CiSENode nodeB) {
        assert (this.orderMatrix != null);
        assert (nodeA != null && nodeB != null && nodeA.getOnCircleNodeExt() != null && nodeA.getOnCircleNodeExt() != null);
        return this.orderMatrix[nodeA.getOnCircleNodeExt().getIndex()][nodeB.getOnCircleNodeExt().getIndex()];
    }

    public void computeOrderMatrix() {
        assert (this.orderMatrix == null);
        int N = this.onCircleNodes.size();
        this.orderMatrix = new boolean[N][N];
        Iterator<CiSENode> nodeIterA = this.onCircleNodes.iterator();
        for (int i = 0; i < N; ++i) {
            CiSENode nodeA = nodeIterA.next();
            Iterator<CiSENode> nodeIterB = this.onCircleNodes.iterator();
            for (int j = 0; j < N; ++j) {
                CiSENode nodeB = nodeIterB.next();
                if (j <= i) continue;
                double angleDiff = nodeB.getOnCircleNodeExt().getAngle() - nodeA.getOnCircleNodeExt().getAngle();
                if (angleDiff < 0.0) {
                    angleDiff += Math.PI * 2;
                }
                if (angleDiff <= Math.PI) {
                    this.orderMatrix[i][j] = true;
                    this.orderMatrix[j][i] = false;
                    continue;
                }
                this.orderMatrix[i][j] = false;
                this.orderMatrix[j][i] = true;
            }
        }
    }

    public boolean mayBeReversed() {
        return this.mayBeReversed;
    }

    public void setMayNotBeReversed() {
        assert (this.mayBeReversed);
        this.mayBeReversed = false;
    }

    public CiSENode getThisEnd(CiSEEdge edge) {
        assert (!edge.isIntraCluster);
        CiSENode sourceNode = (CiSENode)edge.getSource();
        CiSENode targetNode = (CiSENode)edge.getTarget();
        if (sourceNode.getOwner() == this) {
            return sourceNode;
        }
        assert (targetNode.getOwner() == this);
        return targetNode;
    }

    public CiSENode getOtherEnd(CiSEEdge edge) {
        assert (!edge.isIntraCluster);
        CiSENode sourceNode = (CiSENode)edge.getSource();
        CiSENode targetNode = (CiSENode)edge.getTarget();
        if (sourceNode.getOwner() == this) {
            return targetNode;
        }
        assert (targetNode.getOwner() == this);
        return sourceNode;
    }

    public void calculateParentNodeDimension() {
        assert (this.getOnCircleNodes().size() != 0);
        double maxOnCircleNodeDimension = -2.147483648E9;
        for (LNode lNode : this.getOnCircleNodes()) {
            if (lNode.getWidth() > maxOnCircleNodeDimension) {
                maxOnCircleNodeDimension = lNode.getWidth();
            }
            if (!(lNode.getHeight() > maxOnCircleNodeDimension)) continue;
            maxOnCircleNodeDimension = lNode.getHeight();
        }
        double d = 2.0 * (this.radius + (double)this.getMargin()) + maxOnCircleNodeDimension;
        LNode parentNode = this.getParent();
        parentNode.setHeight(d);
        parentNode.setWidth(d);
    }

    public CircularForce decomposeForce(CiSENode node) {
        CircularForce circularForce;
        assert (node.getOwner() == this) : "The node must belong to this circle";
        if (node.displacementX != 0.0 || node.displacementY != 0.0) {
            boolean isRotationClockwise;
            LNode ownerNode = this.getParent();
            double Cx = ownerNode.getCenterX();
            double Cy = ownerNode.getCenterY();
            double Nx = node.getCenterX();
            double Ny = node.getCenterY();
            double Fx = node.displacementX;
            double Fy = node.displacementY;
            double C_angle = IGeometry.angleOfVector(Cx, Cy, Nx, Ny);
            double F_angle = IGeometry.angleOfVector(0.0, 0.0, Fx, Fy);
            double C_rev_angle = C_angle + Math.PI;
            assert (Math.PI <= C_rev_angle && C_rev_angle <= Math.PI * 3);
            if (Math.PI <= C_rev_angle && C_rev_angle < Math.PI * 2) {
                isRotationClockwise = C_angle <= F_angle && F_angle < C_rev_angle;
            } else {
                assert (0.0 <= (C_rev_angle -= Math.PI * 2) && C_rev_angle <= Math.PI);
                isRotationClockwise = !(C_rev_angle <= F_angle) || !(F_angle < C_angle);
            }
            double angle_diff = Math.abs(C_angle - F_angle);
            double F_magnitude = Math.sqrt(Fx * Fx + Fy * Fy);
            double R_magnitude = Math.abs(Math.sin(angle_diff) * F_magnitude);
            if (!isRotationClockwise) {
                R_magnitude = -R_magnitude;
            }
            circularForce = new CircularForce(R_magnitude, Fx, Fy);
        } else {
            circularForce = new CircularForce(0.0, 0.0, 0.0);
        }
        return circularForce;
    }

    public void swapNodes(CiSENode first, CiSENode second) {
        assert (first.getOwner() == this && second.getOwner() == this);
        CiSENode smallIndexNode = first;
        CiSENode bigIndexNode = second;
        CiSEOnCircleNodeExt firstExt = first.getOnCircleNodeExt();
        CiSEOnCircleNodeExt secondExt = second.getOnCircleNodeExt();
        if (smallIndexNode.getOnCircleNodeExt().getIndex() > second.getOnCircleNodeExt().getIndex()) {
            smallIndexNode = second;
            bigIndexNode = first;
        }
        if (smallIndexNode.getOnCircleNodeExt().getPrevNode() == bigIndexNode) {
            CiSENode tempNode = bigIndexNode;
            bigIndexNode = smallIndexNode;
            smallIndexNode = tempNode;
        }
        CiSEOnCircleNodeExt smallIndexNodeExt = smallIndexNode.getOnCircleNodeExt();
        CiSEOnCircleNodeExt bigIndexNodeExt = bigIndexNode.getOnCircleNodeExt();
        CiSENode smallIndexPrevNode = smallIndexNodeExt.getPrevNode();
        CiSELayout layout = (CiSELayout)this.getGraphManager().getLayout();
        int nodeSeparation = layout.getNodeSeparation();
        double angle = (smallIndexPrevNode.getOnCircleNodeExt().getAngle() + (smallIndexPrevNode.getHalfTheDiagonal() + bigIndexNode.getHalfTheDiagonal() + (double)nodeSeparation) / this.radius) % (Math.PI * 2);
        bigIndexNodeExt.setAngle(angle);
        angle = (bigIndexNodeExt.getAngle() + (bigIndexNode.getHalfTheDiagonal() + smallIndexNode.getHalfTheDiagonal() + (double)nodeSeparation) / this.radius) % (Math.PI * 2);
        smallIndexNodeExt.setAngle(angle);
        smallIndexNodeExt.updatePosition();
        bigIndexNodeExt.updatePosition();
        int tempIndex = firstExt.getIndex();
        firstExt.setIndex(secondExt.getIndex());
        secondExt.setIndex(tempIndex);
        this.getOnCircleNodes().set(firstExt.getIndex(), first);
        this.getOnCircleNodes().set(secondExt.getIndex(), second);
        firstExt.updateSwappingConditions();
        secondExt.updateSwappingConditions();
        if (firstExt.getNextNode() == second) {
            firstExt.getPrevNode().getOnCircleNodeExt().updateSwappingConditions();
            secondExt.getNextNode().getOnCircleNodeExt().updateSwappingConditions();
        } else {
            firstExt.getNextNode().getOnCircleNodeExt().updateSwappingConditions();
            secondExt.getPrevNode().getOnCircleNodeExt().updateSwappingConditions();
        }
    }

    public List<CiSEEdge> getIntraClusterEdges() {
        if (this.intraClusterEdges == null) {
            this.intraClusterEdges = new ArrayList<CiSEEdge>();
            for (CiSEEdge edge : this.getEdges()) {
                if (!edge.isIntraCluster) continue;
                this.intraClusterEdges.add(edge);
            }
        }
        return this.intraClusterEdges;
    }

    public List<CiSEEdge> getInterClusterEdges() {
        if (this.interClusterEdges == null) {
            this.interClusterEdges = new ArrayList<CiSEEdge>();
            for (CiSENode node : this.outNodes) {
                this.interClusterEdges.addAll(node.getOnCircleNodeExt().getInterClusterEdges());
            }
        }
        return this.interClusterEdges;
    }

    public boolean checkAndReverseIfReverseIsBetter() {
        CiSENode endInThisCluster;
        CiSEEdge interClusterEdge;
        assert (this.mayBeReversed);
        ArrayList interClusterEdges = (ArrayList)this.getInterClusterEdges();
        Object[] interClusterEdgeInfos = new CiSEInterClusterEdgeInfo[interClusterEdges.size()];
        PointD clusterCenter = this.getParent().getCenter();
        int nodeCount = this.onCircleNodes.size();
        int[] interClusterEdgeDegree = new int[nodeCount];
        int noOfOnCircleNodesToBeRepeated = 0;
        for (int i = 0; i < interClusterEdges.size(); ++i) {
            interClusterEdge = (CiSEEdge)interClusterEdges.get(i);
            CiSENode endInOtherCluster = this.getOtherEnd(interClusterEdge);
            PointD centerOfEndInOtherCluster = endInOtherCluster.getCenter();
            double angle = IGeometry.angleOfVector(clusterCenter.x, clusterCenter.y, centerOfEndInOtherCluster.x, centerOfEndInOtherCluster.y);
            interClusterEdgeInfos[i] = new CiSEInterClusterEdgeInfo(interClusterEdge, angle);
            endInThisCluster = this.getThisEnd(interClusterEdge);
            int n = endInThisCluster.getOnCircleNodeExt().getIndex();
            interClusterEdgeDegree[n] = interClusterEdgeDegree[n] + 1;
            if (interClusterEdgeDegree[endInThisCluster.getOnCircleNodeExt().getIndex()] <= 1) continue;
            ++noOfOnCircleNodesToBeRepeated;
        }
        Object[] onCircleNodes = this.onCircleNodes.toArray();
        int nodeCountWithRepetitions = nodeCount + noOfOnCircleNodesToBeRepeated;
        char[] clusterNodes = new char[2 * nodeCountWithRepetitions];
        char[] reversedClusterNodes = new char[2 * nodeCountWithRepetitions];
        int index = -1;
        for (int i = 0; i < nodeCount; ++i) {
            CiSENode node = (CiSENode)onCircleNodes[i];
            if (interClusterEdgeDegree[i] == 0) {
                interClusterEdgeDegree[i] = 1;
            }
            for (int j = 0; j < interClusterEdgeDegree[i]; ++j) {
                char c = node.getOnCircleNodeExt().getCharCode();
                reversedClusterNodes[2 * nodeCountWithRepetitions - 1 - ++index] = c;
                reversedClusterNodes[nodeCountWithRepetitions - 1 - index] = c;
                clusterNodes[nodeCountWithRepetitions + index] = c;
                clusterNodes[index] = c;
            }
        }
        CiSEInterClusterEdgeSort edgeSorter = new CiSEInterClusterEdgeSort(this, interClusterEdgeInfos);
        edgeSorter.quicksort();
        char[] neighborNodes = new char[interClusterEdgeInfos.length];
        for (int i = 0; i < interClusterEdgeInfos.length; ++i) {
            interClusterEdge = ((CiSEInterClusterEdgeInfo)interClusterEdgeInfos[i]).getEdge();
            endInThisCluster = this.getThisEnd(interClusterEdge);
            neighborNodes[i] = endInThisCluster.getOnCircleNodeExt().getCharCode();
        }
        int alignmentScoreCurrent = CiSECircle.computeAlignmentScore(new CharArrayReader(clusterNodes), new CharArrayReader(neighborNodes));
        if (alignmentScoreCurrent != -1) {
            int alignmentScoreReversed = CiSECircle.computeAlignmentScore(new CharArrayReader(reversedClusterNodes), new CharArrayReader(neighborNodes));
            if (alignmentScoreReversed != -1 && alignmentScoreReversed > alignmentScoreCurrent) {
                this.reverseNodes();
                this.setMayNotBeReversed();
                return true;
            }
        }
        return false;
    }

    public static int computeAlignmentScore(CharArrayReader charArrayReader1, CharArrayReader charArrayReader2) {
        int alignmentScore;
        NeedlemanWunsch aligner = new NeedlemanWunsch();
        aligner.setScoringScheme(new BasicScoringScheme(20, -1, -2));
        try {
            aligner.loadSequences(charArrayReader1, charArrayReader2);
        }
        catch (IOException e2) {
            System.err.println("Caught IOException: " + e2.getMessage());
        }
        catch (InvalidSequenceException e3) {
            System.err.println("Caught InvalidSequenceException: " + e3.getMessage());
        }
        try {
            aligner.getPairwiseAlignment();
            alignmentScore = aligner.getScore();
        }
        catch (IncompatibleScoringSchemeException e4) {
            alignmentScore = -1;
        }
        return alignmentScore;
    }

    protected void reverseNodes() {
        Iterator<CiSENode> iterator = this.getOnCircleNodes().iterator();
        int noOfNodesOnCircle = this.getOnCircleNodes().size();
        while (iterator.hasNext()) {
            CiSENode node = iterator.next();
            CiSEOnCircleNodeExt nodeExt = node.getOnCircleNodeExt();
            nodeExt.setIndex((noOfNodesOnCircle - nodeExt.getIndex()) % noOfNodesOnCircle);
        }
        this.reCalculateNodeAnglesAndPositions();
    }

    public void moveOnCircleNodeInside(CiSENode node) {
        assert (node.getOnCircleNodeExt() != null);
        this.onCircleNodes.remove(node);
        this.inCircleNodes.add(node);
        for (int i = 0; i < this.onCircleNodes.size(); ++i) {
            CiSENode onCircleNode = this.onCircleNodes.get(i);
            onCircleNode.getOnCircleNodeExt().setIndex(i);
        }
        node.setAsNonOnCircleNode();
        this.reCalculateCircleSizeAndRadius();
        this.reCalculateNodeAnglesAndPositions();
        node.setCenter(this.getParent().getCenterX(), this.getParent().getCenterY());
    }

    public void reCalculateCircleSizeAndRadius() {
        double totalDiagonal = 0.0;
        for (LNode lNode : this.getOnCircleNodes()) {
            double temp = lNode.getWidth() * lNode.getWidth() + lNode.getHeight() * lNode.getHeight();
            totalDiagonal += Math.sqrt(temp);
        }
        CiSELayout ciSELayout = (CiSELayout)this.getGraphManager().getLayout();
        int nodeSeparation = ciSELayout.getNodeSeparation();
        double perimeter = totalDiagonal + (double)(this.getOnCircleNodes().size() * nodeSeparation);
        this.radius = perimeter / (Math.PI * 2);
        this.calculateParentNodeDimension();
    }

    public void reCalculateNodeAnglesAndPositions() {
        CiSELayout layout = (CiSELayout)this.getGraphManager().getLayout();
        int nodeSeparation = layout.getNodeSeparation();
        List<Object> inOrderCopy = this.onCircleNodes;
        new CiSENodeSort(inOrderCopy).quicksort();
        double parentCenterX = this.getParent().getCenterX();
        double parentCenterY = this.getParent().getCenterY();
        for (int i = 0; i < inOrderCopy.size(); ++i) {
            Double angle;
            CiSENode node = (CiSENode)inOrderCopy.get(i);
            if (i == 0) {
                angle = 0.0;
            } else {
                CiSENode previousNode = (CiSENode)inOrderCopy.get(i - 1);
                angle = previousNode.getOnCircleNodeExt().getAngle() + (node.getHalfTheDiagonal() + (double)nodeSeparation + previousNode.getHalfTheDiagonal()) / this.radius;
            }
            node.getOnCircleNodeExt().setAngle(angle);
            node.setCenter(parentCenterX + this.radius * Math.cos(angle), parentCenterY + this.radius * Math.sin(angle));
        }
    }

    public static void main(String[] args) {
        char[] charArrayA = new char[]{'a', 'b', 'c', 'd', 'e', 'a', 'b', 'c', 'd', 'e'};
        char[] charArrayB = new char[]{'c', 'b', 'd', 'c', 'b', 'd'};
        CiSECircle.computeAlignmentScore(new CharArrayReader(charArrayA), new CharArrayReader(charArrayB));
    }
}

