/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    int elementNameCode;
    int elementTypeCode;
    int elementLocationId;
    int elementProperties;
    AttributeCollectionImpl bufferedAttributes;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
        this.bufferedAttributes = new AttributeCollectionImpl(this.getNamePool());
    }

    public void startElement(int n, int n2, int n4, int n5) throws XPathException {
        this.elementNameCode = n;
        this.elementTypeCode = n2;
        this.elementLocationId = n4;
        this.elementProperties = n5;
        this.bufferedAttributes.clear();
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] nArray = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.depth);
            this.countStack = nArray;
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        this.addToStack(n);
        int n4 = this.depth - 1;
        this.countStack[n4] = this.countStack[n4] + 1;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n4, int n5) throws XPathException {
        this.bufferedAttributes.addAttribute(n, n2, ((Object)charSequence).toString(), n4, n5);
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void startContent() throws XPathException {
        super.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, this.elementProperties);
        this.declareNamespacesForStartElement();
        int n = this.bufferedAttributes.getLength();
        for (int i = 0; i < n; ++i) {
            super.attribute(this.bufferedAttributes.getNameCode(i), this.bufferedAttributes.getTypeAnnotation(i), this.bufferedAttributes.getValue(i), this.bufferedAttributes.getLocationId(i), this.bufferedAttributes.getProperties(i));
        }
        super.startContent();
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        for (int i = this.namespacesSize - this.countStack[this.depth - 1]; i < this.namespacesSize; ++i) {
            super.namespace(this.namespaces[i], 0);
        }
    }

    protected void declareAllNamespaces() throws XPathException {
        for (int i = 0; i < this.namespacesSize; ++i) {
            super.namespace(this.namespaces[i], 0);
        }
    }

    public void endElement() throws XPathException {
        super.endElement();
        this.undeclareNamespacesForElement();
    }

    protected void undeclareNamespacesForElement() {
        int n = this.countStack[--this.depth];
        this.namespacesSize -= n;
    }

    public int getElementNameCode() {
        return this.elementNameCode;
    }

    public boolean hasAttributes() {
        return this.bufferedAttributes.getLength() > 0;
    }

    public String getAttribute(int n) {
        return this.bufferedAttributes.getValueByFingerprint(n & 0xFFFFF);
    }

    protected short getURICode(short s) {
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] >> 16 != s) continue;
            short s2 = (short)(this.namespaces[i] & 0xFFFF);
            if (s2 == 0) break;
            return s2;
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if ("".equals(string) && !bl) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s = namePool.getCodeForPrefix(string);
        short s2 = this.getURICode(s);
        if (s2 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s2);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.namespacesSize);
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String string = namePool.getPrefixFromNamespaceCode(this.namespaces[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }
}

