/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.VarPair;
import data.VarPairData;
import data.Variable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;

public class Dataset {
    public int debug;
    private float[][] dataset;
    private ArrayList<Variable> variables = new ArrayList();

    private void addVariables(Variable[] vars) {
        Variable[] variableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            Variable v = variableArray[n2];
            this.addVariable(v);
            ++n2;
        }
    }

    private Variable addVariable(String varName) {
        return this.addVariable(new Variable(this.numVariables(), varName));
    }

    private Variable addVariable(Variable v) {
        this.variables.add(v);
        return v;
    }

    private Variable[] constructVariableSet(String[] varNames) {
        ArrayList<Variable> vars = new ArrayList<Variable>(varNames.length);
        int i = 0;
        while (i < varNames.length) {
            if (vars.contains(varNames[i])) {
                throw new IllegalArgumentException("The variable '" + varNames[i] + "' is present more than once in the dataset");
            }
            vars.add(new Variable(this.numVariables() + i, varNames[i]));
            ++i;
        }
        return vars.toArray(new Variable[0]);
    }

    private float[] getSeries(int index) {
        return this.dataset[index];
    }

    private boolean isNonTrivial(String s) {
        return !s.equals("") && !s.equals("NaN") && !s.equals("\n");
    }

    private float safeParse(String s, int line) {
        try {
            if (this.isNonTrivial(s)) {
                return Float.parseFloat(s);
            }
            return Float.NaN;
        }
        catch (NumberFormatException e) {
            System.out.println("WARNING: The entry '" + s + "' on line " + line + " was not a number.\nI'm replacing it with a blank.");
            return Float.NaN;
        }
    }

    public Dataset(String inputFilename, int debug) throws IOException {
        String delimiter = inputFilename.contains(".csv") ? "," : "\t";
        boolean varNamesAcross = Dataset.areVariablesAcrossTop(inputFilename, delimiter);
        if (varNamesAcross) {
            System.out.println("I see text beyond the first column of line 1,\nso I'm assuming variables names are across the top.");
        } else {
            System.out.println("I see only numbers beyond the first column of line 1,\nso I'm assuming variable names are in the first column.");
        }
        int numLines = Dataset.numNonEmptyLines(inputFilename);
        FileReader file = new FileReader(inputFilename);
        BufferedReader in = new BufferedReader(file);
        if (varNamesAcross) {
            this.addVariables(this.constructVariableSet(in.readLine().split(delimiter)));
            this.dataset = new float[this.numVariables()][numLines - 1];
            String[] line = null;
            int item = 0;
            while (item < numLines - 1) {
                line = (String.valueOf(in.readLine()) + "\n").split(delimiter);
                int var = 0;
                while (var < this.numVariables()) {
                    this.getSeries((int)var)[item] = var < line.length ? this.safeParse(line[var], item + 2) : Float.NaN;
                    ++var;
                }
                ++item;
            }
        } else {
            String l = in.readLine();
            this.dataset = new float[numLines][l.split(delimiter).length - 1];
            int var = 0;
            while (var < numLines) {
                String[] line = (String.valueOf(l) + "\n").split(delimiter);
                this.addVariable(line[0]);
                float[] series = this.getSeries(var);
                int item = 0;
                while (item < series.length) {
                    series[item] = this.safeParse(line[item + 1], var + 2);
                    ++item;
                }
                l = in.readLine();
                ++var;
            }
        }
        System.out.println("DONE. Read " + numLines + " lines and " + this.numVariables() + " variables.");
    }

    private static boolean areVariablesAcrossTop(String filename, String delimiter) throws IOException {
        FileReader file = new FileReader(filename);
        BufferedReader in = new BufferedReader(file);
        String a = in.readLine();
        if (a != null) {
            Object[] line1 = a.split(delimiter);
            if (line1.length < 2) {
                String message = "ERROR: data file has only one column!\nFirst line of file follows: \n" + a + "\n" + "which was parsed into:\n" + Arrays.toString(line1);
                throw new IOException(message);
            }
            try {
                int i = 1;
                while (i < line1.length) {
                    if (!(line1[i].equals("") || ((String)line1[i]).equals("NaN") || ((String)line1[i]).equals("\n"))) {
                        Float.parseFloat((String)line1[i]);
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                in.close();
                file.close();
                return true;
            }
            in.close();
            file.close();
            return false;
        }
        throw new IOException("input file was empty");
    }

    private static int numNonEmptyLines(String filename) throws IOException {
        String line;
        FileReader file = new FileReader(filename);
        BufferedReader in = new BufferedReader(file);
        int numLines = 0;
        while ((line = in.readLine()) != null) {
            if (line.equals("")) continue;
            ++numLines;
        }
        in.close();
        file.close();
        return numLines;
    }

    public Dataset(double[][] data, int debug_) {
        this(data, null, debug_);
    }

    public Dataset(double[][] data, String[] variableNames, int debug_) {
        int i;
        System.out.println("Copying data into dataset");
        System.out.println("There are " + data.length + " variables");
        this.debug = debug_;
        this.dataset = new float[data.length][];
        if (variableNames == null) {
            i = 0;
            while (i < data.length) {
                this.addVariable("variable " + Integer.toString(i + 1));
                ++i;
            }
        } else {
            this.addVariables(this.constructVariableSet(variableNames));
        }
        i = 0;
        while (i < this.dataset.length) {
            this.dataset[i] = new float[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                this.dataset[i][j] = (float)data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Dataset(int[][] data, int debug_) {
        this(data, (String[])null, debug_);
    }

    public Dataset(int[][] data, String[] variableNames, int debug_) {
        int i;
        System.out.println("Copying data into dataset");
        System.out.println("There are " + data.length + " variables");
        this.debug = debug_;
        this.dataset = new float[data.length][];
        if (variableNames == null) {
            i = 0;
            while (i < data.length) {
                this.addVariable("variable " + Integer.toString(i + 1));
                ++i;
            }
        } else {
            this.addVariables(this.constructVariableSet(variableNames));
        }
        i = 0;
        while (i < this.dataset.length) {
            this.dataset[i] = new float[data[i].length];
            int j = 0;
            while (j < data[i].length) {
                this.dataset[i][j] = data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public Dataset(float[][] data, String[] variableNames, int debug_) {
        int i;
        System.out.println("Copying data into dataset");
        System.out.println("There are " + data.length + " variables");
        this.debug = debug_;
        this.dataset = new float[data.length][];
        if (variableNames == null) {
            i = 0;
            while (i < data.length) {
                this.addVariable("variable " + Integer.toString(i + 1));
                ++i;
            }
        } else {
            this.addVariables(this.constructVariableSet(variableNames));
        }
        i = 0;
        while (i < this.dataset.length) {
            this.dataset[i] = Arrays.copyOf(data[i], data[i].length);
            ++i;
        }
    }

    public Dataset(Dataset d1, Dataset d2) throws Exception {
        if (d1.getData() == null || d2.getData() == null || d1.numVariables() != d2.numVariables()) {
            throw new Exception("d1 and d2 must be non-null and have the same number of variables");
        }
        this.debug = d1.debug;
        this.dataset = new float[d1.numVariables()][];
        System.out.println("Merging datasets");
        System.out.println("There are " + this.dataset.length + " variables");
        this.addVariables(d1.getVariables());
        int var = 0;
        while (var < this.dataset.length) {
            this.dataset[var] = new float[d1.getSeries(var).length + d2.getSeries(var).length];
            int i = 0;
            while (i < d1.getSeries(var).length) {
                this.dataset[var][i] = d1.getSeries(var)[i];
                ++i;
            }
            i = 0;
            while (i < d2.getSeries(var).length) {
                this.dataset[var][d1.getSeries((int)var).length + i] = d2.getSeries(var)[i];
                ++i;
            }
            ++var;
        }
    }

    public Dataset(float[][] dataset_, int debug) {
        this(dataset_, (String[])null, debug);
    }

    public float[] getVarSeries(int varId) {
        return this.dataset[varId];
    }

    public VarPairData getOrderedPairs(int var1id, int var2id) {
        return new VarPairData(this.getSeries(var1id), this.getSeries(var2id), this.getVariable(var1id).name(), this.getVariable(var2id).name());
    }

    public VarPairData getOrderedPairs(VarPair pair) {
        return new VarPairData(this.getSeries(pair.var1.id()), this.getSeries(pair.var2.id()), pair.var1.name(), pair.var2.name());
    }

    public VarPair getVariablePair(int var1id, int var2id) {
        return new VarPair(this.getVariable(var1id), this.getVariable(var2id));
    }

    public int numRecords() {
        return this.dataset[0].length;
    }

    public float[][] getData() {
        return this.dataset;
    }

    public Variable[] getVariables() {
        return this.variables.toArray(new Variable[0]);
    }

    public Variable getVariable(int id) {
        return this.variables.get(id);
    }

    public int numVariables() {
        return this.variables.size();
    }

    public void print(BufferedWriter out, int[] variableIds) throws IOException, IndexOutOfBoundsException {
        int id = 0;
        while (id < variableIds.length) {
            out.write(this.getVariable(variableIds[id]).toString());
            out.write(id < variableIds.length - 1 ? "," : "");
            ++id;
        }
        out.write("\n");
        int i = 0;
        while (i < this.numRecords()) {
            int id2 = 0;
            while (id2 < variableIds.length) {
                out.write(Float.toString(this.getSeries(variableIds[id2])[i]));
                out.write(id2 < variableIds.length - 1 ? "," : "");
                ++id2;
            }
            out.write("\n");
            ++i;
        }
        out.flush();
    }

    public void print(BufferedWriter out) throws IOException {
        int[] toPrint = new int[this.numVariables()];
        int i = 0;
        while (i < toPrint.length) {
            toPrint[i] = i;
            ++i;
        }
        this.print(out, toPrint);
    }

    public void print(PrintStream out) throws IOException {
        this.print(new BufferedWriter(new OutputStreamWriter(out)));
    }

    public void print(PrintStream out, int[] variableIds) throws IOException {
        this.print(new BufferedWriter(new OutputStreamWriter(out)), variableIds);
    }
}

