### R code from vignette source 'geneXtendeR.Rnw'

###################################################
### code chunk number 1: <style-Sweave
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: geneXtendeR.Rnw:43-46 (eval = FALSE)
###################################################
## ## try http:// if https:// URLs are not supported
## source("https://bioconductor.org/biocLite.R")
## biocLite("geneXtendeR")


###################################################
### code chunk number 3: geneXtendeR.Rnw:49-50
###################################################
library(geneXtendeR)


###################################################
### code chunk number 4: geneXtendeR.Rnw:55-57 (eval = FALSE)
###################################################
## rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/
##                       rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.chr.gtf.gz")


###################################################
### code chunk number 5: geneXtendeR.Rnw:66-67
###################################################
peaksInput("somepeaksfile.txt")


###################################################
### code chunk number 6: geneXtendeR.Rnw:74-76
###################################################
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)


###################################################
### code chunk number 7: geneXtendeR.Rnw:85-86
###################################################
barChart(rat, 0, 10000, 500)


###################################################
### code chunk number 8: geneXtendeR.Rnw:95-96
###################################################
linePlot(rat, 0, 10000, 500)


###################################################
### code chunk number 9: geneXtendeR.Rnw:105-106
###################################################
linePlot(rat, 2000, 3000, 100)


###################################################
### code chunk number 10: geneXtendeR.Rnw:115-116
###################################################
cumlinePlot(rat, 2000, 3000, 100)


###################################################
### code chunk number 11: geneXtendeR.Rnw:125-128
###################################################
allpeaks <- system.file("extdata", "totalpeaksfile.txt", package="geneXtendeR")
sigpeaks <- system.file("extdata", "significantpeaksfile.txt", package="geneXtendeR")
hotspotPlot(allpeaks, sigpeaks, rat, 0, 10000, 500)


###################################################
### code chunk number 12: geneXtendeR.Rnw:139-142
###################################################
sigpeaks <- system.file("extdata", "significantpeaksfile.txt", package="geneXtendeR")
peaksInput(sigpeaks)
meanPeakLengthPlot(rat, 0, 10000, 500)


###################################################
### code chunk number 13: geneXtendeR.Rnw:149-152
###################################################
sigpeaks <- system.file("extdata", "significantpeaksfile.txt", package="geneXtendeR")
peaksInput(sigpeaks)
meanPeakLength(rat, 0, 500)


###################################################
### code chunk number 14: geneXtendeR.Rnw:159-162
###################################################
allpeaks <- system.file("extdata", "totalpeaksfile.txt", package="geneXtendeR")
peaksInput(allpeaks)
meanPeakLengthPlot(rat, 0, 10000, 500)


###################################################
### code chunk number 15: geneXtendeR.Rnw:171-174
###################################################
allpeaks <- system.file("extdata", "totalpeaksfile.txt", package="geneXtendeR")
peaksInput(allpeaks)
peak_lengths <- peakLengthBoxplot(rat, 4000, 4500)


###################################################
### code chunk number 16: geneXtendeR.Rnw:181-183
###################################################
peak_lengths <- peakLengthBoxplot(rat, 4000, 4500)
max(peak_lengths)


###################################################
### code chunk number 17: geneXtendeR.Rnw:188-190
###################################################
peak_lengths <- peakLengthBoxplot(rat, 4000, 4500)
match(114999, peak_lengths)


###################################################
### code chunk number 18: geneXtendeR.Rnw:195-196
###################################################
distinct(rat, 4000, 4500)


###################################################
### code chunk number 19: geneXtendeR.Rnw:201-204
###################################################
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)
distinct(rat, 2300, 2400)


###################################################
### code chunk number 20: geneXtendeR.Rnw:211-215
###################################################
library(org.Rn.eg.db)
library(GO.db)
x <- diffGO(rat, 2300, 2400, BP, org.Rn.eg.db)
head(x, 20)


###################################################
### code chunk number 21: geneXtendeR.Rnw:224-228
###################################################
library(networkD3)
library(org.Rn.eg.db)
library(dplyr)
makeNetwork(rat, 2300, 2400, BP, org.Rn.eg.db)


###################################################
### code chunk number 22: geneXtendeR.Rnw:245-250 (eval = FALSE)
###################################################
## library(tm)
## library(SnowballC)
## library(wordcloud)
## library(RColorBrewer)
## makeWordCloud(rat, 2300, 2400, BP, org.Rn.eg.db)


###################################################
### code chunk number 23: geneXtendeR.Rnw:261-266 (eval = FALSE)
###################################################
## library(tm)
## library(SnowballC)
## library(wordcloud)
## library(RColorBrewer)
## plotWordFreq(rat, 2300, 2400, BP, org.Rn.eg.db, 10)


###################################################
### code chunk number 24: geneXtendeR.Rnw:278-279
###################################################
annotate(rat, 2400)


###################################################
### code chunk number 25: geneXtendeR.Rnw:290-291
###################################################
linePlot(rat, 0, 10000, 500)


###################################################
### code chunk number 26: geneXtendeR.Rnw:310-311
###################################################
linePlot(rat, 7000, 8500, 100)


###################################################
### code chunk number 27: geneXtendeR.Rnw:319-320 (eval = FALSE)
###################################################
## distinct(rat, 8100, 8200)


###################################################
### code chunk number 28: geneXtendeR.Rnw:329-336
###################################################
library(dplyr)
library(org.Rn.eg.db)
library(GO.db)
a <- diffGO(rat, 0, 500, BP, org.Rn.eg.db)
b <- diffGO(rat, 2000, 3000, BP, org.Rn.eg.db)
dplyr::filter(b, TERM %in% a$TERM)



