## ----include=FALSE-------------------------------------------------------
knitr::opts_chunk$set(warning = FALSE,
                      message = TRUE)

library(DOSE)
library(org.Hs.eg.db)
library(clusterProfiler)
library(ggplot2)
library(ggraph)
library(cowplot)
library(UpSetR)
library(enrichplot)

CRANpkg <- function (pkg) {
    cran <- "https://CRAN.R-project.org/package"
    fmt <- "[%s](%s=%s)"
    sprintf(fmt, pkg, cran, pkg)
}

Biocpkg <- function (pkg) {
    sprintf("[%s](http://bioconductor.org/packages/%s)", pkg, pkg)
}

## ----fig.width=12, fig.height=8------------------------------------------
library(clusterProfiler)
data(geneList, package="DOSE")
de <- names(geneList)[abs(geneList) > 2]
ego <- enrichGO(de, OrgDb = "org.Hs.eg.db", ont="BP", readable=TRUE)

library(enrichplot)
goplot(ego)

## ----fig.width=12, fig.height=8------------------------------------------
barplot(ego, showCategory=20)

## ----fig.width=12, fig.height=8------------------------------------------
dotplot(ego, showCategory=30)

go <- enrichGO(de, OrgDb = "org.Hs.eg.db", ont="all")
dotplot(go, split="ONTOLOGY") + facet_grid(ONTOLOGY~., scale="free")

## ----fig.width=12, fig.height=8------------------------------------------
## remove redundent GO terms
ego2 <- simplify(ego)
cnetplot(ego2, foldChange=geneList)
cnetplot(ego2, foldChange=geneList, circular = TRUE, colorEdge = TRUE)

## ----fig.width=12, fig.height=5------------------------------------------
upsetplot(ego)

## ----fig.width=16, fig.height=4------------------------------------------
heatplot(ego2)
heatplot(ego2, foldChange=geneList)

## ----fig.width=12, fig.height=10-----------------------------------------
emapplot(ego2)

## ----fig.width=12, fig.height=8, message=FALSE---------------------------
kk <- gseKEGG(geneList, nPerm=10000)
ridgeplot(kk)

## ----fig.width=12, fig.height=4------------------------------------------
gseaplot(kk, geneSetID = 1, by = "runningScore", title = kk$Description[1])
gseaplot(kk, geneSetID = 1, by = "preranked", title = kk$Description[1])

## ----fig.width=12, fig.height=8------------------------------------------
gseaplot(kk, geneSetID = 1, title = kk$Description[1])

