## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,dev="png",fig.show="as.is",
               fig.width=10,fig.height=6,
               message=FALSE,eval=T,warning=FALSE)

## ----style, eval=TRUE, echo=F, results="asis"------------------------------
BiocStyle::latex()

## ----prelim, echo=TRUE-----------------------------------------------------
library(beadarrayExampleData)
library(beadarray)
data(exampleBLData)


## ----options, echo=FALSE, eval=TRUE-------------------------------------------
options(width = 80)

## ----readIllumina, echo=TRUE, eval=FALSE--------------------------------------
#  BLData = readIllumina(useImages=FALSE, illuminaAnnotation = "Humanv3")

## ----annotation---------------------------------------------------------------

suggestAnnotation(exampleBLData,verbose=TRUE)
annotation(exampleBLData) <-"Humanv3"


## ----BLData-------------------------------------------------------------------

class(exampleBLData)
slotNames(exampleBLData)

##Get the beadData for array-section 1
exampleBLData[[1]][1:10,]

##Alternative using accessor function
getBeadData(exampleBLData, array=1, what="Grn")[1:10]

##Get unique ProbeIDs. These are the ArrayAddressIDs
uIDs = unique(getBeadData(exampleBLData, array=1, what="ProbeID"))
uIDs[1:10]

## ----metrics------------------------------------------------------------------

metrics(exampleBLData)

p95(exampleBLData, "Grn")

snr(exampleBLData, "Grn")



## ----transform----------------------------------------------------------------

log2(exampleBLData[[1]][1:10,2])

logGreenChannelTransform

logGreenChannelTransform(exampleBLData, array=1)[1:10]

logRedChannelTransform


## ----Imageplot1---------------------------------------------------------------


imageplot(exampleBLData, array=1, low="lightgreen", high="darkgreen")


## ----Imageplot2---------------------------------------------------------------

imageplot(exampleBLData, array=2, low="lightgreen", high="darkgreen")


## ----BASH, eval=FALSE---------------------------------------------------------
#  
#  
#  bsh = BASH(exampleBLData, array=1:2)
#  

## ----savingBASH, eval=FALSE---------------------------------------------------
#  
#  for(i in 1:2){
#  
#  	BLData <- setWeights(exampleBLData, wts=bsh$wts[[i]], array=i)
#  
#  }
#  
#  BLData <- insertSectionData(exampleBLData, what="BASHQC", data = bsh$QC)
#  

## ----getBASH------------------------------------------------------------------

table(getBeadData(exampleBLData, array=1, what="wts"))
table(getBeadData(exampleBLData, array=2, what="wts"))



## ----masks--------------------------------------------------------------------

showArrayMask(exampleBLData, array=2)


## ----controlPlot--------------------------------------------------------------

p <- combinedControlPlot(exampleBLData)


## ----doPlot, echo=FALSE-------------------------------------------------------

if(!is.null(p)){ 
p 
} else plot(1:10,type="n",axes=F, )




## ----createBeadSummaryData----------------------------------------------------

BSData <- summarize(exampleBLData)


## ----createBeadSummaryData2, echo=TRUE,eval=FALSE-----------------------------
#  
#  myMedian <- function(x) median(x, na.rm=TRUE)
#  myMad <- function(x) mad(x, na.rm=TRUE)
#  
#  greenChannel2 <- new("illuminaChannel", greenChannelTransform, illuminaOutlierMethod,
#  myMedian, myMad,"G")
#  
#  BSData2 <- summarize(exampleBLData, list(greenChannel2))
#  

## ----showBSData, echo=TRUE----------------------------------------------------
BSData


## ----calculateDetection, echo=TRUE--------------------------------------------


det = calculateDetection(BSData)

head(det)

Detection(BSData) <- det



## ----sessionInfo--------------------------------------------------------------
sessionInfo()

