## ---- echo=FALSE, warning=FALSE--------------------------------------------
suppressPackageStartupMessages({
    library(TCGAutils)
    library(curatedTCGAData)
    library(MultiAssayExperiment)
    library(RTCGAToolbox)
})

## ---- eval=FALSE-----------------------------------------------------------
#  BiocInstaller::biocLite("TCGAutils")

## ---- eval=FALSE-----------------------------------------------------------
#  library(TCGAutils)
#  library(curatedTCGAData)
#  library(MultiAssayExperiment)
#  library(RTCGAToolbox)

## ---- echo = FALSE---------------------------------------------------------
suppressMessages({
coad <- curatedTCGAData::curatedTCGAData(diseaseCode = "COAD",
    assays = "CN*", dry.run = FALSE)
})

## ---- eval = FALSE---------------------------------------------------------
#  coad <- curatedTCGAData::curatedTCGAData(diseaseCode = "COAD",
#      assays = "CN*", dry.run = FALSE)

## --------------------------------------------------------------------------
curatedTCGAData("COAD", "*")

## --------------------------------------------------------------------------
sampleTables(coad)

## --------------------------------------------------------------------------
data("sampleTypes")
sampleTypes

## --------------------------------------------------------------------------
(tnmae <- splitAssays(coad, c("01", "11")))

## --------------------------------------------------------------------------
(matchmae <- as(tnmae, "MatchedAssayExperiment"))

## --------------------------------------------------------------------------
getSubtypeMap(coad)

## --------------------------------------------------------------------------
getClinicalNames("COAD")

## --------------------------------------------------------------------------
class(colData(coad)[["vital_status.x"]])
class(colData(coad)[["vital_status.y"]])

table(colData(coad)[["vital_status.x"]])
table(colData(coad)[["vital_status.y"]])

## --------------------------------------------------------------------------
mergeColData(MultiAssayExperiment(), data.frame())

## --------------------------------------------------------------------------
## Load example file found in package
pkgDir <- system.file("extdata", package = "TCGAutils", mustWork = TRUE)
exonFile <- list.files(pkgDir, pattern = "cation\\.txt$", full.names = TRUE)
exonFile

## We add the original file prefix to query for the UUID and get the
## TCGAbarcode
filePrefix <- "unc.edu.32741f9a-9fec-441f-96b4-e504e62c5362.1755371."

## Add actual file name manually
makeGRangesListFromExonFiles(exonFile,
    fileNames = paste0(filePrefix, basename(exonFile)))

## --------------------------------------------------------------------------
grlFile <- system.file("extdata", "blca_cnaseq.txt", package = "TCGAutils")
grl <- read.table(grlFile)
head(grl)

makeGRangesListFromCopyNumber(grl, split.field = "Sample")

makeGRangesListFromCopyNumber(grl, split.field = "Sample",
    keep.extra.columns = TRUE)

## --------------------------------------------------------------------------
tempDIR <- tempdir()
co <- getFirehoseData("COAD", clinical = FALSE, GISTIC = TRUE,
    destdir = tempDIR)

selectType(co, "GISTIC")
class(selectType(co, "GISTIC"))

makeSummarizedExperimentFromGISTIC(co, "Peaks")

## --------------------------------------------------------------------------
(xbarcode <- head(colnames(coad)[["COAD_CNASeq-20160128"]], 4L))
barcodeToUUID(xbarcode)

## --------------------------------------------------------------------------
UUIDtoBarcode("ae55b2d3-62a1-419e-9f9a-5ddfac356db4", id_type = "case_id")

## --------------------------------------------------------------------------
UUIDtoBarcode("0001801b-54b0-4551-8d7a-d66fb59429bf",
    id_type = "file_id", end_point = "center")

## --------------------------------------------------------------------------
## Return participant barcodes
TCGAbarcode(xbarcode, participant = TRUE)

## Just return samples
TCGAbarcode(xbarcode, participant = FALSE, sample = TRUE)

## Include sample data as well
TCGAbarcode(xbarcode, participant = TRUE, sample = TRUE)

## Include portion and analyte data
TCGAbarcode(xbarcode, participant = TRUE, sample = TRUE, portion = TRUE)

## --------------------------------------------------------------------------
## Select primary solid tumors
TCGAsampleSelect(xbarcode, "01")

## Select blood derived normals
TCGAsampleSelect(xbarcode, "10")

## --------------------------------------------------------------------------
TCGAbiospec(xbarcode)

## --------------------------------------------------------------------------
## Obtained previously
sampleCodes <- TCGAbarcode(xbarcode, participant = FALSE, sample = TRUE)

## Lookup table
head(sampleTypes)

## Match codes found in the barcode to the lookup table
sampleTypes[match(unique(substr(sampleCodes, 1L, 2L)), sampleTypes[["Code"]]), ]

## --------------------------------------------------------------------------
data("clinicalNames")

clinicalNames

lengths(clinicalNames)

## --------------------------------------------------------------------------
sessionInfo()

