## ----loadPackage-QUALIFIER, echo=FALSE,results='hide', message=FALSE-----
library(QUALIFIER)
QUALIFIER:::qa.par.set("idCol","id")
QUALIFIER:::qa.par.get("idCol")

## ----parseWorkspace, eval=FALSE, echo=TRUE,results='markup'--------------
#  ws<-openWorkspace("./data/QA_MFI_RBC_bounary_eventsV3.xml")##should replace with your own xml workspace file path
#  GT<-parseWorkspace(ws,execute=FALSE,useInternal=TRUE)

## ----gh_template1, eval=FALSE, echo=TRUE,results='markup'----------------
#  gh_template<-GT[[1]]  				

## ----gh_template2, eval=FALSE, echo=TRUE,results='markup'----------------
#  ##datapath is the path where FCS files stores
#  G<-GatingSet(gh_template,filenames,path="./data")
#  getPopStats(G[[1]])

## ----getQAStats, eval=FALSE ,echo=TRUE, results='markup'-----------------
#  db<-new.env()
#  initDB(db)
#  qaPreprocess(db=db,gs=G
#  			,metaFile="./data/FCS_File_mapping.csv" #should replace with your own FCS meta data file path
#  			,fcs.colname="FCS_Files"
#  			,date.colname=c("RecdDt","AnalysisDt")
#  	)

## ----loadData, echo=FALSE, results='hide'--------------------------------
data("ITNQASTUDY")

## ----read.qaTask, echo=TRUE, results='markup'----------------------------
checkListFile<-file.path(system.file("data",package="QUALIFIER"),"qaCheckList.csv.gz")
qaTask.list<-read.qaTask(db,checkListFile=checkListFile)
qaTask.list[1:2]

## ----qaTask-RBCLysis, results='markup'-----------------------------------
qaTask.list[["RBCLysis"]]

## ----qaCheck-RBCLysis, results='markup'----------------------------------
qaCheck(qaTask.list[["RBCLysis"]]
       ,outlierfunc=list(func = outlier.cutoff
                        ,args =  list(lBound=0.8)
                       )
      )

## ----plot-RBCLysis, results='markup'-------------------------------------
plot(qaTask.list[["RBCLysis"]],xlab="Record Date",ylab="percent")

## ----plot-RBCLysis-subset, results='markup'------------------------------
plot(qaTask.list[["RBCLysis"]],subset=Tube=='CD8/CD25/CD4/CD3/CD62L',xlab="Record Date",ylab="percent")

## ----clearCheck,results='markup'-----------------------------------------
clearCheck(qaTask.list[["RBCLysis"]])

## ----plot-RBCLysis-subset2, results='markup',eval=FALSE------------------
#  plot(qaTask.list[["RBCLysis"]],subset=name=='06087181_F01_I010.fcs',scatterPlot=TRUE)

## ----qaTask-MNC,  results='markup'---------------------------------------
qaTask.list[["MNC"]]

## ----qaCheck-MNC,  results='markup'--------------------------------------
qaCheck(qaTask.list[["MNC"]],z.cutoff=1.5)

## ----plot-MNC, results='markup'------------------------------------------
plot(qaTask.list[["MNC"]],proportion~factor(coresampleid),xlab="Sample ID",ylab="percent",scales=list(x=list(rot=45)))

## ----plot-MNC-scatter, results='markup',eval=FALSE-----------------------
#  
#  plot(qaTask.list[["MNC"]]
#  		,scatterPlot=TRUE
#  		,subset=coresampleid==11730)

## ----qaTask-BoundaryEvents, results='markup'-----------------------------
qaTask.list[["BoundaryEvents"]]

## ----qaCheck-BoundaryEvents,  results='markup'---------------------------
qaCheck(qaTask.list[["BoundaryEvents"]]
        ,sum(proportion) ~ RecdDt | name
        ,outlierfunc=list(func = outlier.cutoff
                          ,args =list(uBound=0.0003)
                          )
        )

## ----plot-BoundaryEvents, results='markup'-------------------------------
plot(qaTask.list[["BoundaryEvents"]],proportion ~ RecdDt | channel,xlab="Record Date",ylab="percent")

## ----qaCheck-MFIOverTime, results='markup'-------------------------------
qaCheck(qaTask.list[["MFIOverTime"]]
		,rFunc= list (func = rlm
		              ,args = list(z.cutoff=3)
                  )
		)

plot(qaTask.list[["MFIOverTime"]]
		,y=MFI~RecdDt|stain
		,subset=channel%in%c('FITC-A')
		,rFunc=rlm
		,scales=list(y=c(relation="free"))
		,xlab="Record Date"
	)

## ----plot-spike, results='markup'----------------------------------------
qaCheck(qaTask.list[["spike"]]
			,outlierfunc = list (func = outlier.t
                                ,args = list(alpha=0.00001)
                                ) 
                
			)

plot(qaTask.list[["spike"]],y=spike~RecdDt|channel
		,subset=Tube=='CD8/CD25/CD4/CD3/CD62L'&channel%in%c('FITC-A')
		,xlab="Record Date"
	)


## ----tubesEvents1, results='hide',echo=FALSE-----------------------------
tubesEvents <- read.csv(file.path(system.file("data",package="QUALIFIER"),"tubesevents.csv.gz"),row.names=1)
tubesEvents <- QUALIFIER:::.TubeNameMapping(db,tubesEvents=tubesEvents[,3,drop=F])

## ----tubesEvents2, results='markup'--------------------------------------
tubesEvents

## ----plot-NumberOfEvents, results='markup'-------------------------------
qaCheck(qaTask.list[["NumberOfEvents"]]
		,formula=count ~ RecdDt | Tube
		,outlierfunc = list(func = outlier.cutoff
		                    ,args = list(lBound = 0.8 * tubesEvents)
                        )
		  )
plot(qaTask.list[["NumberOfEvents"]]
		,subset=Tube=='CD8/CD25/CD4/CD3/CD62L'
		,xlab="Record Date"
		,ylab="Cell counts"
	)

## ----plot-RedundantStain, results='markup'-------------------------------
qaCheck(qaTask.list[["RedundantStain"]]
        ,gOutlierfunc = list(func = outlier.norm
                            , args =list(z.cutoff = 1)
                            )
         )
plot(qaTask.list[["RedundantStain"]]
		,y=proportion~factor(coresampleid)|channel:stain
		,subset=stain%in%c('CD8')
		,scales=list(x=list(cex=0.5,rot=45))
		,xlab="Sample ID"
		,ylab="percent"
	)

## ----qa.report1,eval=FALSE, echo=TRUE, results='markup'------------------
#  qaReport(qaTask.list
#  		,outDir="~/temp"
#  		,plotAll=FALSE
#  		,subset=as.POSIXlt(RecdDt)$year==(2007-1900)
#  		)
#  

## ----qa.report2,eval=FALSE, echo=TRUE, results='markup'------------------
#  htmlReport(qaTask.list[["MFIOverTime"]])<-TRUE
#  rFunc(qaTask.list[["MFIOverTime"]])<-rlm
#  scatterPar(qaTask.list[["MFIOverTime"]])<-list(xlog=TRUE)
#  scatterPar(qaTask.list[["BoundaryEvents"]])<-list(xlog=TRUE)
#  scatterPar(qaTask.list[["RedundantStain"]])<-list(xlog=TRUE)
#  qpar(qaTask.list[["RedundantStain"]])<-list(scales=list(x=list(relation="free")))

