/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTask;
import cytoscape.util.ProxyHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class URLUtil {
    private static final String GZIP = ".gz";
    private static final String ZIP = ".zip";
    private static final String JAR = ".jar";
    private static int msConnectionTimeout = 2000;

    public static InputStream getInputStream(URL source) throws IOException {
        InputStream proxyIs = URLUtil.getBasicInputStream(source);
        InputStream newIs = source.toString().toLowerCase().endsWith(GZIP) ? new GZIPInputStream(proxyIs) : (source.toString().toLowerCase().endsWith(ZIP) ? new ZipInputStream(proxyIs) : (source.toString().toLowerCase().endsWith(JAR) ? new JarInputStream(proxyIs) : proxyIs));
        return newIs;
    }

    public static InputStream getBasicInputStream(URL source) throws IOException {
        InputStream is;
        if (source == null) {
            throw new IllegalStateException("getBasicInputStream was given a null 'source' argument.");
        }
        URLConnection uc = URLUtil.getURLConnection(source);
        try {
            is = uc.getInputStream();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get input stream for \"" + source + "\"!");
        }
        return is;
    }

    public static URLConnection getURLConnection(URL source) throws IOException {
        if (source == null) {
            throw new IllegalStateException("getURLConnection was given a null 'source' argument.");
        }
        Proxy cytoProxy = ProxyHandler.getProxyServer();
        URLConnection uc = null;
        if (cytoProxy == null) {
            uc = source.openConnection();
        } else {
            try {
                uc = source.openConnection(cytoProxy);
            }
            catch (UnsupportedOperationException e) {
                uc = source.openConnection();
            }
        }
        uc.setUseCaches(false);
        uc.setConnectTimeout(msConnectionTimeout);
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void download(String urlString, File downloadFile, TaskMonitor taskMonitor) throws IOException {
        boolean stop = false;
        try {
            block11: {
                URL url = new URL(urlString);
                InputStream is = null;
                try {
                    block10: {
                        int maxCount = 0;
                        int progressCount = 0;
                        URLConnection conn = URLUtil.getURLConnection(url);
                        maxCount = conn.getContentLength();
                        is = conn.getInputStream();
                        FileOutputStream os = null;
                        try {
                            os = new FileOutputStream(downloadFile);
                            double percent = 0.0;
                            byte[] buffer = new byte[1];
                            while (is.read(buffer) != -1 && !stop) {
                                progressCount += buffer.length;
                                if (taskMonitor != null) {
                                    JTask jTask;
                                    percent = (double)progressCount / (double)maxCount * 100.0;
                                    if (maxCount == -1) {
                                        percent = -1.0;
                                    }
                                    if ((jTask = (JTask)taskMonitor).haltRequested()) {
                                        stop = true;
                                        taskMonitor.setStatus("Canceling the download ...");
                                        taskMonitor.setPercentCompleted(100);
                                        break;
                                    }
                                    taskMonitor.setPercentCompleted((int)percent);
                                }
                                os.write(buffer);
                            }
                            os.flush();
                            Object var15_13 = null;
                            if (os == null) break block10;
                        }
                        catch (Throwable throwable) {
                            Object var15_14 = null;
                            if (os == null) throw throwable;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                    }
                    Object var17_16 = null;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            Object var19_19 = null;
            if (!stop) return;
            downloadFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            if (!stop) throw throwable;
            downloadFile.delete();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String download(URL source) throws IOException {
        InputStream is = null;
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            is = URLUtil.getInputStream(source);
            while ((c = is.read()) != -1) {
                buffer.append((char)c);
            }
            Object var5_4 = null;
            if (is == null) return buffer.toString();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        is.close();
        return buffer.toString();
    }

    public static boolean isValid(String urlCandidate) {
        try {
            new URL(urlCandidate);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

