/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.readers.NNFReader;
import cytoscape.util.TestUtil;
import giny.model.GraphPerspective;
import giny.model.Node;
import java.io.IOException;
import java.util.Set;
import junit.framework.TestCase;

public class NNFReaderTest
extends TestCase {
    private static final String FILE_LOCATION = "testData/NNFData/";

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testGood1() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/good1.nnf");
        reader.read();
        NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
        NNFReaderTest.assertEquals("root", reader.getNetworks().get(0).getTitle());
    }

    public void testGood2() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/good2.nnf");
        reader.read();
        NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
        NNFReaderTest.assertEquals("root", reader.getNetworks().get(0).getTitle());
    }

    public void testGood3() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/good3.nnf");
        reader.read();
        NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
        NNFReaderTest.assertEquals("Module_Overview", reader.getNetworks().get(0).getTitle());
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        CyNetwork targetNetwork = null;
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals("Module_Overview")) continue;
            targetNetwork = net;
        }
        NNFReaderTest.assertNotNull(targetNetwork);
        NNFReaderTest.assertEquals("Module_Overview", targetNetwork.getTitle());
        NNFReaderTest.assertEquals(4, targetNetwork.getNodeCount());
        NNFReaderTest.assertEquals(5, targetNetwork.getEdgeCount());
    }

    public void testGood4() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/good4.nnf");
        reader.read();
        NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
        NNFReaderTest.assertEquals("Top_Level_Network", reader.getNetworks().get(0).getTitle());
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        CyNetwork targetNetwork = null;
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals("M3")) continue;
            targetNetwork = net;
        }
        NNFReaderTest.assertNotNull(targetNetwork);
        NNFReaderTest.assertEquals("M3", targetNetwork.getTitle());
        NNFReaderTest.assertEquals(4, targetNetwork.getNodeCount());
        NNFReaderTest.assertEquals(3, targetNetwork.getEdgeCount());
        CyNode node = Cytoscape.getCyNode("M2");
        NNFReaderTest.assertNotNull(node);
        Node m2 = targetNetwork.getNode(node.getRootGraphIndex());
        NNFReaderTest.assertNotNull(m2);
        GraphPerspective nestedNetwork = m2.getNestedNetwork();
        NNFReaderTest.assertNotNull(nestedNetwork);
        NNFReaderTest.assertTrue(((CyNetwork)nestedNetwork).getTitle().equals("M2"));
        NNFReaderTest.assertEquals(1, nestedNetwork.getNodeCount());
        NNFReaderTest.assertEquals(0, nestedNetwork.getEdgeCount());
    }

    public void testGood5() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/good5.nnf");
        reader.read();
        NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
        NNFReaderTest.assertEquals("TopLevelNetwork", reader.getNetworks().get(0).getTitle());
    }

    public void testGood6() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/good6.nnf");
        reader.read();
        NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
        NNFReaderTest.assertNotNull(reader.getNetworks().get(1));
    }

    public void testBad1() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/bad1.nnf");
        try {
            reader.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
            return;
        }
        NNFReaderTest.fail();
    }

    public void testBad2() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader = new NNFReader("testData/NNFData/bad2.nnf");
        try {
            reader.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            NNFReaderTest.assertNotNull(reader.getNetworks().get(0));
            return;
        }
        NNFReaderTest.fail();
    }

    public void testMultipleFiles() throws Exception {
        TestUtil.destroyNetworksEdgesAndNodes();
        NNFReader reader1 = new NNFReader("testData/NNFData/good3.nnf");
        reader1.read();
        NNFReader reader2 = new NNFReader("testData/NNFData/good4.nnf");
        reader2.read();
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        CyNetwork targetNetwork = null;
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals("M3")) continue;
            targetNetwork = net;
        }
        NNFReaderTest.assertNotNull(targetNetwork);
        NNFReaderTest.assertEquals("M3", targetNetwork.getTitle());
        NNFReaderTest.assertEquals(6, targetNetwork.getNodeCount());
        NNFReaderTest.assertEquals(4, targetNetwork.getEdgeCount());
    }
}

