/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.InstallerScreen;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.platform.win32.WinDel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class InstallerContextImpl
extends ContextImpl
implements InstallerContext {
    private List autoUninstallActions = new ArrayList();
    private static final String LOG_FILE_NAME = "installation.log";
    private static final String RESPONSE_FILE_NAME = "response.varfile";

    public InstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return InstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof String) {
                    InstallerContextImpl.this.setInstallationDirectory(new File((String)object));
                }
            }
        });
        if (WinDel.SEMAPHORE_NAME != null) {
            try {
                WinDel.scheduleRecursive(new File(System.getProperty("user.dir")));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public File getInstallerFile() {
        String string = System.getProperty("exe4j.moduleName");
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public String getMediaName() {
        return InstallerConfig.getCurrentInstance().getMediaName();
    }

    public void applyToScreen(Screen screen) {
        if (screen instanceof InstallerScreen) {
            ((InstallerScreen)screen).setInstallerContext(this);
        }
    }

    public List getScreenConfigs() {
        return InstallerConfig.getCurrentInstance().getInstallerScreenConfigs();
    }

    public boolean installFile(File file, File file2) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2, fileOptions);
    }

    public void registerUninstallFile(File file) {
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface, int n, int n2) throws UserCanceledException {
        if (progressInterface != null) {
            progressInterface = new ProgressAdapter(progressInterface, n, n2);
        }
        return FileInstaller.getInstance().install(file, file2, fileOptions, progressInterface);
    }

    public boolean performActionInt(Action action) throws UserCanceledException {
        boolean bl = ((InstallAction)action).install(this);
        if (bl && action instanceof AutoUninstallAction) {
            this.autoUninstallActions.add(action);
        }
        return bl;
    }

    public void rollbackActionInt(Action action) {
        ((InstallAction)action).rollback(this);
    }

    public String getLanguageId() {
        if (super.getLanguageId() == null) {
            List list = InstallerConfig.getCurrentInstance().getLanguages();
            if (list.size() == 1) {
                this.setLanguageId(((LanguageConfig)list.get(0)).getId());
            } else if (InstallerConfig.getCurrentInstance().isSkipLanguageSelection() || this.isUnattended()) {
                Locale locale = Locale.getDefault();
                String string = locale.getLanguage();
                if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
                    this.setLanguageId(string);
                } else {
                    string = string + "_" + locale.getCountry();
                    if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
                        this.setLanguageId(string);
                    }
                }
            }
        }
        return super.getLanguageId();
    }

    public void finish(int n) {
        try {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = null;
            if (Util.isMacosInstaller() && installerConfig.getMacSpecificConfig().isSingleBundle()) {
                string = installerConfig.getMacSpecificConfig().getSingleBundleName();
            }
            InstallRegistry.registerApplication(installerConfig.getApplicationId(), installerConfig.getInstallationDirectory(), string);
            File file = this.getRuntimeDirectory();
            if (file.exists()) {
                File file2 = new File(file, LOG_FILE_NAME);
                Logger.getInstance().moveLogFile(file2);
                FileInstaller.getInstance().registerUninstallFile(file2);
                AutoUninstallHandler.saveProperties(this.autoUninstallActions, file);
                this.getInstallationProperties().setLanguageId(this.getLanguageId());
                this.writeInstallationProperties();
                File file3 = new File(file, RESPONSE_FILE_NAME);
                InstallerVariables.writeResponseFile(file3, null);
                FileInstaller.getInstance().registerUninstallFile(file3);
                FileInstaller.getInstance().setLogDir(this.getDestinationFile(".install4j"));
                FileInstaller.getInstance().writeLog();
            }
        }
        catch (IOException iOException) {
            this.handleCriticalException(iOException);
        }
        super.finish(n);
    }

    private void writeInstallationProperties() throws IOException {
        Object object;
        InstallationProperties installationProperties = this.getInstallationProperties();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        ArrayList arrayList = new ArrayList(installerConfig.getFileOptionsConfig().getLaunchers());
        Iterator iterator = installerConfig.getServices().iterator();
        while (iterator.hasNext()) {
            object = (ServiceConfig)iterator.next();
            arrayList.remove(((LauncherConfig)object).getFile());
            installationProperties.addFileToSet("service", this.getDestinationFile(((LauncherConfig)object).getFile()));
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            installationProperties.addFileToSet("launcher", this.getDestinationFile((String)object));
        }
        installationProperties.store();
    }

    public void setInstallationDirectory(File file) {
        InstallerConfig.getCurrentInstance().setInstallationDirectory(file);
        this.variableChanged("sys.installationDir");
    }

    public File getExternalFile(ExternalFile externalFile, boolean bl) {
        if (bl) {
            return super.getExternalFile(externalFile, bl);
        }
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        return externalFile.getAbsoluteFile();
    }
}

