## ----options, eval=TRUE, echo=FALSE----------------------------------------
options(showHeadLines=3)
options(showTailLines=3)

## ----getPackage, eval=FALSE------------------------------------------------
#  source("https://bioconductor.org/biocLite.R")
#  biocLite("GDSArray")

## ----Load, message=FALSE---------------------------------------------------
library(GDSArray)

## ---- GDSArray-------------------------------------------------------------
file <- SeqArray::seqExampleFileName("gds")
GDSArray(file, "genotype/data")

## ---- GDSMatrix------------------------------------------------------------
GDSArray(file, "phase/data")

## ---- GDSFile--------------------------------------------------------------
gf <- GDSFile(file)
gf$annotation$info
gf$annotation$info$AC

## ---- seedAccessor---------------------------------------------------------
ga <- GDSArray(file, "genotype/data")
seed(ga)

## ---- gdsfileAccessor------------------------------------------------------
gdsfile(ga)

## ---- gdsnodes-------------------------------------------------------------
gdsnodes(file)
identical(gdsnodes(file), gdsnodes(gf))
GDSArray(file, name=gdsnodes(file)[2])

## ---- dims-----------------------------------------------------------------
ga <- GDSArray(file, "phase/data")
dim(ga)
class(dimnames(ga))
lengths(dimnames(ga))

## ---- methods--------------------------------------------------------------
ga[1:3, 10:15]
ga[c(TRUE, FALSE), ]

## ---- numeric--------------------------------------------------------------
dp <- GDSArray(file, "annotation/format/DP/data")
dp
log(dp)

dp[rowMeans(dp) < 60, ]

## ---- GDSArraySeed---------------------------------------------------------
seed <- GDSArray:::GDSArraySeed(file, "genotype/data")
seed

## ---- GDSArray-from-GDSArraySeed-------------------------------------------
GDSArray(seed)

## ---- da-------------------------------------------------------------------
class(DelayedArray(seed))

## ---- sessionInfo----------------------------------------------------------
sessionInfo()

