## ----global_settings, echo = FALSE, message = FALSE-----------------------------------------------
library(markdown)
options(markdown.HTML.options = c(options('markdown.HTML.options')[[1]], "toc"))

library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    fig.align = "center",
    fig.width = 5,
    fig.height = 5)
options(markdown.HTML.stylesheet = "custom.css")

options(width = 100)

## -------------------------------------------------------------------------------------------------
mat = read.table(textConnection(
",s1,s2,s3
g1,snv;indel,snv,indel
g2,,snv;indel,snv
g3,snv,,indel;snv"), row.names = 1, header = TRUE, sep = ",", stringsAsFactors = FALSE)
mat = as.matrix(mat)
mat

## -------------------------------------------------------------------------------------------------
library(ComplexHeatmap)
col = c(snv = "red", indel = "blue")
oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
	alter_fun = list(
		snv = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.9, gp = gpar(fill = col["snv"], col = NA)),
		indel = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.4, gp = gpar(fill = col["indel"], col = NA))
	), col = col)

## -------------------------------------------------------------------------------------------------
mat_list = list(snv = matrix(c(1, 0, 1, 1, 1, 0, 0, 1, 1), nrow = 3),
	            indel = matrix(c(1, 0, 0, 0, 1, 0, 1, 0, 0), nrow = 3))
rownames(mat_list$snv) = rownames(mat_list$indel) = c("g1", "g2", "g3")
colnames(mat_list$snv) = colnames(mat_list$indel) = c("s1", "s2", "s3")
mat_list

## -------------------------------------------------------------------------------------------------
mat_list2 = mat_list
mat_list2$indel = mat_list2$indel[1:2, 1:2]
mat_list2
mat_list2 = unify_mat_list(mat_list2)
mat_list2

## -------------------------------------------------------------------------------------------------
oncoPrint(mat_list,
	alter_fun = list(
		snv = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.9, gp = gpar(fill = col["snv"], col = NA)),
		indel = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.4, gp = gpar(fill = col["indel"], col = NA))
	), col = col)

## ---- echo = FALSE--------------------------------------------------------------------------------
print(c("snv" = TRUE, "indel" = FALSE))

## -------------------------------------------------------------------------------------------------
oncoPrint(mat_list,
	alter_fun = function(x, y, w, h, v) {
		if(v["snv"]) grid.rect(x, y, w*0.9, h*0.9, gp = gpar(fill = col["snv"], col = NA))
		if(v["indel"]) grid.rect(x, y, w*0.9, h*0.4, gp = gpar(fill = col["indel"], col = NA))
	}, col = col)

## -------------------------------------------------------------------------------------------------
oncoPrint(mat_list,
    alter_fun = function(x, y, w, h, v) {
		n = sum(v)
		h = h*0.9
		# use `names(which(v))` to correctly map between `v` and `col`
		if(n) grid.rect(x, y - h*0.5 + 1:n/n*h, w*0.9, 1/n*h, 
			gp = gpar(fill = col[names(which(v))], col = NA), just = "top")
    }, col = col)

## ---- width = 6, height = 7-----------------------------------------------------------------------
snv_fun = function(x, y, w, h) {
	grid.rect(x, y, w, h, gp = gpar(fill = col["snv"], col = NA))
}

indel_fun = function(x, y, r) {
	grid.circle(x, y, r, gp = gpar(fill = col["indel"], col = NA))
}

oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
    alter_fun = function(x, y, w, h, v) {
        n = sum(v)
        w = convertWidth(w, "cm")*0.9
        h = convertHeight(h, "cm")*0.9
        l = min(unit.c(w, h))

        grid.rect(x, y, w, h, gp = gpar(fill = "grey", col = NA))

        if(n == 0) return(NULL)
        if(n == 1) {
        	if(names(which(v)) == "snv") snv_fun(x, y, l, l)
        	if(names(which(v)) == "indel") indel_fun(x, y, l*0.5)
        } else if(n == 2) {
        	snv_fun(x, y-0.25*h, l, l)
        	indel_fun(x, y+0.25*h, l*0.5)
        }
    }, col = col)

## -------------------------------------------------------------------------------------------------
oncoPrint(mat_list,
	alter_fun = list(
		background = function(x, y, w, h) grid.rect(x, y, w, h, gp = gpar(fill = "#00FF0020")),
		snv = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.9, gp = gpar(fill = col["snv"], col = NA)),
		indel = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.4, gp = gpar(fill = col["indel"], col = NA))
	), col = col)

## -------------------------------------------------------------------------------------------------
oncoPrint(mat_list,
	alter_fun = list(
		background = NULL,
		snv = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.9, gp = gpar(fill = col["snv"], col = NA)),
		indel = function(x, y, w, h) grid.rect(x, y, w*0.9, h*0.4, gp = gpar(fill = col["indel"], col = NA))
	), col = col)

## -------------------------------------------------------------------------------------------------
oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
    alter_fun = list(
        snv = function(x, y, w, h) {
        	w = convertWidth(w, "cm")
        	h = convertHeight(h, "cm")
        	l = min(unit.c(w, h))
        	grid.rect(x, y, l*0.9, l*0.9, gp = gpar(fill = col["snv"], col = NA))
        },
        indel = function(x, y, w, h) {
        	w = convertWidth(w, "cm")
        	h = convertHeight(h, "cm")
        	r = min(unit.c(w, h))*0.5
        	grid.circle(x, y, r*0.9, gp = gpar(fill = col["indel"], col = NA))
        }
    ), col = col)

## -------------------------------------------------------------------------------------------------
mat = read.table(paste0(system.file("extdata", package = "ComplexHeatmap"), 
	"/tcga_lung_adenocarcinoma_provisional_ras_raf_mek_jnk_signalling.txt"), 
	header = TRUE,stringsAsFactors=FALSE, sep = "\t")
mat[is.na(mat)] = ""
rownames(mat) = mat[, 1]
mat = mat[, -1]
mat=  mat[, -ncol(mat)]
mat = t(as.matrix(mat))
mat[1:3, 1:3]

## -------------------------------------------------------------------------------------------------
alter_fun = list(
	background = function(x, y, w, h) {
		grid.rect(x, y, w-unit(0.5, "mm"), h-unit(0.5, "mm"), gp = gpar(fill = "#CCCCCC", col = NA))
	},
	HOMDEL = function(x, y, w, h) {
		grid.rect(x, y, w-unit(0.5, "mm"), h-unit(0.5, "mm"), gp = gpar(fill = "blue", col = NA))
	},
	AMP = function(x, y, w, h) {
		grid.rect(x, y, w-unit(0.5, "mm"), h-unit(0.5, "mm"), gp = gpar(fill = "red", col = NA))
	},
	MUT = function(x, y, w, h) {
		grid.rect(x, y, w-unit(0.5, "mm"), h*0.33, gp = gpar(fill = "#008000", col = NA))
	}
)

## -------------------------------------------------------------------------------------------------
col = c("MUT" = "#008000", "AMP" = "red", "HOMDEL" = "blue")

## ---- fig.width = 12, fig.height = 8--------------------------------------------------------------
oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
	alter_fun = alter_fun, col = col, 
	column_title = "OncoPrint for TCGA Lung Adenocarcinoma, genes in Ras Raf MEK JNK signalling",
	heatmap_legend_param = list(title = "Alternations", at = c("AMP", "HOMDEL", "MUT"), 
		labels = c("Amplification", "Deep deletion", "Mutation")))

## ---- fig.width = 12, fig.height = 8--------------------------------------------------------------
oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
	alter_fun = alter_fun, col = col, 
	remove_empty_columns = TRUE,
	column_title = "OncoPrint for TCGA Lung Adenocarcinoma, genes in Ras Raf MEK JNK signalling",
	heatmap_legend_param = list(title = "Alternations", at = c("AMP", "HOMDEL", "MUT"), 
		labels = c("Amplification", "Deep deletion", "Mutation")))

## ---- fig.width = 12, fig.height = 8--------------------------------------------------------------
sample_order = scan(paste0(system.file("extdata", package = "ComplexHeatmap"), 
    "/sample_order.txt"), what = "character")
ht = oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
	alter_fun = alter_fun, col = col, 
	row_order = NULL, column_order = sample_order,
	remove_empty_columns = TRUE,
	column_title = "OncoPrint for TCGA Lung Adenocarcinoma, genes in Ras Raf MEK JNK signalling",
	heatmap_legend_param = list(title = "Alternations", at = c("AMP", "HOMDEL", "MUT"), 
		labels = c("Amplification", "Deep deletion", "Mutation"),
		nrow = 1, title_position = "leftcenter"))
draw(ht, heatmap_legend_side = "bottom")

## ---- fig.width = 12, fig.height = 8--------------------------------------------------------------
ht_list = oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
	alter_fun = alter_fun, col = col, 
	remove_empty_columns = TRUE,
	column_title = "OncoPrint for TCGA Lung Adenocarcinoma, genes in Ras Raf MEK JNK signalling",
	heatmap_legend_param = list(title = "Alternations", at = c("AMP", "HOMDEL", "MUT"), 
		labels = c("Amplification", "Deep deletion", "Mutation")),
	split = sample(letters[1:2], nrow(mat), replace = TRUE)) +
Heatmap(matrix(rnorm(nrow(mat)*10), ncol = 10), name = "expr", show_column_dend = FALSE, width = unit(4, "cm"))
draw(ht_list, row_sub_title_side = "left")

## ---- fig.width = 12, fig.height = 8--------------------------------------------------------------
oncoPrint(mat, get_type = function(x) strsplit(x, ";")[[1]],
	alter_fun = alter_fun, col = col, 
	remove_empty_columns = TRUE,
	column_title = "OncoPrint for TCGA Lung Adenocarcinoma, genes in Ras Raf MEK JNK signalling",
	heatmap_legend_param = list(title = "Alternations", at = c("AMP", "HOMDEL", "MUT"), 
		labels = c("Amplification", "Deep deletion", "Mutation")),
	barplot_ignore = "AMP")

## -------------------------------------------------------------------------------------------------
sessionInfo()

