## ----knitr-options, echo=FALSE, message=FALSE, warning=FALSE---------------
## To render an HTML version that works nicely with github and web pages, do:
## rmarkdown::render("vignettes/vignette.Rmd", "all")
library(knitr)
opts_chunk$set(fig.align = 'center', fig.width = 6, fig.height = 5, dev = 'png')
library(ggplot2)
theme_set(theme_bw(12))

## ----plot-sceset-blocking, eval=TRUE---------------------------------------
suppressPackageStartupMessages(library(scater))
data("sc_example_counts")
data("sc_example_cell_info")
example_sce <- SingleCellExperiment(
    assays = list(counts = sc_example_counts), colData = sc_example_cell_info)
exprs(example_sce) <- log2(calculateCPM(example_sce, 
                                        use.size.factors = FALSE) + 1)

plotScater(example_sce, block1 = "Mutation_Status", block2 = "Treatment",
     colour_by = "Cell_Cycle", nfeatures = 300, exprs_values = "counts")

## ----plot-expression, eval=TRUE--------------------------------------------
plotExpression(example_sce, rownames(example_sce)[1:6],
               x = "Mutation_Status", exprs_values = "exprs", 
               colour = "Treatment")

## ----plot-expression-theme-bw, eval=TRUE-----------------------------------
plotExpression(example_sce, rownames(example_sce)[7:12],
               x = "Mutation_Status", exprs_values = "counts", 
               colour = "Cell_Cycle",
               show_median = TRUE, show_violin = FALSE,  xlab = "Mutation Status",
               log = TRUE)

## ----plot-pdata, echo=TRUE, fig.show=TRUE, results='hide', eval=TRUE-------
example_sce <- calculateQCMetrics(example_sce, 
                                  feature_controls = list(dummy = 1:40))
plotColData(example_sce, aes(x = total_counts, y = total_features,
                                  colour = Mutation_Status))

## ----plot-pdatacol-gene-exprs-2, fig.show = TRUE, eval=TRUE----------------
plotColData(example_sce, aes(x = pct_counts_feature_control,
                                  y = total_features, colour = Gene_0500))

## ----plot-fdata, echo=TRUE, fig.show=TRUE, results='hide', eval=TRUE-------
plotRowData(example_sce, aes(x = log10_total_counts, y = n_cells_counts,
                                  colour = log10_mean_counts))

## ----plot-pca-4comp-colby-shapeby-save-pcs, fig.show = FALSE, eval=TRUE----
example_sce <- plotPCA(example_sce, ncomponents = 4,
                          colour_by = "Treatment", shape_by = "Mutation_Status",
                          return_SCE = TRUE, theme_size = 12)
reducedDims(example_sce)
head(reducedDim(example_sce))

## ----plot-reduceddim-4comp-colby-shapeby, fig.show=FALSE, eval=TRUE--------
plotReducedDim(example_sce, use_dimred = "PCA", ncomponents = 4, 
               colour_by = "Treatment", shape_by = "Mutation_Status")

## ----plot-reduceddim-4comp-colby-sizeby-exprs, fig.show = FALSE, eval=TRUE----
plotReducedDim(example_sce, use_dimred = "PCA", ncomponents = 4, 
               colour_by = "Gene_1000", size_by = "Gene_0500")

## ----plot-pca-default, eval=TRUE-------------------------------------------
plotPCA(example_sce)

## ----plot-pca-cpm, eval=TRUE-----------------------------------------------
plotPCA(example_sce, exprs_values = "cpm")

## ----plot-pca-feature-controls, fig.show = FALSE, eval=TRUE----------------
plotPCA(example_sce, feature_set = fData(example_sce)$is_feature_control)

## ----plot-pca-4comp-colby-shapeby, fig.height=5.5, eval=TRUE---------------
plotPCA(example_sce, ncomponents = 4, colour_by = "Treatment",
        shape_by = "Mutation_Status")

## ----plot-pca-4comp-colby-sizeby-exprs, fig.height=5.5, eval=TRUE----------
plotPCA(example_sce, colour_by = "Gene_0001", size_by = "Gene_1000")

## ----plot-tsne-1comp-colby-sizeby-exprs, fig.height=5.5, eval=TRUE---------
plotTSNE(example_sce, colour_by = "Gene_0001", size_by = "Gene_1000")

## ----plot-difmap-1comp-colby-sizeby-exprs, fig.height=5.5, eval=TRUE-------
plotDiffusionMap(example_sce, colour_by = "Gene_0001", size_by = "Gene_1000")

