/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.statistics.distributions;

import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.Distribution;
import java.util.ArrayList;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class NormalDistribution
implements Distribution {
    static final long serialVersionUID = -4944773548279233917L;
    private NormalDistributionImpl normalDistributionImpl;
    private double mean;
    private double std;

    public NormalDistribution(double mean, double std) {
        this.mean = mean;
        this.std = std;
        if (std > 0.0) {
            this.normalDistributionImpl = new NormalDistributionImpl(mean, std);
        }
    }

    public static NormalDistribution getNormalDistribution(ArrayList<Double> input) {
        return new NormalDistribution(BasicMathFunctions.mean(input), BasicMathFunctions.std(input));
    }

    public static NormalDistribution getRobustNormalDistribution(ArrayList<Double> input) {
        double std = (BasicMathFunctions.percentile(input, 0.841) - BasicMathFunctions.percentile(input, 0.159)) / 2.0;
        return new NormalDistribution(BasicMathFunctions.median(input), std);
    }

    @Override
    public Double getProbabilityAt(double x) {
        if (this.std == 0.0) {
            if (x == this.mean) {
                return 1.0;
            }
            return 0.0;
        }
        double xNorm = (x - this.mean) / this.std;
        return Math.pow(Math.E, -Math.pow(xNorm, 2.0) / 2.0) / Math.pow(Math.PI * 2, 0.5);
    }

    @Override
    public Double getMaxValueForProbability(double p) {
        if (this.std == 0.0) {
            return this.mean;
        }
        if (p > 0.5) {
            throw new IllegalArgumentException("Probability >= 0.5");
        }
        if (p <= 0.0) {
            throw new IllegalArgumentException("Probability <= 0");
        }
        double x = Math.pow(-2.0 * Math.log(p * Math.pow(Math.PI * 2, 0.5)), 0.5);
        return this.mean + this.std * x;
    }

    @Override
    public Double getMinValueForProbability(double p) {
        if (this.std == 0.0) {
            return this.mean;
        }
        if (p > 0.5) {
            throw new IllegalArgumentException("Probability >= 0.5");
        }
        if (p <= 0.0) {
            throw new IllegalArgumentException("Probability <= 0");
        }
        double x = Math.pow(-2.0 * Math.log(p * Math.pow(Math.PI * 2, 0.5)), 0.5);
        return this.mean - this.std * x;
    }

    @Override
    public Double getCumulativeProbabilityAt(double x) throws MathException {
        if (this.std == 0.0) {
            if (x < this.mean) {
                return 0.0;
            }
            if (x == this.mean) {
                return 0.5;
            }
            return 1.0;
        }
        return this.normalDistributionImpl.cumulativeProbability(x);
    }

    @Override
    public Double getValueAtCumulativeProbability(double p) throws MathException {
        if (this.std == 0.0) {
            if (p < 0.5) {
                return -1.7976931348623157E308;
            }
            if (p == 0.5) {
                return this.mean;
            }
            return Double.MAX_VALUE;
        }
        return this.normalDistributionImpl.inverseCumulativeProbability(p);
    }

    @Override
    public Double getDescendingCumulativeProbabilityAt(double x) throws MathException {
        if (this.std == 0.0) {
            if (x > this.mean) {
                return 0.0;
            }
            if (x == this.mean) {
                return 0.5;
            }
            return 1.0;
        }
        return this.getCumulativeProbabilityAt(x);
    }

    @Override
    public Double getValueAtDescendingCumulativeProbability(double p) throws MathException {
        if (this.std == 0.0) {
            if (p < 0.5) {
                return Double.MAX_VALUE;
            }
            if (p == 0.5) {
                return this.mean;
            }
            return -1.7976931348623157E308;
        }
        return this.getValueAtCumulativeProbability(p);
    }
}

