/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.xml.model.Bibref;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Xref;

public class PublicationConverter {
    public static final Log log = LogFactory.getLog(PublicationConverter.class);
    public static final String PRIMARY_REFERENCE = "primary-reference";
    public static final String PRIMARY_REFERENCE_REF = "MI:0358";

    public CrossReference toMitab(Bibref bibref) {
        CrossReferenceImpl cr = null;
        if (bibref != null && bibref.getXref() != null) {
            Collection<DbReference> refs = XrefUtils.searchByType(bibref.getXref(), PRIMARY_REFERENCE, PRIMARY_REFERENCE_REF);
            for (DbReference ref : refs) {
                if (cr == null) {
                    cr = new CrossReferenceImpl(ref.getDb(), ref.getId());
                    continue;
                }
                log.warn("More than once primary-reference found, first one was chosen.");
            }
        }
        return cr;
    }

    public Bibref fromMitab(CrossReference ref) {
        Bibref bibref = null;
        if (ref != null && ref.getIdentifier() != null && ref.getDatabase() != null) {
            String db = ref.getDatabase();
            String id = ref.getIdentifier();
            DbReference primaryRef = new DbReference(id, db);
            primaryRef.setRefType(PRIMARY_REFERENCE);
            primaryRef.setRefTypeAc(PRIMARY_REFERENCE_REF);
            if (db.equals("pubmed")) {
                primaryRef.setDbAc("MI:0446");
            }
            Xref xref2 = new Xref(primaryRef);
            bibref = new Bibref(xref2);
        }
        return bibref;
    }

    public Xref imexPrimaryFromMitab(CrossReference ref) {
        Xref imex = null;
        if (ref != null && ref.getIdentifier() != null && ref.getDatabase() != null) {
            String db = ref.getDatabase();
            String id = ref.getIdentifier();
            DbReference primaryRef = new DbReference(id, db);
            primaryRef.setRefType("imex-primary");
            primaryRef.setRefTypeAc("MI:0662");
            if (db.equals("imex")) {
                primaryRef.setDbAc("MI:0670");
            }
            imex = new Xref(primaryRef);
        }
        return imex;
    }
}

