/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.six;

import java.util.Iterator;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.cise.CiSECircle;
import org.ivis.layout.cise.CiSEEdge;
import org.ivis.layout.cise.CiSENode;
import org.ivis.layout.cise.CiSEOnCircleNodeExt;

public class SixCircularCircle
extends CiSECircle {
    public SixCircularCircle(LNode parent, LGraphManager graphMgr, Object vNode) {
        super(parent, graphMgr, vNode);
    }

    public void calculateOptimalOrientation() {
        double potentialEnergy;
        int noOfNodesOnCircle = this.getOnCircleNodes().size();
        double minimalPotentialEnergy = this.calcPotentialEnergy();
        int minimalPotentialIndex = 0;
        for (int i = 1; i < noOfNodesOnCircle; ++i) {
            this.rotateNodes();
            potentialEnergy = this.calcPotentialEnergy();
            if (!(potentialEnergy < minimalPotentialEnergy)) continue;
            minimalPotentialEnergy = potentialEnergy;
            minimalPotentialIndex = i;
        }
        this.rotateNodes();
        this.reverseNodes();
        boolean reverseOrderIsBetter = false;
        for (int i = 0; i < noOfNodesOnCircle; ++i) {
            potentialEnergy = this.calcPotentialEnergy();
            if (potentialEnergy < minimalPotentialEnergy) {
                minimalPotentialEnergy = potentialEnergy;
                minimalPotentialIndex = i;
                reverseOrderIsBetter = true;
            }
            this.rotateNodes();
        }
        if (!reverseOrderIsBetter) {
            this.reverseNodes();
        }
        this.rotateNodesToOptimal(minimalPotentialIndex);
    }

    private void rotateNodes() {
        Iterator<CiSENode> iterator = this.getOnCircleNodes().iterator();
        int noOfNodesOnCircle = this.getOnCircleNodes().size();
        while (iterator.hasNext()) {
            CiSENode node = iterator.next();
            int index = node.getOnCircleNodeExt().getIndex();
            node.getOnCircleNodeExt().setIndex((index + 1) % noOfNodesOnCircle);
        }
        this.reCalculateNodeAnglesAndPositions();
    }

    private void rotateNodesToOptimal(int minimalPotentialIndex) {
        int noOfNodesOnCircle = this.getOnCircleNodes().size();
        if (minimalPotentialIndex == 0) {
            return;
        }
        for (CiSENode node : this.getOnCircleNodes()) {
            CiSEOnCircleNodeExt nodeExt = node.getOnCircleNodeExt();
            nodeExt.setIndex((nodeExt.getIndex() + minimalPotentialIndex) % noOfNodesOnCircle);
        }
        this.reCalculateNodeAnglesAndPositions();
    }

    public double calcPotentialEnergy() {
        double potentialEnergy = 0.0;
        for (CiSENode node : this.getOutNodes()) {
            for (CiSEEdge edge : node.getEdges()) {
                if (!edge.isInterGraph()) continue;
                edge.updateLength();
                assert (!edge.isOverlapingSourceAndTarget());
                potentialEnergy += edge.getLength();
            }
        }
        return potentialEnergy;
    }
}

