/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.EntityFeatureImpl;
import org.biopax.paxtools.impl.level3.EntityImpl;
import org.biopax.paxtools.impl.level3.ExperimentalFormVocabularyImpl;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.ExperimentalForm;
import org.biopax.paxtools.model.level3.ExperimentalFormVocabulary;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=ExperimentalForm.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ExperimentalFormImpl
extends L3ElementImpl
implements ExperimentalForm {
    private org.biopax.paxtools.model.level3.Entity experimentalFormEntity;
    private Set<ExperimentalFormVocabulary> experimentalFormDescription = BPCollections.I.createSafeSet();
    private Set<EntityFeature> experimentalFeature = BPCollections.I.createSafeSet();

    @Transient
    public Class<? extends ExperimentalForm> getModelInterface() {
        return ExperimentalForm.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ExperimentalFormVocabularyImpl.class)
    @JoinTable(name="experimentalFormDescription")
    public Set<ExperimentalFormVocabulary> getExperimentalFormDescription() {
        return this.experimentalFormDescription;
    }

    @Override
    public void addExperimentalFormDescription(ExperimentalFormVocabulary experimentalFormType) {
        if (experimentalFormType != null) {
            this.experimentalFormDescription.add(experimentalFormType);
        }
    }

    @Override
    public void removeExperimentalFormDescription(ExperimentalFormVocabulary experimentalFormType) {
        if (experimentalFormType != null) {
            this.experimentalFormDescription.remove(experimentalFormType);
        }
    }

    public void setExperimentalFormDescription(Set<ExperimentalFormVocabulary> experimentalFormDescription) {
        this.experimentalFormDescription = experimentalFormDescription;
    }

    @Override
    @ManyToOne(targetEntity=EntityImpl.class)
    public org.biopax.paxtools.model.level3.Entity getExperimentalFormEntity() {
        return this.experimentalFormEntity;
    }

    @Override
    public void setExperimentalFormEntity(org.biopax.paxtools.model.level3.Entity experimentalFormEntity) {
        if (experimentalFormEntity == null) {
            this.experimentalFormEntity = null;
        } else if (PhysicalEntity.class.isAssignableFrom(experimentalFormEntity.getClass()) || Gene.class.isInstance(experimentalFormEntity)) {
            this.experimentalFormEntity = experimentalFormEntity;
        } else {
            throw new IllegalBioPAXArgumentException("Argument type is not yet supported: " + experimentalFormEntity.getModelInterface());
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityFeatureImpl.class)
    @JoinTable(name="experimentalFeature")
    public Set<EntityFeature> getExperimentalFeature() {
        return this.experimentalFeature;
    }

    public void setExperimentalFeature(Set<EntityFeature> experimentalFeature) {
        this.experimentalFeature = experimentalFeature;
    }

    @Override
    public void addExperimentalFeature(EntityFeature experimentalFeature) {
        if (experimentalFeature != null) {
            this.experimentalFeature.add(experimentalFeature);
        }
    }

    @Override
    public void removeExperimentalFeature(EntityFeature experimentalFeature) {
        if (experimentalFeature != null) {
            this.experimentalFeature.remove(experimentalFeature);
        }
    }
}

