/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.client.BiopaxValidatorClient;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.Integrator;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.converter.psi.PsiToBiopax3Converter;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.gsea.GSEAConverter;
import org.biopax.paxtools.io.sbgn.L3ToSBGNPDConverter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.pattern.miner.BlacklistGenerator;
import org.biopax.paxtools.pattern.miner.CommonIDFetcher;
import org.biopax.paxtools.pattern.miner.CustomFormat;
import org.biopax.paxtools.pattern.miner.Dialog;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.OldFormatWriter;
import org.biopax.paxtools.pattern.miner.OutputColumn;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.miner.SIFType;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.validator.jaxb.Behavior;

public class PaxtoolsMain {
    public static Log log = LogFactory.getLog(PaxtoolsMain.class);
    private static SimpleIOHandler io = new SimpleIOHandler();
    private static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };
    private static final Object EMPTY = new Object(){

        public String toString() {
            return "EMPTY";
        }
    };

    public static void main(String[] argv) throws IOException, InvocationTargetException, IllegalAccessException {
        io.mergeDuplicates(true);
        if (argv.length == 0) {
            PaxtoolsMain.help();
        } else {
            String command = argv[0];
            if (command.startsWith("--")) {
                command = command.substring(2);
            }
            Command.valueOf(command).run(argv);
        }
    }

    public static void toGSEA(String[] argv) throws IOException {
        GSEAConverter gseaConverter;
        boolean specCheckEnabled;
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(argv[1]));
        boolean bl = specCheckEnabled = argv.length > 4 && Boolean.parseBoolean(argv[4]);
        if (argv.length < 6 || argv[5].equalsIgnoreCase("false")) {
            log.info("Collecting proteins for a pathway, the converter will also consider its sub-pathways, their sub-pathways, etc.");
            gseaConverter = new GSEAConverter(argv[3], specCheckEnabled);
        } else {
            boolean skipAllSubPathways = Boolean.parseBoolean(argv[5]);
            if (skipAllSubPathways) {
                log.info("The converter won't traverse into sub-pathways of any pathway to collect its protein IDs.");
                gseaConverter = new GSEAConverter(argv[3], specCheckEnabled, true);
            } else {
                HashSet<Provenance> skipSubPathways = new HashSet<Provenance>();
                for (String uri : argv[5].split(";")) {
                    Provenance pro = (Provenance)model.getByID(uri);
                    if (pro != null) {
                        skipSubPathways.add(pro);
                        log.info("GSEA converter won't traverse into sub-pathways of pathways from the data source: " + uri);
                        continue;
                    }
                    log.error("No Provenance found by uri: " + uri + " (thus - ignored)");
                }
                if (skipSubPathways.isEmpty()) {
                    throw new IllegalArgumentException("The last arg. of the Paxtools command is bad; no known Provenance found (if these were semicolon-separated Provenance URIs): " + argv[5]);
                }
                log.info("Collecting proteins, the converter will skip sub-pathways of pathways of the following datasources: " + ((Object)skipSubPathways).toString());
                gseaConverter = new GSEAConverter(argv[3], specCheckEnabled, skipSubPathways);
            }
        }
        gseaConverter.writeToGSEA(model, new FileOutputStream(argv[2]));
    }

    public static void getNeighbors(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(in));
        HashSet<BioPAXElement> elements = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement e2 = model.getByID(id.toString());
            if (e2 != null && (e2 instanceof Entity || e2 instanceof entity)) {
                elements.add(e2);
                continue;
            }
            log.warn("Source element not found: " + id);
        }
        Set<BioPAXElement> result = QueryExecuter.runNeighborhood(elements, model, 1, Direction.BOTHSTREAM, new Filter[0]);
        Completer c = new Completer(io.getEditorMap());
        result = c.complete(result, model);
        Cloner cln = new Cloner(io.getEditorMap(), io.getFactory());
        model = cln.clone(model, result);
        if (model != null) {
            log.info("Elements in the result model: " + model.getObjects().size());
            io.convertToOWL(model, new FileOutputStream(out));
        } else {
            log.error("NULL model returned.");
        }
    }

    public static void fetch(String[] argv) throws IOException {
        String in = argv[1];
        String[] uris = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(in));
        io.setFactory(model.getLevel().getDefaultFactory());
        io.convertToOWL(model, new FileOutputStream(out), uris);
    }

    public static void toLevel3(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        InputStream is = PaxtoolsMain.getInputStream(input);
        FileOutputStream os = new FileOutputStream(output);
        boolean forcePsiInteractionToComplex = false;
        String val = System.getProperty("paxtools.converter.psi.interaction");
        if ("complex".equalsIgnoreCase(val)) {
            forcePsiInteractionToComplex = true;
        }
        Type type = PaxtoolsMain.detect(input);
        try {
            switch (type) {
                case BIOPAX: {
                    Model model = io.convertFromOWL(is);
                    model = new LevelUpgrader().filter(model);
                    if (model != null) {
                        io.setFactory(model.getLevel().getDefaultFactory());
                        io.convertToOWL(model, os);
                    }
                    break;
                }
                case PSIMI: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convert(is, (OutputStream)os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
                default: {
                    PsiToBiopax3Converter psimiConverter = new PsiToBiopax3Converter();
                    psimiConverter.convertTab(is, os, forcePsiInteractionToComplex);
                    os.close();
                    break;
                }
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to convert " + input + "to BioPAX L3", e2);
        }
    }

    private static Type detect(String input) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(input));
            int linesToCheck = 20;
            while (linesToCheck-- > 0) {
                sb.append(reader.readLine()).append('\n');
            }
            reader.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        String buf = sb.toString();
        if (buf.contains("<rdf:RDF") && buf.contains("http://www.biopax.org/release/biopax")) {
            return Type.BIOPAX;
        }
        if (buf.contains("<entrySet") && buf.contains("http://psidev.sourceforge.net/mi/rel25/")) {
            return Type.PSIMI;
        }
        return Type.PSIMITAB;
    }

    public static void toSBGN(String[] argv) throws IOException {
        String input = argv[1];
        String output = argv[2];
        Model model = io.convertFromOWL(PaxtoolsMain.getInputStream(input));
        L3ToSBGNPDConverter l3ToSBGNPDConverter = new L3ToSBGNPDConverter();
        l3ToSBGNPDConverter.writeSBGN(model, output);
    }

    public static void validate(String[] argv) throws IOException {
        block16: {
            String input = argv[1];
            String output = argv[2];
            BiopaxValidatorClient.RetFormat outf = BiopaxValidatorClient.RetFormat.HTML;
            boolean fix = false;
            Integer maxErrs = null;
            Behavior level = null;
            String profile = null;
            for (int i = 3; i < argv.length; ++i) {
                if ("html".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.HTML;
                    continue;
                }
                if ("xml".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.XML;
                    continue;
                }
                if ("biopax".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.OWL;
                    continue;
                }
                if ("auto-fix".equalsIgnoreCase(argv[i])) {
                    fix = true;
                    continue;
                }
                if ("only-errors".equalsIgnoreCase(argv[i])) {
                    level = Behavior.ERROR;
                    continue;
                }
                if (argv[i].toLowerCase().startsWith("maxerrors=")) {
                    String num = argv[i].substring(10);
                    maxErrs = Integer.valueOf(num);
                    continue;
                }
                if (!"notstrict".equalsIgnoreCase(argv[i])) continue;
                profile = "notstrict";
            }
            HashSet<File> files = new HashSet<File>();
            File fileOrDir = new File(input);
            if (!fileOrDir.canRead()) {
                System.out.println("Cannot read " + input);
            }
            if (fileOrDir.isDirectory()) {
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".owl");
                    }
                };
                for (String s : fileOrDir.list(filter)) {
                    files.add(new File(fileOrDir.getCanonicalPath() + File.separator + s));
                }
            } else {
                files.add(fileOrDir);
            }
            FileOutputStream os = new FileOutputStream(output);
            try {
                if (files.isEmpty()) break block16;
                BiopaxValidatorClient val = new BiopaxValidatorClient();
                val.validate(fix, profile, outf, level, maxErrs, null, files.toArray(new File[0]), os);
            }
            catch (Exception ex) {
                String msg = "Unable to check with the biopax-validator web service: \n " + ex.toString() + "\n Fall-back: trying to parse the file(s) with paxtools " + "(up to the first syntax error in each file)...\n";
                log.error(msg, ex);
                ((OutputStream)os).write(msg.getBytes());
                for (File f : files) {
                    try {
                        Model m = io.convertFromOWL(PaxtoolsMain.getInputStream(f.getPath()));
                        msg = "Model that contains " + m.getObjects().size() + " elements is successfully created from " + f.getPath() + " (check the console output for warnings).\n";
                        ((OutputStream)os).write(msg.getBytes());
                    }
                    catch (Exception e2) {
                        msg = "Error: " + e2 + " in building a BioPAX Model from: " + f.getPath() + "\n";
                        ((OutputStream)os).write(msg.getBytes());
                        e2.printStackTrace();
                        log.error(msg);
                    }
                    os.flush();
                }
            }
        }
    }

    public static void toSifnx(String[] argv) throws IOException {
        CommonIDFetcher idFetcher = new CommonIDFetcher();
        idFetcher.setUseUniprotIDs(argv.length > 3 && argv[3].equals("uniprot"));
        SIFSearcher searcher = new SIFSearcher((IDFetcher)idFetcher, (SIFType[])SIFEnum.values());
        File blacklistFile = new File("blacklist.txt");
        if (blacklistFile.exists()) {
            log.info("toSifnx: will use the blacklist.txt (found in the current directory)");
            searcher.setBlacklist(new Blacklist(new FileInputStream(blacklistFile)));
        } else {
            log.info("toSifnx: not blacklisting ubiquitous molecules (no blacklist.txt found)");
        }
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        ModelUtils.mergeEquivalentInteractions(model);
        Set<SIFInteraction> binaryInts = searcher.searchSIF(model);
        OldFormatWriter.write(binaryInts, new FileOutputStream(argv[2]));
    }

    public static void toSif(String[] argv) throws IOException {
        CommonIDFetcher idFetcher = new CommonIDFetcher();
        ArrayList<String> otherParam = new ArrayList<String>();
        otherParam.addAll(Arrays.asList(argv).subList(3, argv.length));
        idFetcher.setUseUniprotIDs(otherParam.contains("uniprot"));
        SIFSearcher searcher = new SIFSearcher((IDFetcher)idFetcher, (SIFType[])SIFEnum.values());
        File blacklistFile = new File("blacklist.txt");
        if (blacklistFile.exists()) {
            log.info("toSif: will use the blacklist.txt (found in the current directory)");
            searcher.setBlacklist(new Blacklist(new FileInputStream(blacklistFile)));
        } else {
            log.info("toSif: not blacklisting ubiquitous molecules (no blacklist.txt found)");
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (String param : otherParam) {
            OutputColumn.Type type = OutputColumn.Type.getType(param);
            if ((type == null || type == OutputColumn.Type.CUSTOM) && !param.contains("/")) continue;
            fieldList.add(param);
        }
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        ModelUtils.mergeEquivalentInteractions(model);
        if (fieldList.isEmpty()) {
            searcher.searchSIF(model, (OutputStream)new FileOutputStream(argv[2]), false);
        } else if (fieldList.size() == 1 && fieldList.contains(OutputColumn.Type.MEDIATOR.name().toLowerCase())) {
            searcher.searchSIF(model, (OutputStream)new FileOutputStream(argv[2]), true);
        } else {
            searcher.searchSIF(model, (OutputStream)new FileOutputStream(argv[2]), new CustomFormat(fieldList.toArray(new String[fieldList.size()])));
        }
    }

    public static void integrate(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel(io, argv[1]);
        Model model2 = PaxtoolsMain.getModel(io, argv[2]);
        Integrator integrator = new Integrator(SimpleEditorMap.get(model1.getLevel()), model1, model2);
        integrator.integrate();
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, new FileOutputStream(argv[3]));
    }

    public static void merge(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel(io, argv[1]);
        Model model2 = PaxtoolsMain.getModel(io, argv[2]);
        Merger merger = new Merger(SimpleEditorMap.get(model1.getLevel()));
        merger.merge(model1, model2);
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, new FileOutputStream(argv[3]));
    }

    public static void blacklist(String[] argv) throws IOException {
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        BlacklistGenerator gen = new BlacklistGenerator();
        Blacklist blacklist = gen.generateBlacklist(model);
        blacklist.write(new FileOutputStream(argv[2]));
    }

    public static void help() {
        System.out.println("(Paxtools Console) Available Operations:\n");
        for (Command cmd : Command.values()) {
            System.out.println(cmd.name() + " " + cmd.description);
        }
        System.out.println("Commands can also use compressed input files (only '.gz').\n");
    }

    public static void pattern(String[] argv) {
        Dialog.main(argv);
    }

    private static Model getModel(BioPAXIOHandler io, String fName) throws IOException {
        return io.convertFromOWL(PaxtoolsMain.getInputStream(fName));
    }

    public static void summarize(String[] argv) throws IOException {
        log.debug("Importing the input model from " + argv[1] + "...");
        Model model = PaxtoolsMain.getModel(io, argv[1]);
        log.debug("Analyzing...");
        PaxtoolsMain.summarize(model, argv.length > 2 ? new PrintStream(argv[2]) : null);
    }

    public static void summarize(Model model, PrintStream out) throws IOException {
        String[] stringArray;
        if (out == null) {
            out = System.out;
        }
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        SimpleEditorMap em = model.getLevel() == BioPAXLevel.L3 ? SimpleEditorMap.L3 : SimpleEditorMap.L2;
        for (Class<? extends BioPAXElement> clazz : PaxtoolsMain.sortToName(em.getKnownSubClassesOf(BioPAXElement.class))) {
            Set<? extends BioPAXElement> set = model.getObjects(clazz);
            int initialSize = set.size();
            set = PaxtoolsMain.filterToExactClass(set, clazz);
            String s = clazz.getSimpleName() + " = " + set.size();
            if (initialSize != set.size()) {
                s = s + " (and " + (initialSize - set.size()) + " children)";
            }
            out.println(s);
            Set<PropertyEditor> editors = em.getEditorsOf(clazz);
            for (PropertyEditor editor : editors) {
                Set values;
                Method getMethod = editor.getGetMethod();
                Class<?> returnType = getMethod.getReturnType();
                HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
                if (returnType.isEnum() || PaxtoolsMain.implementsInterface(returnType, ControlledVocabulary.class)) {
                    for (BioPAXElement bioPAXElement : set) {
                        values = editor.getValueFromBean(bioPAXElement);
                        if (values.isEmpty()) {
                            PaxtoolsMain.increaseCnt(cnt, NULL);
                            continue;
                        }
                        PaxtoolsMain.increaseCnt(cnt, values.iterator().next());
                    }
                } else if (returnType.equals(Set.class) && PaxtoolsMain.implementsInterface(editor.getRange(), ControlledVocabulary.class)) {
                    for (BioPAXElement bioPAXElement : set) {
                        values = editor.getValueFromBean(bioPAXElement);
                        if (values.isEmpty()) {
                            PaxtoolsMain.increaseCnt(cnt, EMPTY);
                        }
                        for (Object val : values) {
                            PaxtoolsMain.increaseCnt(cnt, val);
                        }
                    }
                }
                if (cnt.isEmpty()) continue;
                String name = "-" + (returnType.equals(Set.class) ? editor.getRange().getSimpleName() : returnType.getSimpleName());
                out.print("\t" + name + ":");
                for (Object key : PaxtoolsMain.getOrdering(cnt)) {
                    out.print("\t" + key + " = " + cnt.get(key));
                }
                out.println();
            }
        }
        if (model.getLevel() == BioPAXLevel.L3) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "UnificationXref/db";
            stringArray = stringArray2;
            stringArray2[1] = "RelationshipXref/db";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "unificationXref/DB";
            stringArray = stringArray3;
            stringArray3[1] = "relationshipXref/DB";
        }
        String[] props = stringArray;
        out.println("\nOther property counts\n");
        for (String prop : props) {
            HashMap<Object, Integer> cnt = new HashMap<Object, Integer>();
            ArrayList<String> valList = new ArrayList<String>();
            PathAccessor acc = new PathAccessor(prop, model.getLevel());
            boolean isString = false;
            for (Object o : acc.getValueFromModel(model)) {
                if (o instanceof String) {
                    isString = true;
                }
                String s = o.toString();
                valList.add(s);
                if (!cnt.containsKey(s)) {
                    cnt.put(s, 1);
                    continue;
                }
                cnt.put(s, (Integer)cnt.get(s) + 1);
            }
            out.println(prop + "\t(" + cnt.size() + " distinct values):");
            hm.put(prop, cnt.size());
            if (isString) {
                Collections.sort(valList);
                for (String s : valList) {
                    out.print("\t" + s);
                }
            } else {
                for (Object key : PaxtoolsMain.getOrdering(cnt)) {
                    out.print("\t" + key + " = " + cnt.get(key));
                }
            }
            out.println();
        }
    }

    private static List<Class<? extends BioPAXElement>> sortToName(Set<? extends Class<? extends BioPAXElement>> classes) {
        ArrayList<Class<? extends BioPAXElement>> list = new ArrayList<Class<? extends BioPAXElement>>(classes);
        Collections.sort(list, new Comparator<Class<? extends BioPAXElement>>(){

            @Override
            public int compare(Class<? extends BioPAXElement> clazz1, Class<? extends BioPAXElement> clazz2) {
                return clazz1.getName().substring(clazz1.getName().lastIndexOf(".") + 1).compareTo(clazz2.getName().substring(clazz2.getName().lastIndexOf(".") + 1));
            }
        });
        return list;
    }

    private static List<Object> getOrdering(final Map<Object, Integer> map) {
        ArrayList<Object> list = new ArrayList<Object>(map.keySet());
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object key1, Object key2) {
                int cnt2;
                int cnt1 = (Integer)map.get(key1);
                if (cnt1 == (cnt2 = ((Integer)map.get(key2)).intValue())) {
                    return key1.toString().compareTo(key2.toString());
                }
                return cnt2 - cnt1;
            }
        });
        return list;
    }

    private static Set<BioPAXElement> filterToExactClass(Set<? extends BioPAXElement> classSet, Class<?> clazz) {
        HashSet<BioPAXElement> exact = new HashSet<BioPAXElement>();
        for (BioPAXElement bioPAXElement : classSet) {
            if (!bioPAXElement.getModelInterface().equals(clazz)) continue;
            exact.add(bioPAXElement);
        }
        return exact;
    }

    private static boolean implementsInterface(Class clazz, Class inter) {
        for (Class<?> anInter : clazz.getInterfaces()) {
            if (!anInter.equals(inter)) continue;
            return true;
        }
        return false;
    }

    private static void increaseCnt(Map<Object, Integer> cnt, Object key) {
        if (!cnt.containsKey(key)) {
            cnt.put(key, 0);
        }
        cnt.put(key, cnt.get(key) + 1);
    }

    private static InputStream getInputStream(String path) throws IOException {
        FileInputStream is = new FileInputStream(path);
        return path.endsWith(".gz") ? new GZIPInputStream(is) : is;
    }

    static enum Command {
        merge("<file1> <file2> <output>\n\t- merges file2 into file1 and writes it into output"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.merge(argv);
            }
        }
        ,
        toSif("<input> <output> [hgnc|uniprot]\n\t- converts model to the simple interaction format; will use blacklist.txt file in the current directory, if present"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSif(argv);
            }
        }
        ,
        toSifnx("<input> <output> [hgnc|uniprot] [mediator] [pubmed] [pathway] [resource] [source_loc] [target_loc] [path/to/a/mediator/field]\n\t- converts model to the extended simple interaction format; will use blacklist.txt file in the current directory, if present"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSifnx(argv);
            }
        }
        ,
        toSbgn("<biopax.owl> <output.sbgn>\n\t- converts model to the SBGN format."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSBGN(argv);
            }
        }
        ,
        validate("<path> <out> [xml|html|biopax] [auto-fix] [only-errors] [maxerrors=n] [notstrict]\n\t- validate BioPAX file/directory (up to ~25MB in total size, -\n\totherwise download and run the stand-alone validator)\n\tin the directory using the online validator service\n\t(generates html or xml report, or gets the processed biopax\n\t(cannot be perfect though) see http://www.biopax.org/validator)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.validate(argv);
            }
        }
        ,
        integrate("<file1> <file2> <output>\n\t- integrates file2 into file1 and writes it into output (experimental)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.integrate(argv);
            }
        }
        ,
        toLevel3("<input> <output>\n\t- converts BioPAX level 1 or 2, PSI-MI 2.5 and PSI-MITAB to the level 3 file;\n\tuse -Dpaxtools.converter.psi.interaction=complex java option \n\tto force PSI Interaction to BioPAX Complex convertion instead of \n\tto MolecularInteraction (default)."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toLevel3(argv);
            }
        }
        ,
        toGSEA("<input> <output> <database> [crossSpeciesCheck] [skipSubPathways]\n\t- converts Level 1 or 2 or 3 to GSEA output.\n\tUses that database identifier or the biopax URI if database is \"NONE\".\n\t[crossSpeciesCheck] - optional cross-species check ensures participant protein is from same species\n\tas pathway (values: true/false; if false, organism there will be always 'unspecified').\n\t[skipSubPathways] - optional, true (always), false (never), or a semicolon-separated list of\n\tProvenance_uri1;Provenance_uri2;.. for which the converter won't traverse\n\tinto sub-pathways of each pathway in order to collect all the proteins (useful e.g., with KEGG data)."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toGSEA(argv);
            }
        }
        ,
        fetch("<input> <Uri1,Uri2,..> <output>\n\t- extracts a self-integral BioPAX sub-model from file1 and writes to the output."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.fetch(argv);
            }
        }
        ,
        getNeighbors("<input> <id1,id2,..> <output>\n\t- nearest neighborhood graph query (id1,id2 - of Entity sub-class only)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.getNeighbors(argv);
            }
        }
        ,
        summarize("<input> [<output>]\n\t- prints a summary of the contents of the model to the output file (if not provided - to stdout)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.summarize(argv);
            }
        }
        ,
        blacklist("<input> <output>\n\t- creates a blacklist of ubiquitous small molecules, like ATP, \n\tfrom the BioPAX model and writes it to the output file. The blacklist can be used with\n \tpaxtools graph queries or when converting from the SAME BioPAX data to the SIF formats."){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.blacklist(argv);
            }
        }
        ,
        pattern("\n\t- BioPAX pattern search tool (opens a new dialog window)"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.pattern(argv);
            }
        }
        ,
        help("\n\t- prints this screen and exits\n"){

            @Override
            public void run(String[] argv) throws IOException {
                PaxtoolsMain.help();
            }
        };

        String description;
        int params;

        private Command(String description) {
            this.description = description;
        }

        public abstract void run(String[] var1) throws IOException;
    }

    private static enum Type {
        BIOPAX,
        PSIMI,
        PSIMITAB;

    }
}

