/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeDataParser;
import net.sf.saxon.om.XMLChar;

public class Normalizer {
    static final byte COMPATIBILITY_MASK = 1;
    static final byte COMPOSITION_MASK = 2;
    public static final byte D = 0;
    public static final byte C = 2;
    public static final byte KD = 1;
    public static final byte KC = 3;
    private byte form;
    private static NormalizerData data = null;

    public Normalizer(byte by) {
        this.form = by;
        if (data == null) {
            data = UnicodeDataParser.build();
        }
    }

    public StringBuffer normalize(CharSequence charSequence, StringBuffer stringBuffer) {
        if (charSequence.length() != 0) {
            this.internalDecompose(charSequence, stringBuffer);
            if ((this.form & 2) != 0) {
                this.internalCompose(stringBuffer);
            }
        }
        return stringBuffer;
    }

    public CharSequence normalize(CharSequence charSequence) {
        return this.normalize(charSequence, new StringBuffer(charSequence.length() + 8));
    }

    private void internalDecompose(CharSequence charSequence, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(8);
        boolean bl = (this.form & 1) == 0;
        int n = 0;
        while (n < charSequence.length()) {
            int n2;
            stringBuffer2.setLength(0);
            int n4 = charSequence.charAt(n++);
            if (XMLChar.isHighSurrogate(n4)) {
                n2 = charSequence.charAt(n++);
                n4 = XMLChar.supplemental((char)n4, (char)n2);
            }
            data.getRecursiveDecomposition(bl, n4, stringBuffer2);
            int n5 = 0;
            while (n5 < stringBuffer2.length()) {
                int n6;
                char c;
                n2 = stringBuffer2.charAt(n5++);
                if (XMLChar.isHighSurrogate(n4)) {
                    c = stringBuffer2.charAt(n5++);
                    n2 = XMLChar.supplemental((char)n2, c);
                }
                c = data.getCanonicalClass(n2);
                if (c != '\u0000') {
                    for (n6 = stringBuffer.length(); n6 > 0; --n6) {
                        int n7 = stringBuffer.charAt(n6 - 1);
                        if (XMLChar.isSurrogate(n7)) {
                            char c2 = stringBuffer2.charAt(--n6 - 1);
                            n7 = XMLChar.supplemental(c2, (char)n7);
                        }
                        if (data.getCanonicalClass(n7) <= c) break;
                    }
                }
                if (n2 < 65536) {
                    stringBuffer.insert(n6, (char)n2);
                    continue;
                }
                String string = "" + XMLChar.highSurrogate(n2) + XMLChar.lowSurrogate(n2);
                stringBuffer.insert(n6, string);
            }
        }
    }

    private void internalCompose(StringBuffer stringBuffer) {
        int n;
        int n2 = 0;
        int n4 = stringBuffer.charAt(0);
        int n5 = 1;
        if (XMLChar.isHighSurrogate(n4)) {
            n4 = XMLChar.supplemental((char)n4, stringBuffer.charAt(1));
            ++n5;
        }
        if ((n = data.getCanonicalClass(n4)) != 0) {
            n = 256;
        }
        int n6 = stringBuffer.length();
        int n7 = n5;
        while (n7 < stringBuffer.length()) {
            int n8;
            if (XMLChar.isHighSurrogate(n8 = stringBuffer.charAt(n7++))) {
                n8 = XMLChar.supplemental((char)n8, stringBuffer.charAt(n7++));
            }
            int n9 = data.getCanonicalClass(n8);
            char c = data.getPairwiseComposition(n4, n8);
            if (c != '\uffff' && (n < n9 || n == 0)) {
                Normalizer.setCharAt(stringBuffer, n2, c);
                n4 = c;
                continue;
            }
            if (n9 == 0) {
                n2 = n5;
                n4 = n8;
            }
            n = n9;
            Normalizer.setCharAt(stringBuffer, n5, n8);
            if (stringBuffer.length() != n6) {
                n7 += stringBuffer.length() - n6;
                n6 = stringBuffer.length();
            }
            n5 += n8 < 65536 ? 1 : 2;
        }
        stringBuffer.setLength(n5);
    }

    private static void setCharAt(StringBuffer stringBuffer, int n, int n2) {
        if (n2 < 65536) {
            if (XMLChar.isHighSurrogate(stringBuffer.charAt(n))) {
                stringBuffer.setCharAt(n, (char)n2);
                stringBuffer.deleteCharAt(n + 1);
            } else {
                stringBuffer.setCharAt(n, (char)n2);
            }
        } else if (XMLChar.isHighSurrogate(stringBuffer.charAt(n))) {
            stringBuffer.setCharAt(n, XMLChar.highSurrogate(n2));
            stringBuffer.setCharAt(n + 1, XMLChar.lowSurrogate(n2));
        } else {
            stringBuffer.setCharAt(n, XMLChar.highSurrogate(n2));
            stringBuffer.insert(n + 1, XMLChar.lowSurrogate(n2));
        }
    }

    boolean getExcluded(char c) {
        return data.getExcluded(c);
    }

    String getRawDecompositionMapping(char c) {
        return data.getRawDecompositionMapping(c);
    }
}

