/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.modify.GraphStoreBasic;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateException;

public class GraphStoreFactory {
    public static GraphStore create() {
        return new GraphStoreBasic();
    }

    public static GraphStore create(Model model) {
        return new GraphStoreBasic(model.getGraph());
    }

    public static GraphStore create(Graph graph) {
        return new GraphStoreBasic(graph);
    }

    public static GraphStore create(Dataset dataset) {
        if (dataset instanceof DatasetImpl || dataset instanceof DataSourceImpl) {
            return new GraphStoreBasic(dataset);
        }
        throw new UpdateException("Can't create a GraphStore for dataset: " + dataset);
    }
}

