/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.util.FileManager;

public class JA {
    public static final String uri = "http://jena.hpl.hp.com/2005/11/Assembler#";
    protected static Model schema;
    public static final Resource MemoryModel;
    public static final Resource DefaultModel;
    public static final Resource InfModel;
    public static final Resource Object;
    public static final Property reasoner;
    public static final Property reasonerURL;
    public static final Property baseModel;
    public static final Property literalContent;
    public static final Property connection;
    public static final Property rules;
    public static final Resource Model;
    public static final Resource OntModel;
    public static final Resource NamedModel;
    public static final Resource FileModel;
    public static final Resource RDBModel;
    public static final Resource PrefixMapping;
    public static final Resource ReasonerFactory;
    public static final Resource HasFileManager;
    public static final Resource Content;
    public static final Resource Connection;
    public static final Resource Connectable;
    public static final Resource LiteralContent;
    public static final Resource OntModelSpec;
    public static final Resource ModelSource;
    public static final Resource RDBModelSource;
    public static final Property content;
    public static final Resource ExternalContent;
    public static final Property externalContent;
    public static final Property modelName;
    public static final Property ontModelSpec;
    public static final Resource This;
    public static final Resource True;
    public static final Resource False;
    public static final Resource Expanded;
    public static final Property prefix;
    public static final Property namespace;
    public static final Property includes;
    public static final Property directory;
    public static final Property create;
    public static final Property strict;
    public static final Property mapName;
    public static final Property documentManager;
    public static final Property ontLanguage;
    public static final Property importSource;
    public static final Property quotedContent;
    public static final Property contentEncoding;
    public static final Property initialContent;
    public static final Resource RuleSet;
    public static final Property rule;
    public static final Resource HasRules;
    public static final Property rulesFrom;
    public static final Resource ContentItem;
    public static final Property dbClass;
    public static final Resource LocationMapper;
    public static final Property locationMapper;
    public static final Resource FileManager;
    public static final Resource DocumentManager;
    public static final Property fileManager;
    public static final Property policyPath;
    public static final Resource UnionModel;
    public static final Property subModel;
    public static final Property rootModel;
    public static final Property reificationMode;
    public static final Resource minimal;
    public static final Resource convenient;
    public static final Resource standard;
    public static final Resource ReificationMode;
    public static final Property fileEncoding;
    public static final Property dbUser;
    public static final Property dbUserProperty;
    public static final Property dbPassword;
    public static final Property dbPasswordProperty;
    public static final Property dbURL;
    public static final Property dbURLProperty;
    public static final Property dbType;
    public static final Property dbTypeProperty;
    public static final Property dbClassProperty;
    public static final Property assembler;
    public static final Property loadClass;
    public static final Property imports;
    public static final Property reasonerFactory;
    public static final Property reasonerClass;
    public static final Property ja_schema;
    public static final Property likeBuiltinSpec;
    public static final Resource SinglePrefixMapping;
    public static final Property prefixMapping;

    public static String getURI() {
        return uri;
    }

    protected static Resource resource(String localName) {
        return ResourceFactory.createResource(uri + localName);
    }

    public static Property property(String localName) {
        return ResourceFactory.createProperty(uri + localName);
    }

    public static Model getSchema() {
        if (schema == null) {
            schema = JA.complete(com.hp.hpl.jena.util.FileManager.get().loadModel(JA.getSchemaPath()));
        }
        return schema;
    }

    private static Model complete(Model m) {
        Model result = ModelFactory.createDefaultModel();
        result.add(ModelFactory.createRDFSModel(m));
        return result;
    }

    private static String getSchemaPath() {
        return "vocabularies/assembler.n3";
    }

    static {
        MemoryModel = JA.resource("MemoryModel");
        DefaultModel = JA.resource("DefaultModel");
        InfModel = JA.resource("InfModel");
        Object = JA.resource("Object");
        reasoner = JA.property("reasoner");
        reasonerURL = JA.property("reasonerURL");
        baseModel = JA.property("baseModel");
        literalContent = JA.property("literalContent");
        connection = JA.property("connection");
        rules = JA.property("rules");
        Model = JA.resource("Model");
        OntModel = JA.resource("OntModel");
        NamedModel = JA.resource("NamedModel");
        FileModel = JA.resource("FileModel");
        RDBModel = JA.resource("RDBModel");
        PrefixMapping = JA.resource("PrefixMapping");
        ReasonerFactory = JA.resource("ReasonerFactory");
        HasFileManager = JA.resource("HasFileManager");
        Content = JA.resource("Content");
        Connection = JA.resource("Connection");
        Connectable = JA.resource("Connectable");
        LiteralContent = JA.resource("LiteralContent");
        OntModelSpec = JA.resource("OntModelSpec");
        ModelSource = JA.resource("ModelSource");
        RDBModelSource = JA.resource("RDBModelSource");
        content = JA.property("content");
        ExternalContent = JA.resource("ExternalContent");
        externalContent = JA.property("externalContent");
        modelName = JA.property("modelName");
        ontModelSpec = JA.property("ontModelSpec");
        This = JA.resource("this");
        True = JA.resource("true");
        False = JA.resource("false");
        Expanded = JA.resource("Expanded");
        prefix = JA.property("prefix");
        namespace = JA.property("namespace");
        includes = JA.property("includes");
        directory = JA.property("directory");
        create = JA.property("create");
        strict = JA.property("strict");
        mapName = JA.property("mapName");
        documentManager = JA.property("documentManager");
        ontLanguage = JA.property("ontLanguage");
        importSource = JA.property("importSource");
        quotedContent = JA.property("quotedContent");
        contentEncoding = JA.property("contentEncoding");
        initialContent = JA.property("initialContent");
        RuleSet = JA.resource("RuleSet");
        rule = JA.property("rule");
        HasRules = JA.resource("HasRules");
        rulesFrom = JA.property("rulesFrom");
        ContentItem = JA.resource("ContentItem");
        dbClass = JA.property("dbClass");
        LocationMapper = JA.resource("LocationMapper");
        locationMapper = JA.property("locationMapper");
        FileManager = JA.resource("FileManager");
        DocumentManager = JA.resource("DocumentManager");
        fileManager = JA.property("fileManager");
        policyPath = JA.property("policyPath");
        UnionModel = JA.resource("UnionModel");
        subModel = JA.property("subModel");
        rootModel = JA.property("rootModel");
        reificationMode = JA.property("reificationMode");
        minimal = JA.resource("minimal");
        convenient = JA.resource("convenient");
        standard = JA.resource("standard");
        ReificationMode = JA.resource("ReificationMode");
        fileEncoding = JA.property("fileEncoding");
        dbUser = JA.property("dbUser");
        dbUserProperty = JA.property("dbUserProperty");
        dbPassword = JA.property("dbPassword");
        dbPasswordProperty = JA.property("dbPasswordProperty");
        dbURL = JA.property("dbURL");
        dbURLProperty = JA.property("dbURLProperty");
        dbType = JA.property("dbType");
        dbTypeProperty = JA.property("dbTypeProperty");
        dbClassProperty = JA.property("dbClassProperty");
        assembler = JA.property("assembler");
        loadClass = JA.property("loadClass");
        imports = JA.property("imports");
        reasonerFactory = JA.property("reasonerFactory");
        reasonerClass = JA.property("reasonerClass");
        ja_schema = JA.property("schema");
        likeBuiltinSpec = JA.property("likeBuiltinSpec");
        SinglePrefixMapping = JA.resource("SinglePrefixMapping");
        prefixMapping = JA.property("prefixMapping");
    }
}

