/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.InteractionImpl;
import org.biopax.paxtools.impl.level3.PathwayImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.ProcessImpl;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Control.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ControlImpl
extends InteractionImpl
implements Control {
    private ControlType controlType;
    private Set<Pathway> pathwayController = BPCollections.I.createSafeSet();
    private Set<PhysicalEntity> peController = BPCollections.I.createSafeSet();
    private Set<Process> controlled = BPCollections.I.createSafeSet();

    @Transient
    public Class<? extends Control> getModelInterface() {
        return Control.class;
    }

    @Override
    @Enumerated
    public ControlType getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(ControlType ControlType2) {
        this.controlType = ControlType2;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ProcessImpl.class)
    @JoinTable(name="controlled")
    public Set<Process> getControlled() {
        return this.controlled;
    }

    protected void setControlled(Set<Process> controlled) {
        this.controlled = controlled;
    }

    @Override
    public void addControlled(Process controlled) {
        if (controlled != null) {
            if (!this.checkControlled(controlled)) {
                throw new IllegalBioPAXArgumentException("Illegal argument. Attempting to set " + controlled.getRDFId() + " to " + this.getRDFId());
            }
            if (controlled != null) {
                this.controlled.add(controlled);
                controlled.getControlledOf().add(this);
                super.addParticipant(controlled);
            }
        }
    }

    @Override
    public void removeControlled(Process controlled) {
        if (controlled != null) {
            super.removeParticipant(controlled);
            controlled.getControlledOf().remove(this);
            this.controlled.remove(controlled);
        }
    }

    @Override
    @Transient
    public Set<Controller> getController() {
        HashSet<PhysicalEntity> controller = new HashSet<PhysicalEntity>(this.getPeController());
        controller.addAll(this.getPathwayController());
        return Collections.unmodifiableSet(controller);
    }

    @Override
    public void addController(Controller controller) {
        if (controller != null) {
            if (controller instanceof Pathway) {
                this.pathwayController.add((Pathway)controller);
            } else {
                this.peController.add((PhysicalEntity)controller);
            }
            controller.getControllerOf().add(this);
            super.addParticipant(controller);
        }
    }

    @Override
    public void removeController(Controller controller) {
        if (controller != null) {
            super.removeParticipant(controller);
            controller.getControllerOf().remove(this);
            if (controller instanceof Pathway) {
                this.pathwayController.remove(controller);
            } else {
                this.peController.remove(controller);
            }
        }
    }

    protected boolean checkControlled(Process Controlled) {
        return true;
    }

    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PathwayImpl.class)
    @JoinTable(name="pathwayController")
    protected Set<Pathway> getPathwayController() {
        return this.pathwayController;
    }

    protected void setPathwayController(Set<Pathway> pathwayController) {
        this.pathwayController = pathwayController;
    }

    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="peController")
    protected Set<PhysicalEntity> getPeController() {
        return this.peController;
    }

    protected void setPeController(Set<PhysicalEntity> peController) {
        this.peController = peController;
    }
}

