/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.tableau.Node;

public class IsAncestorOfCommand
extends AbstractCommand {
    public IsAncestorOfCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "isAncOf";
    }

    public String[] getDescription() {
        return new String[]{"nodeID1 nodeID2", "tests whether nodeID1 is an ancestor of nodeID2"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: isAncOf nodeID1 nodeID2");
        printWriter.println("    Prints whether the node for nodeID1 is an ancestor of the node for nodeID2.");
    }

    public void execute(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length < 3) {
            this.m_debugger.getOutput().println("Node IDs are missing.");
            return;
        }
        try {
            n2 = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_debugger.getOutput().println("Invalid ID of the first node.");
            return;
        }
        try {
            n = Integer.parseInt(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_debugger.getOutput().println("Invalid ID of the second node.");
            return;
        }
        Node node = this.m_debugger.getTableau().getNode(n2);
        Node node2 = this.m_debugger.getTableau().getNode(n);
        if (node == null) {
            this.m_debugger.getOutput().println("Node with ID '" + n2 + "' not found.");
            return;
        }
        if (node2 == null) {
            this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
            return;
        }
        boolean bl = node.isAncestorOf(node2);
        this.m_debugger.getOutput().print("Node " + node.getNodeID() + " is " + (bl ? "" : "not ") + "an ancestor of node " + node2.getNodeID() + ".");
    }
}

