/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousClassExpression;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.ShortFormProvider;
import uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer.AbstractRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxObjectRenderer
extends AbstractRenderer
implements OWLObjectVisitor {
    public static final int LINE_LENGTH = 70;
    private boolean wrapSave;
    private boolean tabSave;

    public ManchesterOWLSyntaxObjectRenderer(Writer writer, ShortFormProvider entityShortFormProvider) {
        super(writer, entityShortFormProvider);
    }

    protected List<? extends OWLObject> sort(Collection<? extends OWLObject> objects) {
        ArrayList<? extends OWLObject> sortedObjects = new ArrayList<OWLObject>(objects);
        Collections.sort(sortedObjects);
        return sortedObjects;
    }

    protected void write(Set<? extends OWLObject> objects, ManchesterOWLSyntax delimeter, boolean newline) {
        int tab = this.getIndent();
        this.pushTab(tab);
        Iterator<? extends OWLObject> it = this.sort(objects).iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            if (newline && this.isUseWrapping()) {
                this.writeNewLine();
            }
            this.write(delimeter);
        }
        this.popTab();
    }

    protected void writeCommaSeparatedList(Set<? extends OWLObject> objects) {
        Iterator<? extends OWLObject> it = new TreeSet<OWLObject>(objects).iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
    }

    protected void write(Set<? extends OWLClassExpression> objects, boolean newline) {
        boolean first = true;
        for (OWLObject oWLObject : this.sort(objects)) {
            if (!first) {
                if (newline && this.isUseWrapping()) {
                    this.writeNewLine();
                }
                this.write(" ", ManchesterOWLSyntax.AND, " ");
            }
            first = false;
            if (oWLObject instanceof OWLAnonymousClassExpression) {
                this.write("(");
            }
            oWLObject.accept(this);
            if (!(oWLObject instanceof OWLAnonymousClassExpression)) continue;
            this.write(")");
        }
    }

    private void writeRestriction(OWLQuantifiedDataRestriction restriction, ManchesterOWLSyntax keyword) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept(this);
        this.write(keyword);
        boolean conjunctionOrDisjunction = false;
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            if (restriction.getFiller() instanceof OWLObjectIntersectionOf || restriction.getFiller() instanceof OWLObjectUnionOf) {
                conjunctionOrDisjunction = true;
                this.incrementTab(4);
                this.writeNewLine();
            }
            this.write("(");
        }
        ((OWLDataRange)restriction.getFiller()).accept(this);
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write(")");
            if (conjunctionOrDisjunction) {
                this.popTab();
            }
        }
    }

    private void writeRestriction(OWLQuantifiedObjectRestriction restriction, ManchesterOWLSyntax keyword) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept(this);
        this.write(keyword);
        boolean conjunctionOrDisjunction = false;
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            if (restriction.getFiller() instanceof OWLObjectIntersectionOf || restriction.getFiller() instanceof OWLObjectUnionOf) {
                conjunctionOrDisjunction = true;
                this.incrementTab(4);
                this.writeNewLine();
            }
            this.write("(");
        }
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write(")");
            if (conjunctionOrDisjunction) {
                this.popTab();
            }
        }
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, V extends OWLObject> void writeRestriction(OWLHasValueRestriction<R, P, V> restriction) {
        restriction.getProperty().accept(this);
        this.write(ManchesterOWLSyntax.VALUE);
        restriction.getValue().accept(this);
    }

    private <R extends OWLPropertyRange, P extends OWLPropertyExpression<R, P>, F extends OWLPropertyRange> void writeRestriction(OWLCardinalityRestriction<R, P, F> restriction, ManchesterOWLSyntax keyword) {
        restriction.getProperty().accept(this);
        this.write(keyword);
        this.write(Integer.toString(restriction.getCardinality()));
        this.writeSpace();
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write("(");
        }
        restriction.getFiller().accept(this);
        if (restriction.getFiller() instanceof OWLAnonymousClassExpression) {
            this.write(")");
        }
    }

    @Override
    public void visit(OWLClass desc) {
        this.write(this.getShortFormProvider().getShortForm(desc));
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.write(desc.getOperands(), true);
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        boolean first = true;
        for (OWLClassExpression op : desc.getOperands()) {
            if (!first) {
                if (this.isUseWrapping()) {
                    this.writeNewLine();
                }
                this.write(" ", ManchesterOWLSyntax.OR, " ");
            }
            first = false;
            if (op.isAnonymous()) {
                this.write("(");
            }
            op.accept(this);
            if (!op.isAnonymous()) continue;
            this.write(")");
        }
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.write("", ManchesterOWLSyntax.NOT, desc.isAnonymous() ? " " : "");
        if (desc.isAnonymous()) {
            this.write("(");
        }
        desc.getOperand().accept(this);
        if (desc.isAnonymous()) {
            this.write(")");
        }
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.SOME);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.ONLY);
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
        this.writeRestriction(desc);
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MIN);
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.EXACTLY);
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MAX);
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.SOME);
        this.write(ManchesterOWLSyntax.SELF);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.write("{");
        this.write(desc.getIndividuals(), ManchesterOWLSyntax.ONE_OF_DELIMETER, false);
        this.write("}");
    }

    @Override
    public void visit(OWLDataSomeValuesFrom desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.SOME);
    }

    @Override
    public void visit(OWLDataAllValuesFrom desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.ONLY);
    }

    @Override
    public void visit(OWLDataHasValue desc) {
        this.writeRestriction(desc);
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MIN);
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.EXACTLY);
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        this.writeRestriction(desc, ManchesterOWLSyntax.MAX);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.write(this.getShortFormProvider().getShortForm(individual));
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.write(this.getShortFormProvider().getShortForm(property));
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.write(this.getShortFormProvider().getShortForm(datatype));
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.toString());
    }

    @Override
    public void visit(IRI iri) {
        this.write(iri.toQuotedString());
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.writeAnnotations(node.getAnnotations());
        node.getProperty().accept(this);
        this.writeSpace();
        node.getValue().accept(this);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(ManchesterOWLSyntax.NOT);
        if (node.getDataRange().isDatatype()) {
            node.getDataRange().accept(this);
        } else {
            this.write("(");
            node.getDataRange().accept(this);
            this.write(")");
        }
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.write("{");
        this.write(node.getValues(), ManchesterOWLSyntax.ONE_OF_DELIMETER, false);
        this.write("}");
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.write("(");
        this.write(node.getOperands(), ManchesterOWLSyntax.AND, false);
        this.write(")");
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.write("(");
        this.write(node.getOperands(), ManchesterOWLSyntax.OR, false);
        this.write(")");
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        node.getDatatype().accept(this);
        this.write("[");
        this.write(node.getFacetRestrictions(), ManchesterOWLSyntax.FACET_RESTRICTION_SEPARATOR, false);
        this.write("]");
    }

    @Override
    public void visit(OWLLiteral node) {
        if (node.getDatatype().isDouble()) {
            this.write(node.getLiteral());
        } else if (node.getDatatype().isFloat()) {
            this.write(node.getLiteral());
            this.write("f");
        } else if (node.getDatatype().isInteger()) {
            this.write(node.getLiteral());
        } else if (node.getDatatype().isBoolean()) {
            this.write(node.getLiteral());
        } else {
            this.pushTab(this.getIndent());
            this.writeLiteral(node.getLiteral());
            if (node.hasLang()) {
                this.write("@");
                this.write(node.getLang());
            } else if (!node.isRDFPlainLiteral()) {
                this.write("^^");
                node.getDatatype().accept(this);
            }
            this.popTab();
        }
    }

    private void writeLiteral(String literal) {
        this.write("\"");
        if (literal.indexOf("\"") == -1 && literal.indexOf("\\") != -1) {
            this.write(literal);
        } else {
            literal = literal.replace("\\", "\\\\");
            literal = literal.replace("\"", "\\\"");
            this.write(literal);
        }
        this.write("\"");
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.write(node.getFacet().getSymbolicForm());
        this.writeSpace();
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.write(ManchesterOWLSyntax.INVERSE);
        this.write("(");
        property.getInverse().accept(this);
        this.write(")");
    }

    private void setAxiomWriting() {
        this.wrapSave = this.isUseWrapping();
        this.tabSave = this.isUseTabbing();
        this.setUseWrapping(false);
        this.setUseTabbing(false);
    }

    private void restore() {
        this.setUseTabbing(this.tabSave);
        this.setUseWrapping(this.wrapSave);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubClass().accept(this);
        this.write(ManchesterOWLSyntax.SUBCLASS_OF);
        axiom.getSuperClass().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        this.write(ManchesterOWLSyntax.NOT);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
        this.restore();
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.ASYMMETRIC);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.REFLEXIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    private void writeBinaryOrNaryList(ManchesterOWLSyntax binaryKeyword, Set<? extends OWLObject> objects, ManchesterOWLSyntax naryKeyword) {
        if (objects.size() == 2) {
            Iterator<? extends OWLObject> it = objects.iterator();
            it.next().accept(this);
            this.write(binaryKeyword);
            it.next().accept(this);
        } else {
            this.writeSectionKeyword(naryKeyword);
            this.writeCommaSeparatedList(objects);
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DISJOINT_WITH, axiom.getClassExpressions(), ManchesterOWLSyntax.DISJOINT_CLASSES);
        this.restore();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.setAxiomWriting();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        axiom.getDomain().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.setAxiomWriting();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        axiom.getDomain().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.EQUIVALENT_TO, axiom.getProperties(), ManchesterOWLSyntax.EQUIVALENT_PROPERTIES);
        this.restore();
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        this.write(ManchesterOWLSyntax.NOT);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.write(")");
        this.restore();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DIFFERENT_FROM, axiom.getIndividuals(), ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS);
        this.restore();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DISJOINT_WITH, axiom.getProperties(), ManchesterOWLSyntax.DISJOINT_PROPERTIES);
        this.restore();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.DISJOINT_WITH, axiom.getProperties(), ManchesterOWLSyntax.DISJOINT_PROPERTIES);
        this.restore();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.setAxiomWriting();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(ManchesterOWLSyntax.RANGE);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.FUNCTIONAL);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.setAxiomWriting();
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getOWLClass().accept(this);
        this.write(ManchesterOWLSyntax.DISJOINT_UNION_OF);
        this.writeCommaSeparatedList(axiom.getClassExpressions());
        this.restore();
    }

    private void writeFrameType(OWLObject object) {
        this.setAxiomWriting();
        if (object instanceof OWLOntology) {
            this.writeFrameKeyword(ManchesterOWLSyntax.ONTOLOGY);
            OWLOntology ont = (OWLOntology)object;
            if (!ont.isAnonymous()) {
                this.write("<");
                this.write(ont.getOntologyID().getOntologyIRI().toString());
                this.write(">");
            }
        } else if (object instanceof OWLClassExpression) {
            this.writeFrameKeyword(ManchesterOWLSyntax.CLASS);
        } else if (object instanceof OWLObjectPropertyExpression) {
            this.writeFrameKeyword(ManchesterOWLSyntax.OBJECT_PROPERTY);
        } else if (object instanceof OWLDataPropertyExpression) {
            this.writeFrameKeyword(ManchesterOWLSyntax.DATA_PROPERTY);
        } else if (object instanceof OWLIndividual) {
            this.writeFrameKeyword(ManchesterOWLSyntax.INDIVIDUAL);
        } else if (object instanceof OWLAnnotationProperty) {
            this.writeFrameKeyword(ManchesterOWLSyntax.ANNOTATION_PROPERTY);
        }
        object.accept(this);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.setAxiomWriting();
        this.writeFrameType(axiom.getEntity());
        this.restore();
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubject().accept(this);
        this.write(" ");
        axiom.getAnnotation().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.setAxiomWriting();
        axiom.getProperty().accept(this);
        this.write(ManchesterOWLSyntax.DOMAIN);
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.setAxiomWriting();
        axiom.getProperty().accept(this);
        this.write(ManchesterOWLSyntax.RANGE);
        axiom.getRange().accept(this);
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubProperty().accept(this);
        this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.SYMMETRIC);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.setAxiomWriting();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSectionKeyword(ManchesterOWLSyntax.RANGE);
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.FUNCTIONAL);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.setAxiomWriting();
        this.writeFrameKeyword(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES);
        this.writeCommaSeparatedList(axiom.getProperties());
        this.restore();
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getIndividual().accept(this);
        this.write(ManchesterOWLSyntax.TYPE);
        axiom.getClassExpression().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.EQUIVALENT_TO, axiom.getClassExpressions(), ManchesterOWLSyntax.EQUIVALENT_CLASSES);
        this.restore();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.setAxiomWriting();
        axiom.getSubject().accept(this);
        this.write(" ");
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write(" ");
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.TRANSITIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.IRREFLEXIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.setAxiomWriting();
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.writeSectionKeyword(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.setAxiomWriting();
        this.writeSectionKeyword(ManchesterOWLSyntax.INVERSE_FUNCTIONAL);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.setAxiomWriting();
        this.writeBinaryOrNaryList(ManchesterOWLSyntax.SAME_AS, axiom.getIndividuals(), ManchesterOWLSyntax.SAME_INDIVIDUAL);
        this.restore();
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.setAxiomWriting();
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(" o ");
        }
        this.write(ManchesterOWLSyntax.SUB_PROPERTY_OF);
        axiom.getSuperProperty().accept(this);
        this.restore();
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.setAxiomWriting();
        axiom.getFirstProperty().accept(this);
        this.write(ManchesterOWLSyntax.INVERSE_OF);
        axiom.getSecondProperty().accept(this);
        this.restore();
    }

    @Override
    public void visit(SWRLRule rule) {
        this.setAxiomWriting();
        Iterator<SWRLAtom> it = rule.getBody().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(" -> ");
        it = rule.getHead().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.restore();
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.setAxiomWriting();
        axiom.getClassExpression().accept(this);
        this.write(ManchesterOWLSyntax.HAS_KEY);
        this.write(axiom.getObjectPropertyExpressions(), ManchesterOWLSyntax.COMMA, false);
        this.write(axiom.getDataPropertyExpressions(), ManchesterOWLSyntax.COMMA, false);
    }

    @Override
    public void visit(SWRLClassAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.write(node.getPredicate().toQuotedString());
        this.write("(");
        Iterator<SWRLDArgument> it = node.getArguments().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.write(", ");
        }
        this.write(")");
    }

    @Override
    public void visit(SWRLVariable node) {
        this.write("?");
        this.write(node.getIRI().toQuotedString());
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.write(ManchesterOWLSyntax.SAME_AS);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write(ManchesterOWLSyntax.DIFFERENT_FROM);
        this.write("(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.write(", ");
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }

    protected void writeAnnotations(Set<OWLAnnotation> annos) {
        if (annos.isEmpty()) {
            return;
        }
        this.writeNewLine();
        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
        this.write(": ");
        this.pushTab(this.getIndent());
        Iterator<OWLAnnotation> annoIt = annos.iterator();
        while (annoIt.hasNext()) {
            OWLAnnotation anno = annoIt.next();
            anno.accept(this);
            if (!annoIt.hasNext()) continue;
            this.write(", ");
            this.writeNewLine();
        }
        this.writeNewLine();
        this.writeNewLine();
        this.popTab();
    }

    @Override
    public void visit(OWLOntology ontology) {
    }
}

