/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPEquivalentClassHandler
extends TriplePredicateHandler {
    public TPEquivalentClassHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_EQUIVALENT_CLASS.getIRI());
    }

    public boolean canHandle(IRI subject, IRI predicate, IRI object) {
        this.inferTypes(subject, object);
        return super.canHandle(subject, predicate, object) && this.isSubjectAndObjectMatchingClassExpressionOrMatchingDataRange(subject, object);
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.inferTypes(subject, object);
        return !this.isSubjectOrObjectAnonymous(subject, object) && this.isSubjectAndObjectMatchingClassExpressionOrMatchingDataRange(subject, object);
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isDataRange(subject) && this.getConsumer().isDataRange(object)) {
            OWLDatatype datatype = this.getDataFactory().getOWLDatatype(subject);
            OWLDataRange dataRange = this.getConsumer().translateDataRange(object);
            this.addAxiom(this.getDataFactory().getOWLDatatypeDefinitionAxiom(datatype, dataRange, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        } else if (this.getConsumer().isClassExpression(subject) && this.getConsumer().isClassExpression(object)) {
            HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
            operands.add(this.translateClassExpression(subject));
            operands.add(this.translateClassExpression(object));
            this.addAxiom(this.getDataFactory().getOWLEquivalentClassesAxiom(operands, this.getPendingAnnotations()));
            this.consumeTriple(subject, predicate, object);
        }
    }
}

