## ----loadup, echo=FALSE----------------------------------------------------
suppressPackageStartupMessages({
library(SummarizedExperiment)
library(ivygapSE)
})

## ----chk-------------------------------------------------------------------
library(ivygapSE)
data(ivySE)
ivySE

## ----lkd-------------------------------------------------------------------
dim(ivySE)

## ----lkse------------------------------------------------------------------
length(unique(metadata(ivySE)$tumorDetails$donor_id))

## ----lkcon-----------------------------------------------------------------
sum(metadata(ivySE)$tumorDetails$tumor_name %in% ivySE$tumor_name)

## ----getsbd,echo=FALSE-----------------------------------------------------
subd = metadata(ivySE)$subBlockDetails
dsub = dim(subd)

## ----featanno,echo=FALSE---------------------------------------------------
featanno = c("normalized_area_le"   =
"Leading Edge (LE)",
"normalized_area_lehbv" =
"Hyperplastic blood vessels in leading edge (LEhbv)",
"normalized_area_it"   =
"Infiltrating Tumor (IT)",
"normalized_area_ithbv" =
"Hyperplastic blood vessels in infiltrating tumor (IThbv)",
"normalized_area_ct"   =
"Cellular Tumor (CT)",
"normalized_area_ctpnz" =
"Perinecrotic zone (CTpnz)",
"normalized_area_cthbv" =
"Hyperplastic blood vessels in cellular tumor (CThbv)",
"normalized_area_ctpnn" =
"Pseudopalisading cells but no visible necrosis (CTpnn)",
"normalized_area_ctpan" =
"Pseudopalisading cells around necrosis (CTpan)",
"normalized_area_ctmvp" =
"Microvascular proliferation (CTmvp)",
"normalized_area_ctne" =
"Necrosis (CTne)")
featanno

