tabItem(tabName = "starburst",
        fluidRow(
            useShinyjs(),
            column(8,  bsAlert("starburstmessage"),
                   bsCollapse(id = "collapsestarburst", open = "starburst plots",
                              bsCollapsePanel("starburst result - probe gene pairs", dataTableOutput('starburstResult'), style = "default"),
                              bsCollapsePanel("starburst plots",
                                              uiOutput("starburstPlot"), style = "default"))),
            column(4,
                   box(title = "Starburst plot",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = FALSE,
                       box(title = "Data",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = FALSE,
                           bsTooltip("starburstmetfile", "Result from Differential DNA Methylation analysis",
                                     "left"),
                           shinyFilesButton('starburstmetfile', 'DMR result',
                                            'Please select DMR_result file',
                                            multiple = FALSE),
                           tags$br(),
                           tags$br(),
                           bsTooltip("starburstexpfile", "Result from Differential Expression Analysis",
                                     "left"),
                           shinyFilesButton('starburstexpfile', 'DEA result', 'Please select expression result object',
                                            multiple = FALSE),
                           selectizeInput('starburstMetPlatform',
                                          label = 'DNA methylation platform',
                                          choices = c("Illumina Human Methylation 450" = "450K",
                                                      "Illumina Human Methylation 27" = "27K",
                                                      "Infinium MethylationEPIC"= "EPIC"),
                                          multiple = FALSE),
                           selectizeInput('starburstGenome',
                                          label = 'Genome of reference',
                                          choices = c("hg38"="hg38","hg19"="hg19"),
                                          multiple = FALSE)
                       ),
                       box(title = "Threshold control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           numericInput("starburstexpFC", "Log FC threshold",
                                        min = 0, max = 10, value = 0, step = 0.05),
                           numericInput("starburstexFDR", "Expression FDR cut-off",
                                        min = 0, max = 1, value = 0.05, step = 0.001),
                           numericInput("starburstmetdiff", "Mean DNA methylation difference threshold",
                                        min = 0, max = 1, value = 0, step = 0.05),
                           numericInput("starburstmetFDR", "Methylation FDR cut-off",
                                        min = 0, max = 1, value = 0.05, step = 0.001)),
                       box(title = "Highlighting options",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           checkboxInput("starburstNames", "Show genes names?", value = FALSE, width = NULL),
                           checkboxInput("starburstNamesFill", "Boxed names?", value = TRUE, width = NULL)
                       ),
                       box(title = "Colors control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           colourpicker::colourInput("sbcolInsignigicant", "Insignificant", value = "black"),
                           colourpicker::colourInput("sbcolUpHypo", "Upregulated & Hypomethylated", value =  "#E69F00"),
                           colourpicker::colourInput("sbcolDownHypo", "Downregulated & Hypomethylated", value = "#56B4E9"),
                           colourpicker::colourInput("sbcolHypo", "Hypomethylated", value = "#009E73"),
                           colourpicker::colourInput("sbcolHyper", "Hypermethylated", value = "red"),
                           colourpicker::colourInput("sbcolUp", "Upregulated", value =  "#0072B2"),
                           colourpicker::colourInput("sbcolDown", "Downregulated", value = "#D55E00"),
                           colourpicker::colourInput("sbcolUpHyper", "Upregulated & Hypermethylated", value = "#CC79A7"),
                           colourpicker::colourInput("sbcolDownHyper", "Downregulated & Hypermethylated", value = "purple")),
                       box(title = "Size control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           sliderInput("starburstwidth", "Plot Width (%)", min = 0, max = 100, value = 100),
                           sliderInput("starburstheight", "Plot Height (px)", min = 0, max = 1200, value = 800)),
                       bsTooltip("starburstSave", "Save results of significant genes into a csv file",
                                 "left"),
                       checkboxInput("starburstSave", "Save result?", value = FALSE, width = NULL),
                       actionButton("starburstPlot",
                                    "starburst plot",
                                    style = "background-color: #000080;
                                    color: #FFFFFF;
                                    margin-left: auto;
                                    margin-right: auto;
                                    width: 100%",
                                    icon = icon("picture-o")),
                       downloadButton('savestarburstpicture', 'Export figure', class = "butt2"),
                       textInput("starburstPlot.filename", label = "Filename", value = "volcano.pdf"),
                       bsTooltip("starburstPlot.filename", "Filename (pdf, png, svg)", "left")
                       )
            )
        )
)
