tabItem(tabName = "elmerresults",
        fluidRow(
            column(8,  bsAlert("elmermessageresults"),
                   bsCollapse(id = "collapelmerresults", open = "Plots",
                              bsCollapsePanel("Results table", DT::dataTableOutput('elmerResult'), style = "default"),
                              bsCollapsePanel("Plots", uiOutput("elmerPlot"), style = "default"))),
            column(4,
                   box(title = "Analysis", width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = TRUE,collapsed = FALSE,
                       box(title = "Data", width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = FALSE,
                           shinyFilesButton('elmerresultsfile', 'Select results', 'Please select results object',
                                            multiple = FALSE),
                           bsTooltip("elmerresultsfile", "An R object (.rda) with ELMER results (output from ELMER analysis menu)",
                                     "left")
                       ),
                       box(title = "Plots", width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           box(title = "Type selection", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = FALSE,
                               selectizeInput("elmerPlotType", "Type of plot:",
                                              c("Scatter plots"="scatter.plot",
                                                "Schematic Plot"= "schematic.plot",
                                                "Heatmap pairs"= "heatmap.plot",
                                                "Motif enrichment plot"="motif.enrichment.plot",
                                                "TF ranking plot"="ranking.plot"),
                                              multiple = FALSE),
                               #sliderInput("motif.enrichment.plot.or", "OR", min = 1, max = 20, value = 20),
                               #sliderInput("motif.enrichment.plot.lowerOR", "OR", min = 1, max = 20, value = 1.1),
                               #sliderInput("motif.enrichment.plot.nbprobes", "NumOfProbes", min = 1, max = 50, value = 10),
                               selectizeInput("ranking.plot.motif", "Enriched motif:",
                                              NULL,
                                              multiple = FALSE),
                               selectizeInput("ranking.plot.tf", "Highlight TF:",
                                              NULL,
                                              multiple = TRUE),
                               radioButtons("schematic.plot.type", "Schematic plot by:",
                                            c("Genes"="genes",
                                              "Probes"="probes")),
                               selectizeInput("schematic.plot.genes", "Genes:",
                                              NULL,
                                              multiple = FALSE),
                               selectizeInput("schematic.plot.probes", "Probes:",
                                              NULL,
                                              multiple = FALSE),
                               selectizeInput("elmer.heatmap.annotations", "Annotations:",
                                              NULL,
                                              multiple = TRUE),
                               radioButtons("scatter.plot.type", "Scatter plot by:",
                                            c("By TF"="tf",
                                              "By Probes"="probes",
                                              "By Pair"="pair")),
                               selectizeInput("scatter.plot.genes", "Genes:",
                                              NULL,
                                              multiple = FALSE),
                               checkboxInput("motif.enrichment.plot.summary","Add summary table",FALSE),
                               sliderInput("scatter.plot.nb.genes", "Number of genes", min = 1, max = 20, value = 20),
                               selectizeInput("scatter.plot.probes", "Probes:",
                                              NULL,
                                              multiple = FALSE),
                               selectizeInput("scatter.plot.tf", "TF:",
                                              NULL,
                                              multiple = TRUE),
                               selectizeInput("scatter.plot.motif", "Sites with motif:",
                                              NULL,
                                              multiple = FALSE),
                               numericInput("motif.enrichment.plot.or", "OR cut-off", min = 1, max = 5, value = 1.3, step = 0.1),
                               numericInput("motif.enrichment.plot.loweror", "lower OR cut-off", min = 1, max = 5, value = 1.1,step = 0.1)
                           ),
                           box(title = "Size control", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               sliderInput("elmerwidth", "Plot Width (%)", min = 0, max = 100, value = 100),
                               sliderInput("elmerheight", "Plot Height (px)", min = 0, max = 1200, value = 800)),
                           actionButton("elmerPlotBt",
                                        "Plot",
                                        style = "background-color: #000080;
                                            color: #FFFFFF;
                                            margin-left: auto;
                                            margin-right: auto;
                                            width: 100%",
                                        icon = icon("picture-o")),
                           downloadButton('saveelmerpicture', 'Export figure', class = "butt2"),
                           textInput("elmerPlot.filename", label = "Filename", value = "elmer_plot.pdf"),
                           bsTooltip("elmerPlot.filename", "Filename (pdf, png, svg)", "left")
                           ),
                       box(title = "Results table", width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           selectizeInput("elmerTableType", "Table to show:",
                                          c("Signigicant probes"="sigprobes",
                                            "Pair probe/gene"="pair",
                                            "Enriched motifs"="motif",
                                            "Regulatory TFs"="tf"
                                          ),
                                          multiple = FALSE))
                   )
            )
        )
)
