### R code from vignette source 'SwathXtend_vignette.Rnw'

###################################################
### code chunk number 1: SwathXtend_vignette.Rnw:49-51 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("SwathXtend")


###################################################
### code chunk number 2: 1
###################################################
rm(list=ls())
library(SwathXtend)


###################################################
### code chunk number 3: 2
###################################################
filenames <- c("Lib2.txt", "Lib3.txt") 
libfiles <- paste(system.file("files",package="SwathXtend"),
	filenames,sep="/")
Lib2 <- readLibFile(libfiles[1], clean=TRUE)
Lib3 <- readLibFile(libfiles[2], clean=TRUE)


###################################################
### code chunk number 4: SwathXtend_vignette.Rnw:139-143 (eval = FALSE)
###################################################
## Lib2 <- cleanLib(Lib2, intensity.cutoff = 5, conf.cutoff = 0.99, 
## 			nomod = FALSE, nomc = FALSE)
## Lib3 <- cleanLib(Lib3, intensity.cutoff = 5, conf.cutoff = 0.99, 
## 			nomod = FALSE, nomc = FALSE)


###################################################
### code chunk number 5: 3
###################################################
checkQuality(Lib2, Lib3)


###################################################
### code chunk number 6: SwathXtend_vignette.Rnw:165-166
###################################################
plotRTCor(Lib2, Lib3, "Lib2", "Lib3")


###################################################
### code chunk number 7: SwathXtend_vignette.Rnw:169-170
###################################################
plotRTResd(Lib2, Lib3)


###################################################
### code chunk number 8: SwathXtend_vignette.Rnw:173-174
###################################################
plotRIICor(Lib2, Lib3)


###################################################
### code chunk number 9: c
###################################################
plotAll(Lib2, Lib3, file="allplots.xlsx")


###################################################
### code chunk number 10: 4 (eval = FALSE)
###################################################
## Lib2_3 <- buildSpectraLibPair(libfiles[1], libfiles[2], clean=T, 
## 				nomc=T, nomod=T, plot=F, 
## 				outputFormat = "peakview",
## 				outputFile = "Lib2_3.txt")	


###################################################
### code chunk number 11: SwathXtend_vignette.Rnw:201-205
###################################################
hydroFile <- paste(system.file("files",package="SwathXtend"),
				"hydroIndex.txt",sep="/")
hydro <- readLibFile(hydroFile, type="hydro")
head(hydro)					


###################################################
### code chunk number 12: SwathXtend_vignette.Rnw:211-217 (eval = FALSE)
###################################################
## Lib2_3.hydro <- buildSpectraLibPair(libfiles[1], libfiles[2], hydro, 
## 				clean=T, 
## 				nomc=T, nomod=T, plot=F, 
## 				method="hydro",
## 				outputFormat = "peakview",
## 				outputFile = "Lib2_3.txt")	


###################################################
### code chunk number 13: SwathXtend_vignette.Rnw:223-224 (eval = FALSE)
###################################################
## outputLib(Lib2_3, filename="Lib2_3.txt", format="peakview")


###################################################
### code chunk number 14: SwathXtend_vignette.Rnw:239-242 (eval = FALSE)
###################################################
## libfiles <- paste(system.file("files",package="SwathXtend"),
## 		c("Lib2.txt", "Lib2_3.txt"),sep="/")
## res = reliabilityCheckLibrary(libfiles[1], libfiles[2])


###################################################
### code chunk number 15: SwathXtend_vignette.Rnw:255-260
###################################################
fswaths = paste(system.file("files",package="SwathXtend"),
	c("Swath_result_seed.xlsx", "Swath_result_ext.xlsx"), 
	sep="/")
res = reliabilityCheckSwath(fswaths[1], fswaths[2], max.fdrpass=8, 
	max.peptide=2)


###################################################
### code chunk number 16: SwathXtend_vignette.Rnw:297-299
###################################################
fdr.seed = readWorkbook(fswaths[1], sheet='FDR')
fdr.ext = readWorkbook(fswaths[2], sheet='FDR')


###################################################
### code chunk number 17: SwathXtend_vignette.Rnw:305-308
###################################################
fdr.seed = fdr.crit(fdr.seed)
fdr.ext = fdr.crit(fdr.ext)
head(fdr.ext[,c(1:2,ncol(fdr.ext))])


###################################################
### code chunk number 18: SwathXtend_vignette.Rnw:314-316 (eval = FALSE)
###################################################
## swa.seed = readWorkbook(fswaths[1], 2)
## swa.ext = readWorkbook(fswaths[2], 2)


###################################################
### code chunk number 19: SwathXtend_vignette.Rnw:324-329 (eval = FALSE)
###################################################
## fdr.seed = fdr.seed[fdr.seed$nfdr.pass > 0,]
## fdr.ext = fdr.ext[fdr.ext$nfdr.pass > 0,]
## 
## res = quantification.accuracy(swa.seed[fdr.seed$nfdr.pass >= 1,], 
## 	swa.ext[fdr.ext$nfdr.pass >= 1,], method="cv")[[1]]


