/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.CountObject;
import base.DebugLog;
import base.RegexOption;
import config.Sample;
import config.SequencingRunInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;

public class Util {
    private static final double LOG2 = Math.log(2.0);
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static int MAX_NUM_OF_THREAD;

    public static int atoi(String string, int n) {
        char c;
        int n2;
        int n3 = 0;
        for (int i = n; i < string.length() && (n2 = (c = string.charAt(i)) - 48) >= 0 && n2 < 10; ++i) {
            n3 = n3 * 10 + n2;
        }
        return n3;
    }

    public static double log2(double d) {
        return Math.log(d) / LOG2;
    }

    public static void printMemeoryUsage() {
        int n = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        DebugLog.log("Used Memory: " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n + " MB");
        DebugLog.log("Free Memory: " + runtime.freeMemory() / (long)n + " MB");
        DebugLog.log("Max Memory:  " + runtime.maxMemory() / (long)n + " MB");
    }

    public static Object[] getMemeoryUsage() {
        int n = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{"Free Memory", "Used Memory", "Max Memory"};
        String[] stringArray2 = new String[]{(runtime.totalMemory() - runtime.freeMemory()) / (long)n + " MB", runtime.freeMemory() / (long)n + " MB", runtime.maxMemory() / (long)n + " MB"};
        return new Object[]{stringArray, stringArray2};
    }

    public static File createTempDirectory() throws Exception {
        File file = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!file.delete()) {
            throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
        }
        if (!file.mkdir()) {
            throw new IOException("Could not create temp directory: " + file.getAbsolutePath());
        }
        return file;
    }

    public static SequencingRunInfo cloneWithoutSample(SequencingRunInfo sequencingRunInfo) {
        try {
            SequencingRunInfo sequencingRunInfo2 = (SequencingRunInfo)Util.cloneObjectBySetterGetter(sequencingRunInfo);
            return sequencingRunInfo2;
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
    }

    public static Sample cloneSample(Sample sample) {
        try {
            Sample sample2 = (Sample)Util.cloneObjectBySetterGetter(sample);
            return sample2;
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
    }

    public static Object cloneObjectBySetterGetter(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        Object obj = object.getClass().newInstance();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            try {
                if (string.startsWith("get")) {
                    clazz.getMethod(string.replaceFirst("get", "set"), methodArray[i].getReturnType()).invoke(obj, methodArray[i].invoke(object, new Object[0]));
                    continue;
                }
                if (!string.startsWith("is")) continue;
                clazz.getMethod(string.replaceFirst("is", "set"), methodArray[i].getReturnType()).invoke(obj, methodArray[i].invoke(object, new Object[0]));
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return obj;
    }

    public static Properties loadProperties(String string) {
        DebugLog.log("Reading configuration file:" + string);
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            DebugLog.log(exception);
            throw new RuntimeException("Can't load the config file:" + string);
        }
        return properties;
    }

    public static boolean isAbsolutePath(String string) {
        if (string.startsWith("/")) {
            return true;
        }
        return string.length() > 2 && string.charAt(1) == ':';
    }

    public static String getMD5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            messageDigest.update(byArray, 0, n);
            byte[] byArray2 = messageDigest.digest();
            return Util.bytesToHex(byArray2);
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
    }

    public static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = hexArray[n >>> 4];
            cArray[i * 2 + 1] = hexArray[n & 0xF];
        }
        return new String(cArray);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void radixSort(CountObject[] countObjectArray, int n) {
        int n2 = countObjectArray[0].getKey().getLength();
        int n3 = 6;
        LinkedList[] linkedListArray = new LinkedList[(int)Math.pow(4.0, n3)];
        for (int i = 0; i < linkedListArray.length; ++i) {
            linkedListArray[i] = new LinkedList();
        }
        long l = (long)(1 << 2 * n3) - 1L;
        int n4 = 0;
        int n5 = (int)Math.ceil((double)n2 * 1.0 / (double)n3);
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            for (n7 = 0; n7 < n; ++n7) {
                n6 = (int)((countObjectArray[n7].getKey().getValue() & l) >> n4);
                linkedListArray[n6].add(countObjectArray[n7]);
            }
            n7 = 0;
            for (n6 = 0; n6 < linkedListArray.length; ++n6) {
                for (CountObject countObject : linkedListArray[n6]) {
                    countObjectArray[n7++] = countObject;
                }
                linkedListArray[n6].clear();
            }
            l <<= n3 * 2;
            n4 += n3 * 2;
        }
    }

    public static int getNumberOfCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static void outputColumnBasedArrays(PrintWriter printWriter, Object[] objectArray, String[] stringArray) {
        for (String string : stringArray) {
            printWriter.print(string + "\t");
        }
        printWriter.println();
        int n = objectArray.length;
        int n2 = Array.getLength(objectArray[0]);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                printWriter.print(Array.get(objectArray[j], i) + "\t");
            }
            printWriter.println();
        }
    }

    public static void output1DArray(PrintWriter printWriter, Object[] objectArray) {
        for (Object object : objectArray) {
            printWriter.print(object + "\t");
        }
        printWriter.println();
    }

    public static void output1DArray(PrintWriter printWriter, Collection collection, int n) {
        int n2 = 0;
        for (Object e : collection) {
            if (++n2 <= n) continue;
            printWriter.print(e + "\t");
        }
        printWriter.println();
    }

    public static String getKmerFilterString(RegexOption regexOption) {
        if (regexOption == null) {
            regexOption = new RegexOption();
        }
        return regexOption.getKmerRegexFomattedString();
    }

    public static String getVariableRegionFilterString(RegexOption regexOption) {
        if (regexOption == null) {
            regexOption = new RegexOption();
        }
        return regexOption.getVariableRegionRegexFormattedString();
    }

    public static String joinStrings(Collection<String> collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : collection) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
        }
        stringBuffer.setLength(stringBuffer.length() - string.length());
        return stringBuffer.toString();
    }

    public static int getMaxThreadNumber() {
        return MAX_NUM_OF_THREAD;
    }

    public static void setMaxThreadNumber(Integer n) {
        if (n > 0) {
            MAX_NUM_OF_THREAD = n;
            DebugLog.log("Max number of thread : " + n);
        }
    }

    static {
        int n = Util.getNumberOfCores();
        MAX_NUM_OF_THREAD = Math.min(n, 4) * 2;
    }
}

