/*
 * Decompiled with CFR 0.152.
 */
package reder.application.layout;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import reder.application.graph.EdgeBank;

public class JungAlgorithms {
    protected Layout<Integer, Integer> layout;
    protected VisualizationViewer<Integer, Integer> vv;
    private Graph<Integer, Integer> g = new UndirectedSparseGraph<Integer, Integer>();
    private Point2D[] ponto;
    private String panelType;
    private Dimension dim;

    public void inputArray(int sizeArrayNode, ArrayList<EdgeBank> arrayEdge, int tipo, double width, double height, String panelType) {
        this.panelType = panelType;
        this.dim = new Dimension((int)width, (int)height);
        if (arrayEdge.size() >= 0) {
            int i;
            for (i = 0; i < sizeArrayNode; ++i) {
                this.g.addVertex(i);
            }
            for (i = 0; i < arrayEdge.size(); ++i) {
                this.g.addEdge((Integer)i, arrayEdge.get(i).getA(), arrayEdge.get(i).getB());
            }
            this.layout = this.useLayout(this.g, tipo);
            this.layout.setSize(new Dimension((int)width, (int)height));
            this.vv = new VisualizationViewer<Integer, Integer>(this.layout);
            this.vv.setPreferredSize(new Dimension((int)width, (int)height));
            this.vv.setGraphLayout(this.layout);
            this.ponto = new Point2D[sizeArrayNode];
            double xMax = 0.0;
            double yMax = 0.0;
            double xMin = 1.0E8;
            double yMin = 1.0E8;
            for (int i2 = 0; i2 < sizeArrayNode; ++i2) {
                this.ponto[i2] = (Point2D)this.layout.transform(i2);
                double x = ((Point2D)this.layout.transform(i2)).getX();
                double y = ((Point2D)this.layout.transform(i2)).getY();
                if (x > xMax) {
                    xMax = x;
                }
                if (y > yMax) {
                    yMax = y;
                }
                if (x < xMin) {
                    xMin = x;
                }
                if (!(y < yMin)) continue;
                yMin = y;
            }
            double escala = 0.9;
            if (panelType.equals("container")) {
                escala = 0.95;
            }
            this.setPosition(xMax, yMax, xMin, yMin, escala, width, height);
        }
    }

    public Point2D[] getArrayPontos() {
        return this.ponto;
    }

    private Layout useLayout(Graph g, int i) {
        switch (i) {
            case 0: {
                return this.useCircleLayout(g);
            }
            case 1: {
                return this.useKKLayout(g);
            }
            case 2: {
                return this.useFRLayout(g);
            }
            case 3: {
                return this.useSpringLayout(g);
            }
        }
        return this.useCircleLayout(g);
    }

    private Layout useSpringLayout(Graph g) {
        SpringLayout l = new SpringLayout(g);
        l.setSize(this.dim);
        l.setRepulsionRange(50);
        l.setForceMultiplier(0.75);
        return l;
    }

    private Layout useFRLayout(Graph g) {
        FRLayout l = new FRLayout(g);
        l.setSize(this.dim);
        l.step();
        l.setAttractionMultiplier(0.25);
        l.setRepulsionMultiplier(0.25);
        return l;
    }

    private Layout useKKLayout(Graph g) {
        KKLayout kk = new KKLayout(g);
        CircleLayout l = new CircleLayout(g);
        l.setSize(this.dim);
        kk.setInitializer(l);
        kk.setSize(this.dim);
        if (this.panelType.equals("container")) {
            kk.setLengthFactor(1.5);
        }
        return kk;
    }

    private Layout useCircleLayout(Graph g) {
        CircleLayout l = new CircleLayout(g);
        return l;
    }

    private void setPosition(double xMax, double yMax, double xMin, double yMin, double escala, double width, double height) {
        double length = Math.min(width, height) * escala;
        double dx = xMax - xMin;
        double dy = yMax - yMin;
        double rescale = length / Math.max(dx, dy);
        double addx = (width - dx * rescale) / 2.0;
        double addy = (height - dy * rescale) / 2.0;
        for (int i = 0; i < this.ponto.length; ++i) {
            double x = (this.ponto[i].getX() - xMin) * rescale + addx;
            double y = (this.ponto[i].getY() - yMin) * rescale + addy;
            this.ponto[i].setLocation(x, y);
        }
    }

    private void setPositionOLD(double xMax, double yMax, double xMin, double yMin, double escala, double width, double height) {
        double tw;
        double th;
        double hmax;
        double hmin;
        if (width > height) {
            hmin = height * escala;
            hmax = width * escala;
            th = 0.0;
            tw = 1.0;
        } else {
            hmin = width * escala;
            hmax = height * escala;
            th = 1.0;
            tw = 0.0;
        }
        xMin = xMin / xMax * hmin + (hmax - hmin) * tw;
        yMin = yMin / yMax * hmin + (hmax - hmin) * th;
        double dx = xMin / 2.0;
        double dy = yMin / 2.0;
        for (int i = 0; i < this.ponto.length; ++i) {
            double x = this.ponto[i].getX() / xMax * hmin + (hmax - hmin) * tw;
            double y = this.ponto[i].getY() / yMax * hmin + (hmax - hmin) * th;
            x = x - dx + (width - width * escala) / 2.0;
            y = y - dy + (height - height * escala) / 2.0;
            this.ponto[i].setLocation(x, y);
        }
    }
}

