/*
 * Decompiled with CFR 0.152.
 */
package reder.application.cluster;

import edu.uci.ics.jung.algorithms.cluster.EdgeBetweennessClusterer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.ArrayList;
import java.util.Set;
import java.util.Vector;
import reder.application.cluster.JCA;
import reder.application.graph.EdgeBank;
import reder.application.graph.NodeBank;

public class ClusteringInterface {
    protected Vector dataPoints;
    protected JCA KMres;
    protected Set<Set<Integer>> EBres;

    public void inputAndGoKM(Vector dp, int totalClustersAssigned, int totalInteractions) {
        this.dataPoints = dp;
        this.KMres = new JCA(totalClustersAssigned, totalInteractions, this.dataPoints);
        this.KMres.startAnalysis();
    }

    public Vector[] getKMCluster() {
        return this.KMres.getClusterOutput();
    }

    public void inputAndGoEB(ArrayList<NodeBank> arrayNode, ArrayList<EdgeBank> arrayEdge, int clustersAssigned) {
        UndirectedSparseGraph<Integer, Integer> g = new UndirectedSparseGraph<Integer, Integer>();
        int sizeArrayNode = arrayNode.size();
        int sizeArrayEdge = arrayEdge.size();
        if (sizeArrayEdge > 0) {
            int i;
            for (i = 0; i < sizeArrayNode; ++i) {
                g.addVertex(i);
            }
            for (i = 0; i < sizeArrayEdge; ++i) {
                g.addEdge(Integer.valueOf(i), arrayEdge.get(i).getA(), arrayEdge.get(i).getB());
            }
            EdgeBetweennessClusterer<Integer, Integer> alg = new EdgeBetweennessClusterer<Integer, Integer>(clustersAssigned);
            this.EBres = alg.transform((Graph<Integer, Integer>)g);
        }
    }

    public Set<Set<Integer>> getEBCluster() {
        return this.EBres;
    }
}

