/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.SequenceUtil;

public class QualityScoreDistribution
extends CommandLineProgram {
    @Option(shortName="I", doc="The input BAM file to process")
    public File INPUT;
    @Option(shortName="O", doc="A file to write the table of qualities to")
    public File OUTPUT;
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only")
    public boolean PF_READS_ONLY = false;
    @Option(doc="If set to true, include quality for no-call bases in the distribution")
    public boolean INCLUDE_NO_CALLS = false;
    @Option(doc="Stop after processing N reads. Mostly for debugging purposes.")
    public int STOP_AFTER = 0;

    public static void main(String[] args) {
        System.exit(new QualityScoreDistribution().instanceMain(args));
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        SAMFileReader in = new SAMFileReader(this.INPUT);
        Histogram<Byte> qHisto = new Histogram<Byte>("QUALITY", "COUNT_OF_Q");
        Histogram<Byte> oqHisto = new Histogram<Byte>("QUALITY", "COUNT_OF_OQ");
        int processed = 0;
        for (SAMRecord rec : in) {
            if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag() || this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) continue;
            byte[] bases = rec.getReadBases();
            byte[] quals = rec.getBaseQualities();
            byte[] oq = rec.getOriginalBaseQualities();
            int length = quals.length;
            for (int i = 0; i < length; ++i) {
                if (!this.INCLUDE_NO_CALLS && SequenceUtil.isNoCall(bases[i])) continue;
                qHisto.increment(quals[i]);
                if (oq == null) continue;
                oqHisto.increment(oq[i]);
            }
            if (this.STOP_AFTER <= 0 || ++processed <= this.STOP_AFTER) continue;
            break;
        }
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(qHisto);
        if (!oqHisto.isEmpty()) {
            metrics.addHistogram(oqHisto);
        }
        metrics.write(this.OUTPUT);
        int rResult = RExecutor.executeFromClasspath("net/sf/picard/analysis/qualityScoreDistribution.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName());
        if (rResult != 0) {
            throw new PicardException("R script qualityScoreDistribution.R failed with return code " + rResult);
        }
        return 0;
    }
}

