### R code from vignette source 'Rdisop.Rnw'

###################################################
### code chunk number 1: Rdisop.Rnw:118-122
###################################################
library(Rdisop)
molecule <- getMolecule("C2H5OH")
getFormula(molecule)
getMass(molecule)


###################################################
### code chunk number 2: Rdisop.Rnw:134-139
###################################################
essentialElements <- initializeCHNOPSMgKCaFe()
chlorophyll <- getMolecule("C55H72MgN4O5H", z=1, 
  elements=essentialElements)
isotopes <- getIsotope(chlorophyll, seq(1,4))
isotopes


###################################################
### code chunk number 3: isotopes
###################################################
plot(t(isotopes), type="h", xlab="m/z", ylab="Intensity")


###################################################
### code chunk number 4: Rdisop.Rnw:164-166
###################################################
molecules <- decomposeMass(46.042, ppm=20)
molecules


###################################################
### code chunk number 5: Rdisop.Rnw:179-180
###################################################
length(decomposeMass(147.053))


###################################################
### code chunk number 6: Rdisop.Rnw:188-194
###################################################
# glutamic acid (C5H9NO4)
masses <- c(147.053, 148.056)
intensities <- c(93, 5.8)

molecules <- decomposeIsotopes(masses, intensities)
cbind(getFormula(molecules), getScore(molecules), getValid(molecules))


###################################################
### code chunk number 7: Rdisop.Rnw:209-211
###################################################
querymolecule <- subMolecules("C5H10NO4", "H")
getFormula(querymolecule)


