## ----first_load, echo=TRUE, warning=FALSE, results='hide', message=FALSE----
library(RITANdata)
library(RITAN)

## ----geneset_overlap1, echo=TRUE, warning=FALSE, fig.width = 7, fig.height = 7, fig.align='center'----
# Show the fraction of genes common to multiple disease-gene relationships
o <- geneset_overlap( geneset_list$DisGeNet )
plot(density(c(o)), main='', xlab='Fraction Shared Genes', ylab='Prob()')
diag(o) <- NA # ignore self-overlap
i <- which( o > 0.8, arr.ind = TRUE )
mat <- o[ unique(i[,1]), unique(i[,2]) ]
heatmap( mat, col = rev(gray(seq(0,1,length.out = 15))),
         cexRow=.7, cexCol=0.7, margins = c(7,7) )

## ----geneset_overlap2, echo=TRUE, warning=FALSE, fig.width = 7, fig.height = 7, fig.align='center'----
# Show the fraction of genes common between disease-gene relationships and GO-Slim
o <- geneset_overlap( geneset_list$DisGeNet, geneset_list$GO_slim_generic )
o <- o[ , !( colnames(o) %in% c('biological_process', 'molecular_function', 'cellular_component')) ] # remove the root of each sub-ontology
plot(density(c(o)), main='', xlab='Fraction Shared Genes', ylab='Prob()')
i <- which( o > 0.95, arr.ind = TRUE )
mat <- o[ unique(i[,1]), unique(i[,2]) ]
heatmap( mat, col = rev(gray(seq(0,1,length.out = 15))),
         cexRow=.7, cexCol=0.7, margins = c(7,7) )

## ----geneset_overlap3, echo=TRUE, warning=FALSE--------------------------
rownames(o)[ o[ , "chromosome_organization" ] > 0.66 ]

## ----geneset_overlap4, echo=TRUE, warning=FALSE--------------------------
d <- rownames(o)[ o[ , "cell_motility" ] > 0.66 ]
str(d)
new_geneset <- intersect( unique(unlist(geneset_list$DisGeNet[d])),
                          unique(unlist(geneset_list$GO_slim_generic$cell_motility)) )
str(new_geneset)

