/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import java.util.HashMap;
import junit.framework.TestCase;
import org.cytoscape.equations.builtins.Framework;

public class SignTest
extends TestCase {
    public void testAll() throws Exception {
        HashMap<String, Object> variablesAndValues = new HashMap<String, Object>();
        variablesAndValues.put("POS", 11L);
        variablesAndValues.put("NEG", -12L);
        variablesAndValues.put("ZERO", 0L);
        SignTest.assertTrue(Framework.executeTest("=SIGN(0.0)", 0.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(9)", 1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(-1e22)", -1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN($POS)", variablesAndValues, 1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN($NEG)", variablesAndValues, -1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN($ZERO)", variablesAndValues, 0.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(true)", 1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(false)", 0.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(\"1e22\")", 1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(\"-9.0\")", -1.0));
        SignTest.assertTrue(Framework.executeTest("=SIGN(\"0.0\")", 0.0));
        SignTest.assertTrue(Framework.executeTestExpectFailure("=SIGN(\"Fred\")"));
    }
}

