/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesUtils;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.Appearance;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.MappingFactory;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Edge;
import giny.model.GraphObject;
import giny.model.Node;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCalculator
implements Calculator {
    protected Vector<ObjectMapping> mappings = new Vector(4, 2);
    protected Vector acceptedDataClasses = new Vector(4, 2);
    protected String name;
    protected VisualPropertyType type;
    private int dupeCount = 0;
    protected List changeListeners = new Vector(1, 1);
    protected transient ChangeEvent changeEvent;

    public AbstractCalculator(String name, ObjectMapping m, VisualPropertyType type) {
        if (type == null) {
            throw new NullPointerException("Type parameter for Calculator is null");
        }
        this.type = type;
        this.name = name;
        this.addMapping(m);
        Class<?> c = type.getDataType();
        if (!c.isAssignableFrom(m.getRangeClass())) {
            throw new ClassCastException("Invalid Calculator: Expected class " + c.toString() + ", got " + m.getRangeClass().toString());
        }
    }

    public void addMapping(ObjectMapping m) {
        this.mappings.add(m);
        this.acceptedDataClasses.add(m.getAcceptedDataClasses());
    }

    @Override
    public Vector<ObjectMapping> getMappings() {
        return this.mappings;
    }

    @Override
    public ObjectMapping getMapping(int i) {
        return this.mappings.get(i);
    }

    public int getDupeCount() {
        return this.dupeCount;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int dupeCountIndex;
        AbstractCalculator clonedCalc = (AbstractCalculator)super.clone();
        String dupeFreeName = this.dupeCount != 0 ? ((dupeCountIndex = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, dupeCountIndex)) : new String(this.name);
        clonedCalc.name = dupeFreeName;
        clonedCalc.mappings = new Vector(this.mappings.size(), 2);
        for (int i = 0; i < this.mappings.size(); ++i) {
            ObjectMapping m = this.getMapping(i);
            clonedCalc.mappings.add((ObjectMapping)m.clone());
        }
        ++clonedCalc.dupeCount;
        return clonedCalc;
    }

    @Override
    public final String toString() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public Properties getProperties() {
        String mapBaseKey = this.type.getPropertyLabel() + "." + this.toString() + ".mapping";
        ObjectMapping m = this.getMapping(0);
        Properties props = MappingFactory.getProperties(m, mapBaseKey);
        props.put(this.type.getPropertyLabel() + "." + this.toString() + ".visualPropertyType", this.type.toString());
        return props;
    }

    protected String getClassName() {
        return this.getClass().getName();
    }

    void updateAttribute(String attrName, CyNetwork network, ObjectMapping m) throws IllegalArgumentException {
        int mapIndex = this.mappings.indexOf(m);
        if (mapIndex == -1) {
            throw new IllegalArgumentException(m.getClass().getName() + " " + m.toString() + " is not contained in calculator " + this.toString());
        }
        this.updateAttribute(attrName, network, mapIndex);
    }

    void updateAttribute(String attrName, CyNetwork network, int mIndex) throws ArrayIndexOutOfBoundsException {
        ObjectMapping m = this.mappings.get(mIndex);
        m.setControllingAttributeName(attrName);
    }

    @Override
    @Deprecated
    public JPanel getUI(JDialog parent, CyNetwork network) {
        return this.getUI(this.type.isNodeProp() ? Cytoscape.getNodeAttributes() : Cytoscape.getEdgeAttributes(), parent, network);
    }

    @Deprecated
    protected JPanel getUI(CyAttributes attr, JDialog parent, CyNetwork network) {
        return new CalculatorUI(attr, parent, network);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireStateChanged() {
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            ChangeListener listener = (ChangeListener)this.changeListeners.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            listener.stateChanged(this.changeEvent);
        }
    }

    protected Map<String, Object> getAttrBundle(String canonicalName, CyAttributes cyAttrs) {
        return CyAttributesUtils.getAttributes(canonicalName, cyAttrs);
    }

    protected Map<String, Object> getAttrBundle(String canonicalName) {
        return this.getAttrBundle(canonicalName, this.type.isNodeProp() ? Cytoscape.getNodeAttributes() : Cytoscape.getEdgeAttributes());
    }

    @Override
    public void apply(Appearance appr, Edge e, CyNetwork net) {
        Object o = this.getRangeValue(e);
        if (o == null) {
            return;
        }
        appr.set(this.type, o);
    }

    @Override
    public void apply(Appearance appr, Node n, CyNetwork net) {
        Object o = this.getRangeValue(n);
        if (o == null) {
            return;
        }
        appr.set(this.type, o);
    }

    protected Object getRangeValue(GraphObject obj) {
        if (obj == null) {
            return null;
        }
        String nodeID = obj.getIdentifier();
        Map<String, Object> attrBundle = this.getAttrBundle(nodeID);
        attrBundle.put("ID", obj.getIdentifier());
        return this.getMapping(0).calculateRangeValue(attrBundle);
    }

    @Override
    public VisualPropertyType getVisualPropertyType() {
        return this.type;
    }

    @Deprecated
    protected class CalculatorUI
    extends JPanel {
        protected GridBagGroup myGBG = new GridBagGroup(this);

        public CalculatorUI(CyAttributes attr, JDialog parent, CyNetwork network) {
            MiscGB.inset(this.myGBG.constraints, 5, 5, 5, 5);
            Object[] attrNames = attr.getAttributeNames();
            Arrays.sort(attrNames);
            int yPos = 0;
            int i = 0;
            while (i < AbstractCalculator.this.mappings.size()) {
                Object[] validAttr;
                MiscGB.insert(this.myGBG, (Component)new JLabel("Map Attribute:", 4), 0, yPos);
                MiscGB.insert(this.myGBG, Box.createHorizontalStrut(5), 1, yPos);
                ObjectMapping m = AbstractCalculator.this.mappings.get(i);
                Class[] okClass = (Class[])AbstractCalculator.this.acceptedDataClasses.get(i);
                if (okClass != null) {
                    Vector<Object> validAttrV = new Vector<Object>(attrNames.length);
                    block1: for (int j = 0; j < attrNames.length; ++j) {
                        Class attrClass = CyAttributesUtils.getClass((String)attrNames[j], attr);
                        for (int k = 0; k < okClass.length; ++k) {
                            if (!okClass[k].isAssignableFrom(attrClass)) continue;
                            validAttrV.add(attrNames[j]);
                            continue block1;
                        }
                    }
                    validAttr = validAttrV.toArray(new String[0]);
                } else {
                    validAttr = attrNames;
                }
                Vector<Object> v = new Vector<Object>();
                v.add("ID");
                for (int lc = 0; lc < validAttr.length; ++lc) {
                    v.add(validAttr[lc]);
                }
                validAttr = v.toArray(new String[0]);
                JComboBox<Object> attrBox = new JComboBox<Object>(validAttr);
                attrBox.setName("attrBox");
                String selectedAttr = m.getControllingAttributeName();
                attrBox.setSelectedIndex(-1);
                attrBox.setSelectedItem(selectedAttr);
                MiscGB.insert(this.myGBG, attrBox, 2, yPos, 1, 1, 1, 0, 2);
                JPanel mapperUI = m.getUI(parent, network);
                attrBox.addItemListener(new AttributeSelectorListener(parent, network, i, ++yPos, mapperUI));
                MiscGB.insert(this.myGBG, mapperUI, 0, yPos, 3, 1, 1, 0, 2);
                MiscGB.insert(this.myGBG, new JLabel(), 0, yPos + 1, 3, 1, 1, 1, 1);
                ++i;
                ++yPos;
            }
        }

        protected class AttributeSelectorListener
        implements ItemListener {
            private CyNetwork network;
            private int mapIndex;
            private int yPos;
            private JPanel mapperUI;
            private JDialog parent;

            protected AttributeSelectorListener(JDialog parent, CyNetwork network, int mapIndex, int yPos, JPanel mapperUI) {
                this.parent = parent;
                this.network = network;
                this.mapIndex = mapIndex;
                this.yPos = yPos;
                this.mapperUI = mapperUI;
            }

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox c = (JComboBox)e.getItemSelectable();
                    String attrName = (String)c.getSelectedItem();
                    AbstractCalculator.this.updateAttribute(attrName, this.network, this.mapIndex);
                    CalculatorUI.this.remove(this.mapperUI);
                    this.mapperUI = AbstractCalculator.this.mappings.get(this.mapIndex).getUI(this.parent, this.network);
                    MiscGB.insert(CalculatorUI.this.myGBG, this.mapperUI, 0, this.yPos, 3, 1, 2, 2, 1);
                    this.parent.validate();
                }
            }
        }
    }
}

