/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.data.CyAttributesImpl;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.data.writers.CyAttributesWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.TreeSet;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CyAttributesWriterTest
extends TestCase {
    public void testWriterScalars() throws IOException {
        System.out.println("################## CyAttributesWriter2 Test start #######################");
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        File file = new File("testData/galFiltered.nodeAttrs1");
        FileReader reader = new FileReader(file);
        CyAttributesReader.loadAttributes(cyAttributes, reader);
        StringWriter sw = new StringWriter();
        CyAttributesWriter cw2 = new CyAttributesWriter(cyAttributes, "TestNodeAttribute1", sw);
        cw2.writeAttributes();
        String output = sw.toString();
        String[] lines = output.split(System.getProperty("line.separator"));
        TreeSet<String> allLines = new TreeSet<String>();
        for (String line : lines) {
            System.out.println("Line = " + line);
            allLines.add(line);
        }
        if (sw != null) {
            sw.close();
            sw = null;
        }
        CyAttributesWriterTest.assertEquals(lines.length, allLines.size());
        CyAttributesWriterTest.assertTrue(allLines.contains("TestNodeAttribute1 (class=java.lang.Integer)"));
        CyAttributesWriterTest.assertTrue(allLines.contains("YDR309C = 1"));
        CyAttributesWriterTest.assertTrue(allLines.contains("YML024W = 2"));
        allLines = null;
        lines = null;
        System.out.println("################## CyAttributesWriter2 Test end #######################");
    }

    private void checkSimpleLists(char sep) throws IOException {
        StringWriter writer = new StringWriter();
        System.out.println("################## CyAttributesWriter2 List Test start #######################");
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        File file = new File("testData/implicitStringArray.attribute");
        FileReader reader = new FileReader(file);
        CyAttributesReader.loadAttributes(cyAttributes, reader);
        ArrayList<String> list = new ArrayList<String>();
        list.add(new String("Apple"));
        list.add(new String("Orange"));
        list.add(new String("Banana"));
        cyAttributes.setListAttribute("ABC_123", "GO_molecular_function_level_4", list);
        CyAttributesWriter writer2 = new CyAttributesWriter(cyAttributes, "GO_molecular_function_level_4", writer);
        writer2.writeAttributes();
        String output = writer.toString();
        String[] lines = output.split(System.getProperty("line.separator"));
        TreeSet<String> allLines = new TreeSet<String>();
        for (String line : lines) {
            System.out.println("Line = " + line);
            allLines.add(line);
        }
        if (writer != null) {
            writer.close();
            writer = null;
        }
        CyAttributesWriterTest.assertEquals(allLines.size(), lines.length);
        CyAttributesWriterTest.assertTrue(allLines.contains("GO_molecular_function_level_4 (class=java.lang.String)"));
        CyAttributesWriterTest.assertTrue(allLines.contains("HSD17B2 = (membrane::intracellular)"));
        CyAttributesWriterTest.assertTrue(allLines.contains("E2F4 = (DNA" + sep + "binding)"));
        CyAttributesWriterTest.assertTrue(allLines.contains("AP1G1 = (intracellular::clathrin" + sep + "adaptor::intracellular" + sep + "transporter)"));
        CyAttributesWriterTest.assertTrue(allLines.contains("ABC_123 = (Apple::Orange::Banana)"));
        CyAttributesWriterTest.assertTrue(allLines.contains("CDH3 = (cell" + sep + "adhesion" + sep + "molecule)"));
        allLines = null;
        lines = null;
        System.out.println("################## CyAttributesWriter2 List Test end #######################");
    }

    public void testWriteSimpleLists1() throws IOException {
        System.clearProperty("cytoscape.encode.attributes");
        this.checkSimpleLists('+');
    }

    public void testWriteSimpleLists2() throws IOException {
        System.setProperty("cytoscape.encode.attributes", "false");
        this.checkSimpleLists(' ');
    }

    public void testWriteSimpleLists3() throws IOException {
        System.setProperty("cytoscape.encode.attributes", "true");
        this.checkSimpleLists('+');
    }

    public static void main(String[] args) {
        TestRunner.run(CyAttributesWriterTest.class);
    }
}

