/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.servers.BioDataServer;
import giny.model.Edge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Semantics {
    public static final String CANONICAL_NAME = "canonicalName";
    public static final String INTERACTION = "interaction";
    @Deprecated
    public static final String GO_COMMON_NAME = "GO Common Name";
    @Deprecated
    public static final String GO_ALIASES = "GO Aliases";
    @Deprecated
    public static final String SPECIES = "species";
    @Deprecated
    public static final String MOLECULE_TYPE = "molecule_type";
    @Deprecated
    public static final String PROTEIN = "protein";
    @Deprecated
    public static final String DNA = "DNA";
    @Deprecated
    public static final String RNA = "RNA";
    @Deprecated
    public static final String MOLECULAR_FUNCTION = "molecular_function";
    @Deprecated
    public static final String BIOLOGICAL_PROCESS = "biological_process";
    @Deprecated
    public static final String CELLULAR_COMPONENT = "cellular_component";

    @Deprecated
    public static void applyNamingServices(CyNetwork network) {
        Semantics.assignSpecies(network);
    }

    @Deprecated
    public static void assignSpecies(CyNetwork network) {
        if (network == null) {
            return;
        }
        String defaultSpecies = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
        if (defaultSpecies == null) {
            return;
        }
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        Iterator nodeIt = network.nodesIterator();
        while (nodeIt.hasNext()) {
            String nodeLabel = ((CyNode)nodeIt.next()).getIdentifier();
            String species = nodeAttributes.getStringAttribute(nodeLabel, SPECIES);
            if (species != null) continue;
            nodeAttributes.setAttribute(nodeLabel, SPECIES, defaultSpecies);
        }
    }

    @Deprecated
    public static Set getSpeciesInNetwork(CyNetwork network) {
        HashSet<String> returnSet = new HashSet<String>();
        if (network == null) {
            return returnSet;
        }
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        CountedIterator keys = nodeAttributes.getMultiHashMap().getObjectKeys(SPECIES);
        while (keys.hasNext()) {
            returnSet.add(nodeAttributes.getStringAttribute((String)keys.next(), SPECIES));
        }
        return returnSet;
    }

    @Deprecated
    public static void assignNodeAliases(CyNode node, String species, BioDataServer bds) {
        String nodeID = node.getIdentifier();
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        if (node == null) {
            return;
        }
        if (species == null && (species = nodeAttributes.getStringAttribute(nodeID, SPECIES)) == null) {
            species = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
        }
        if (species != null) {
            nodeAttributes.setAttribute(nodeID, SPECIES, species);
        }
        if (bds == null) {
            return;
        }
        String[] synonyms = bds.getAllCommonNames(species, nodeID);
        String canonicalFromAliases = bds.getCanonicalName(species, nodeID);
        String[] reverseSynonyms = bds.getAllCommonNames(species, canonicalFromAliases);
        TreeSet<String> synoSet = new TreeSet<String>();
        String commonName = null;
        for (int j = 0; j < synonyms.length; ++j) {
            if (synonyms[j].equals(nodeID)) continue;
            synoSet.add(synonyms[j]);
        }
        for (int i = 0; i < reverseSynonyms.length; ++i) {
            if (reverseSynonyms[i].equals(nodeID)) continue;
            synoSet.add(reverseSynonyms[i]);
        }
        if (!synoSet.contains(canonicalFromAliases)) {
            synoSet.add(canonicalFromAliases);
        }
        if (canonicalFromAliases != null && !canonicalFromAliases.equals(nodeID)) {
            commonName = canonicalFromAliases;
        } else if (synonyms.length != 0) {
            commonName = synonyms[0];
        } else if (synoSet.size() == 0) {
            commonName = nodeID;
            synoSet.add(commonName);
        } else {
            commonName = nodeID;
        }
        nodeAttributes.setListAttribute(nodeID, GO_ALIASES, new ArrayList(synoSet));
        nodeAttributes.setAttribute(nodeID, GO_COMMON_NAME, commonName);
    }

    @Deprecated
    public static void assignCommonNames(CyNetwork network, BioDataServer bioDataServer) {
        if (network == null || bioDataServer == null) {
            return;
        }
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            Semantics.assignNodeAliases((CyNode)it.next(), null, bioDataServer);
        }
    }

    public static String[] getInteractionTypes(CyNetwork network) {
        if (network == null) {
            return new String[0];
        }
        HashMap<Object, Object> dupsFilter = new HashMap<Object, Object>();
        CyAttributes attrs = Cytoscape.getEdgeAttributes();
        MultiHashMap mmap = attrs.getMultiHashMap();
        CountedIterator objs = mmap.getObjectKeys(INTERACTION);
        while (objs.hasNext()) {
            String obj = (String)objs.next();
            Object val = mmap.getAttributeValue(obj, INTERACTION, null);
            dupsFilter.put(val, val);
        }
        String[] returnThis = new String[dupsFilter.size()];
        Iterator uniqueIter = dupsFilter.keySet().iterator();
        int inx = 0;
        while (uniqueIter.hasNext()) {
            returnThis[inx++] = (String)uniqueIter.next();
        }
        return returnThis;
    }

    public static String getInteractionType(CyNetwork network, Edge edge) {
        if (network == null || edge == null) {
            return null;
        }
        return Cytoscape.getEdgeAttributes().getStringAttribute(edge.getIdentifier(), INTERACTION);
    }

    @Deprecated
    public static boolean areSynonyms(String firstName, String secondName, CyNetwork network) {
        if (firstName == null || secondName == null) {
            return firstName == null && secondName == null;
        }
        if (firstName.equalsIgnoreCase(secondName)) {
            return true;
        }
        List firstSynonyms = Semantics.getAllSynonyms(firstName, network);
        List secondSynonyms = Semantics.getAllSynonyms(secondName, network);
        Iterator firstI = firstSynonyms.iterator();
        while (firstI.hasNext()) {
            Iterator secondI = secondSynonyms.iterator();
            while (secondI.hasNext()) {
                if (!((String)firstI.next()).equalsIgnoreCase((String)secondI.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static List getAllSynonyms(String name, CyNetwork network) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (name == null) {
            return returnList;
        }
        returnList.add(name);
        String species = null;
        if (network != null) {
            String commonName = Cytoscape.getNodeAttributes().getStringAttribute(name, GO_COMMON_NAME);
            if (commonName != null) {
                returnList.add(commonName);
            }
            species = Cytoscape.getNodeAttributes().getStringAttribute(name, SPECIES);
        }
        species = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
        return returnList;
    }
}

