/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.cytoscape.equations.EqnCompiler;

public class CyAttributesTest
extends TestCase {
    private CyAttributes cyAttributes;
    private static final String DUMMY_ID = "id_123";
    private static final String DUMMY_BOOLEAN_ATTRIBUTE = "attribute1";
    private static final String DUMMY_STRING_ATTRIBUTE = "attribute2";
    private static final String DUMMY_LIST_ATTRIBUTE = "attribute3";
    private static final String DUMMY_MAP_ATTRIBUTE = "attribute4";

    protected void setUp() throws Exception {
        this.cyAttributes = new CyAttributesImpl();
    }

    public void testBug1363() {
        try {
            boolean b = this.cyAttributes.deleteAttribute("non-existent-attribute.asdffdsa");
            CyAttributesTest.assertFalse(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            CyAttributesTest.fail("deleting non-existent attr shouldn't have caused exception");
        }
    }

    public void testBooleanValue() {
        boolean exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(false, exists);
        Boolean value = this.cyAttributes.getBooleanAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(null, value);
        Double value2 = this.cyAttributes.getDoubleAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(null, value2);
        try {
            this.cyAttributes.setAttribute(null, DUMMY_BOOLEAN_ATTRIBUTE, new Boolean(true));
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        try {
            this.cyAttributes.setAttribute(DUMMY_ID, null, new Boolean(true));
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE, new Boolean(true));
        exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(true, exists);
        byte type = this.cyAttributes.getType(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)1, type);
        value = this.cyAttributes.getBooleanAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(true, value);
        try {
            Integer valueInt = this.cyAttributes.getIntegerAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
            CyAttributesTest.fail("ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        try {
            this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE, new Integer(5));
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        String[] attribs = this.cyAttributes.getAttributeNames();
        CyAttributesTest.assertEquals(1, attribs.length);
        CyAttributesTest.assertEquals(DUMMY_BOOLEAN_ATTRIBUTE, attribs[0]);
        boolean success = this.cyAttributes.deleteAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(true, success);
        exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals(false, exists);
        type = this.cyAttributes.getType(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)1, type);
        CyAttributesTest.assertEquals((byte)1, type);
        success = this.cyAttributes.deleteAttribute(DUMMY_BOOLEAN_ATTRIBUTE);
        type = this.cyAttributes.getType(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)-1, type);
    }

    public void testStringValue() {
        boolean exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals(false, exists);
        this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE, new String("Cytoscape"));
        exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals(true, exists);
        byte type = this.cyAttributes.getType(DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)4, type);
        String value = this.cyAttributes.getStringAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
        CyAttributesTest.assertEquals("Cytoscape", value);
        try {
            Integer valueInt = this.cyAttributes.getIntegerAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE);
            CyAttributesTest.fail("ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        try {
            this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_STRING_ATTRIBUTE, new Integer(5));
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        String[] attribs = this.cyAttributes.getAttributeNames();
        CyAttributesTest.assertEquals(1, attribs.length);
        CyAttributesTest.assertEquals(DUMMY_STRING_ATTRIBUTE, attribs[0]);
    }

    public void testSimpleLists() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(5));
        list.add(new String("Cytoscape"));
        try {
            this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, (List)null);
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        try {
            this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, list);
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        list = new ArrayList();
        list.add(new Integer(5));
        list.add(new Integer(6));
        this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, list);
        byte type = this.cyAttributes.getType(DUMMY_LIST_ATTRIBUTE);
        CyAttributesTest.assertEquals(type, (byte)-2);
        boolean exists = this.cyAttributes.hasAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE);
        CyAttributesTest.assertEquals(true, exists);
        try {
            Map map = this.cyAttributes.getMapAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE);
            CyAttributesTest.fail("ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        List storedList = this.cyAttributes.getListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE);
        CyAttributesTest.assertEquals(2, storedList.size());
        Integer int0 = (Integer)storedList.get(0);
        Integer int1 = (Integer)storedList.get(1);
        CyAttributesTest.assertEquals(5, int0);
        CyAttributesTest.assertEquals(6, int1);
        list = new ArrayList();
        this.cyAttributes.setListAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, list);
    }

    public void testSimpleMaps() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(new Integer(1), new String("One"));
        map.put(new Integer(2), new String("Two"));
        try {
            this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE, map);
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        map = new HashMap();
        map.put(new String("first"), new String("One"));
        map.put(new String("second"), new Integer(2));
        try {
            this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE, map);
            CyAttributesTest.fail("IllegalArgumentException should have been thrown.");
        }
        catch (IllegalArgumentException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        map = new HashMap();
        map.put(new String("first"), new Integer(1));
        map.put(new String("second"), new Integer(2));
        this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE, map);
        byte type = this.cyAttributes.getType(DUMMY_MAP_ATTRIBUTE);
        CyAttributesTest.assertEquals((byte)-3, type);
        try {
            List list = this.cyAttributes.getListAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE);
            CyAttributesTest.fail("ClassCastException should have been thrown.");
        }
        catch (ClassCastException e) {
            CyAttributesTest.assertTrue(e != null);
        }
        Map storedMap = this.cyAttributes.getMapAttribute(DUMMY_ID, DUMMY_MAP_ATTRIBUTE);
        CyAttributesTest.assertEquals(2, storedMap.keySet().size());
        Set keySet = storedMap.keySet();
        CyAttributesTest.assertTrue(keySet.contains("first"));
        CyAttributesTest.assertEquals((Object)1, storedMap.get("first"));
        CyAttributesTest.assertTrue(keySet.contains("second"));
        CyAttributesTest.assertEquals((Object)2, storedMap.get("second"));
        map = new HashMap();
        this.cyAttributes.setMapAttribute(DUMMY_ID, DUMMY_LIST_ATTRIBUTE, map);
    }

    public void testAttributeDescriptions() {
        this.cyAttributes.setAttributeDescription(DUMMY_BOOLEAN_ATTRIBUTE, "sample description");
        String description = this.cyAttributes.getAttributeDescription(DUMMY_BOOLEAN_ATTRIBUTE);
        CyAttributesTest.assertEquals("sample description", description);
        CyAttributesTest.assertEquals(null, this.cyAttributes.getAttributeDescription(DUMMY_STRING_ATTRIBUTE));
    }

    public void testUserInteractionFlags() {
        String sampleAttribute = DUMMY_BOOLEAN_ATTRIBUTE;
        boolean visibleFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals(true, visibleFlag);
        boolean editableFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals(true, editableFlag);
        this.cyAttributes.setUserVisible(sampleAttribute, false);
        visibleFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals(false, visibleFlag);
        this.cyAttributes.setUserVisible(sampleAttribute, true);
        visibleFlag = this.cyAttributes.getUserVisible(sampleAttribute);
        CyAttributesTest.assertEquals(true, visibleFlag);
        this.cyAttributes.setUserEditable(sampleAttribute, false);
        editableFlag = this.cyAttributes.getUserEditable(sampleAttribute);
        CyAttributesTest.assertEquals(false, editableFlag);
        this.cyAttributes.setUserEditable(sampleAttribute, true);
        editableFlag = this.cyAttributes.getUserEditable(sampleAttribute);
        CyAttributesTest.assertEquals(true, editableFlag);
    }

    public void testGetLastEquationError() {
        EqnCompiler compiler = new EqnCompiler();
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        CyAttributesTest.assertTrue(compiler.compile("=1/0", attribNameToTypeMap));
        this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE, compiler.getEquation());
        CyAttributesTest.assertNull(this.cyAttributes.getAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE));
        CyAttributesTest.assertNotNull(this.cyAttributes.getLastEquationError());
        CyAttributesTest.assertTrue(compiler.compile("=1/1", attribNameToTypeMap));
        this.cyAttributes.setAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE, compiler.getEquation());
        CyAttributesTest.assertNotNull(this.cyAttributes.getAttribute(DUMMY_ID, DUMMY_BOOLEAN_ATTRIBUTE));
        CyAttributesTest.assertNull(this.cyAttributes.getLastEquationError());
    }

    public void testGetListElementType() {
        ArrayList<Integer> iList = new ArrayList<Integer>();
        iList.add(2);
        this.cyAttributes.setListAttribute("ID", "ilist", iList);
        CyAttributesTest.assertEquals((byte)3, this.cyAttributes.getListElementType("ilist"));
        ArrayList<Double> fList = new ArrayList<Double>();
        fList.add(2.5);
        this.cyAttributes.setListAttribute("ID", "flist", fList);
        CyAttributesTest.assertEquals((byte)2, this.cyAttributes.getListElementType("flist"));
        ArrayList<String> sList = new ArrayList<String>();
        sList.add("xyz");
        this.cyAttributes.setListAttribute("ID", "slist", sList);
        CyAttributesTest.assertEquals((byte)4, this.cyAttributes.getListElementType("slist"));
        ArrayList<Boolean> bList = new ArrayList<Boolean>();
        bList.add(true);
        this.cyAttributes.setListAttribute("ID", "blist", bList);
        CyAttributesTest.assertEquals((byte)1, this.cyAttributes.getListElementType("blist"));
    }

    public static void main(String[] args) {
        TestRunner.run(CyAttributesTest.class);
    }
}

