/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashset;

import com.sosnoski.util.hashset.PrimitiveSetBase;

public class IntHashSet
extends PrimitiveSetBase {
    protected int[] m_keyTable;

    public IntHashSet(int n, double d) {
        super(n, d, Integer.TYPE);
    }

    public IntHashSet(int n) {
        this(n, 0.3);
    }

    public IntHashSet() {
        this(0, 0.3);
    }

    public IntHashSet(IntHashSet intHashSet) {
        super(intHashSet);
    }

    protected Object getKeyArray() {
        return this.m_keyTable;
    }

    protected void setKeyArray(Object object) {
        this.m_keyTable = (int[])object;
    }

    protected final boolean reinsert(int n) {
        this.m_flagTable[n] = false;
        return this.assignSlot(this.m_keyTable[n]) != n;
    }

    protected void restructure(boolean[] blArray, Object object) {
        int[] nArray = (int[])object;
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                this.assignSlot(nArray[n]);
            }
            ++n;
        }
    }

    protected final int computeSlot(int n) {
        return (n * 517 & Integer.MAX_VALUE) % this.m_flagTable.length;
    }

    protected int assignSlot(int n) {
        int n2 = this.freeSlot(this.computeSlot(n));
        this.m_flagTable[n2] = true;
        this.m_keyTable[n2] = n;
        return n2;
    }

    public boolean add(int n) {
        this.ensureCapacity(this.m_entryCount + 1);
        int n2 = -this.internalFind(n) - 1;
        if (n2 >= 0) {
            ++this.m_entryCount;
            this.m_flagTable[n2] = true;
            this.m_keyTable[n2] = n;
            return true;
        }
        return false;
    }

    protected final int internalFind(int n) {
        int n2 = this.computeSlot(n);
        while (this.m_flagTable[n2]) {
            if (n == this.m_keyTable[n2]) {
                return n2;
            }
            n2 = this.stepSlot(n2);
        }
        return -n2 - 1;
    }

    public boolean contains(int n) {
        return this.internalFind(n) >= 0;
    }

    public boolean remove(int n) {
        int n2 = this.internalFind(n);
        if (n2 >= 0) {
            this.m_flagTable[n2] = false;
            --this.m_entryCount;
            while (this.m_flagTable[n2 = this.stepSlot(n2)]) {
                this.reinsert(n2);
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        return new IntHashSet(this);
    }
}

