/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.event.PInputEvent;

public class PInputEventFilter {
    public static int ALL_MODIFIERS_MASK = 63;
    private int andMask;
    private int orMask;
    private int notMask;
    private short clickCount = (short)-1;
    private boolean marksAcceptedEventsAsHandled = false;
    private boolean acceptsAlreadyHandledEvents = false;
    private boolean acceptsKeyPressed = true;
    private boolean acceptsKeyReleased = true;
    private boolean acceptsKeyTyped = true;
    private boolean acceptsMouseClicked = true;
    private boolean acceptsMouseDragged = true;
    private boolean acceptsMouseEntered = true;
    private boolean acceptsMouseExited = true;
    private boolean acceptsMouseMoved = true;
    private boolean acceptsMousePressed = true;
    private boolean acceptsMouseReleased = true;
    private boolean acceptsMouseWheelRotated = true;
    private boolean acceptsFocusEvents = true;

    public PInputEventFilter() {
        this.acceptEverything();
    }

    public PInputEventFilter(int n) {
        this();
        this.andMask = n;
    }

    public PInputEventFilter(int n, int n2) {
        this(n);
        this.notMask = n2;
    }

    public boolean acceptsEvent(PInputEvent pInputEvent, int n) {
        boolean bl = false;
        int n2 = 0;
        if (!pInputEvent.isFocusEvent()) {
            n2 = pInputEvent.getModifiers();
        }
        if ((!pInputEvent.isHandled() || this.acceptsAlreadyHandledEvents) && (n2 == 0 || (n2 & this.andMask) == this.andMask && (n2 & this.orMask) != 0 && (n2 & this.notMask) == 0)) {
            if (pInputEvent.isMouseEvent() && this.clickCount != -1 && this.clickCount != pInputEvent.getClickCount()) {
                bl = false;
            } else {
                switch (n) {
                    case 401: {
                        bl = this.getAcceptsKeyPressed();
                        break;
                    }
                    case 402: {
                        bl = this.getAcceptsKeyReleased();
                        break;
                    }
                    case 400: {
                        bl = this.getAcceptsKeyTyped();
                        break;
                    }
                    case 500: {
                        bl = this.getAcceptsMouseClicked();
                        break;
                    }
                    case 506: {
                        bl = this.getAcceptsMouseDragged();
                        break;
                    }
                    case 504: {
                        bl = this.getAcceptsMouseEntered();
                        break;
                    }
                    case 505: {
                        bl = this.getAcceptsMouseExited();
                        break;
                    }
                    case 503: {
                        bl = this.getAcceptsMouseMoved();
                        break;
                    }
                    case 501: {
                        bl = this.getAcceptsMousePressed();
                        break;
                    }
                    case 502: {
                        bl = this.getAcceptsMouseReleased();
                        break;
                    }
                    case 0: 
                    case 1: {
                        bl = this.getAcceptsMouseWheelRotated();
                        break;
                    }
                    case 1004: 
                    case 1005: {
                        bl = this.getAcceptsFocusEvents();
                        break;
                    }
                    default: {
                        throw new RuntimeException("PInputEvent with bad ID");
                    }
                }
            }
        }
        if (bl && this.getMarksAcceptedEventsAsHandled()) {
            pInputEvent.setHandled(true);
        }
        return bl;
    }

    public void acceptAllClickCounts() {
        this.clickCount = (short)-1;
    }

    public void acceptAllEventTypes() {
        this.acceptsKeyPressed = true;
        this.acceptsKeyReleased = true;
        this.acceptsKeyTyped = true;
        this.acceptsMouseClicked = true;
        this.acceptsMouseDragged = true;
        this.acceptsMouseEntered = true;
        this.acceptsMouseExited = true;
        this.acceptsMouseMoved = true;
        this.acceptsMousePressed = true;
        this.acceptsMouseReleased = true;
        this.acceptsMouseWheelRotated = true;
        this.acceptsFocusEvents = true;
    }

    public void acceptEverything() {
        this.acceptAllEventTypes();
        this.setAndMask(0);
        this.setOrMask(ALL_MODIFIERS_MASK);
        this.setNotMask(0);
        this.acceptAllClickCounts();
    }

    public boolean getAcceptsKeyPressed() {
        return this.acceptsKeyPressed;
    }

    public boolean getAcceptsKeyReleased() {
        return this.acceptsKeyReleased;
    }

    public boolean getAcceptsKeyTyped() {
        return this.acceptsKeyTyped;
    }

    public boolean getAcceptsMouseClicked() {
        return this.acceptsMouseClicked;
    }

    public boolean getAcceptsMouseDragged() {
        return this.acceptsMouseDragged;
    }

    public boolean getAcceptsMouseEntered() {
        return this.acceptsMouseEntered;
    }

    public boolean getAcceptsMouseExited() {
        return this.acceptsMouseExited;
    }

    public boolean getAcceptsMouseMoved() {
        return this.acceptsMouseMoved;
    }

    public boolean getAcceptsMousePressed() {
        return this.acceptsMousePressed;
    }

    public boolean getAcceptsMouseReleased() {
        return this.acceptsMouseReleased;
    }

    public boolean getAcceptsMouseWheelRotated() {
        return this.acceptsMouseWheelRotated;
    }

    public boolean getAcceptsFocusEvents() {
        return this.acceptsFocusEvents;
    }

    public boolean getAcceptsAlreadyHandledEvents() {
        return this.acceptsAlreadyHandledEvents;
    }

    public boolean getMarksAcceptedEventsAsHandled() {
        return this.marksAcceptedEventsAsHandled;
    }

    public void rejectAllClickCounts() {
        this.clickCount = Short.MAX_VALUE;
    }

    public void rejectAllEventTypes() {
        this.acceptsKeyPressed = false;
        this.acceptsKeyReleased = false;
        this.acceptsKeyTyped = false;
        this.acceptsMouseClicked = false;
        this.acceptsMouseDragged = false;
        this.acceptsMouseEntered = false;
        this.acceptsMouseExited = false;
        this.acceptsMouseMoved = false;
        this.acceptsMousePressed = false;
        this.acceptsMouseReleased = false;
        this.acceptsMouseWheelRotated = false;
        this.acceptsFocusEvents = false;
    }

    public void setAcceptClickCount(short s) {
        this.clickCount = s;
    }

    public void setAcceptsKeyPressed(boolean bl) {
        this.acceptsKeyPressed = bl;
    }

    public void setAcceptsKeyReleased(boolean bl) {
        this.acceptsKeyReleased = bl;
    }

    public void setAcceptsKeyTyped(boolean bl) {
        this.acceptsKeyTyped = bl;
    }

    public void setAcceptsMouseClicked(boolean bl) {
        this.acceptsMouseClicked = bl;
    }

    public void setAcceptsMouseDragged(boolean bl) {
        this.acceptsMouseDragged = bl;
    }

    public void setAcceptsMouseEntered(boolean bl) {
        this.acceptsMouseEntered = bl;
    }

    public void setAcceptsMouseExited(boolean bl) {
        this.acceptsMouseExited = bl;
    }

    public void setAcceptsMouseMoved(boolean bl) {
        this.acceptsMouseMoved = bl;
    }

    public void setAcceptsMousePressed(boolean bl) {
        this.acceptsMousePressed = bl;
    }

    public void setAcceptsMouseReleased(boolean bl) {
        this.acceptsMouseReleased = bl;
    }

    public void setAcceptsMouseWheelRotated(boolean bl) {
        this.acceptsMouseWheelRotated = bl;
    }

    public void setAcceptsFocusEvents(boolean bl) {
        this.acceptsFocusEvents = bl;
    }

    public void setAndMask(int n) {
        this.andMask = n;
    }

    public void setAcceptsAlreadyHandledEvents(boolean bl) {
        this.acceptsAlreadyHandledEvents = bl;
    }

    public void setMarksAcceptedEventsAsHandled(boolean bl) {
        this.marksAcceptedEventsAsHandled = bl;
    }

    public void setNotMask(int n) {
        this.notMask = n;
    }

    public void setOrMask(int n) {
        this.orMask = n;
    }
}

