/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.undo;

import cytoscape.logger.CyLogger;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.undo.CyUndo;
import java.awt.event.ActionEvent;
import javax.swing.event.MenuEvent;
import javax.swing.undo.CannotUndoException;

public class UndoAction
extends CytoscapeAction {
    private static CyLogger logger = CyLogger.getLogger(UndoAction.class);

    public UndoAction() {
        super("Undo");
        this.setAcceleratorCombo(90, 2);
        this.setPreferredMenu("Edit");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (CyUndo.undoManager.canUndo()) {
                CyUndo.undoManager.undo();
            }
        }
        catch (CannotUndoException ex) {
            logger.warn("Unable to undo: " + ex.getMessage(), ex);
        }
    }

    public void menuSelected(MenuEvent e) {
        if (CyUndo.undoManager.canUndo()) {
            this.setEnabled(true);
            this.putValue("Name", CyUndo.undoManager.getUndoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }

    public void menuDeselected(MenuEvent e) {
        this.setEnabled(true);
    }
}

