/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.layout.Tunable;
import cytoscape.layout.TunableListener;
import cytoscape.util.ModulePropertiesImpl;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutProperties
extends ModulePropertiesImpl
implements TunableListener {
    JPanel tunablesPanel = null;

    public LayoutProperties(String propertyPrefix) {
        super(propertyPrefix, "layout");
    }

    public JPanel getTunablePanel() {
        if (this.tunablesPanel != null) {
            return this.tunablesPanel;
        }
        this.tunablesPanel = new JPanel();
        BoxLayout box = new BoxLayout(this.tunablesPanel, 1);
        this.tunablesPanel.setLayout(box);
        this.addSubPanels(this.tunablesPanel, this.tunablesList.iterator(), new Integer(100000), this);
        this.tunablesPanel.validate();
        return this.tunablesPanel;
    }

    public void updateTunablePanel() {
        if (this.tunablesPanel == null) {
            return;
        }
        this.tunablesPanel.removeAll();
        this.addSubPanels(this.tunablesPanel, this.tunablesList.iterator(), new Integer(100000), null);
        this.tunablesPanel.doLayout();
        this.tunablesPanel.validate();
        ComponentListener[] resizeListeners = this.tunablesPanel.getComponentListeners();
        if (resizeListeners == null) {
            return;
        }
        for (int i = 0; i < resizeListeners.length; ++i) {
            resizeListeners[i].componentResized(new ComponentEvent(this.tunablesPanel, 101));
        }
    }

    private void addSubPanels(JPanel panel, Iterator<Tunable> iter, Object count, TunableListener listener) {
        int groupCount = (Integer)count;
        for (int n = 0; n < groupCount; ++n) {
            if (!iter.hasNext()) {
                return;
            }
            Tunable tunable = iter.next();
            JPanel p = tunable.getPanel();
            if (panel == null) {
                p = null;
            }
            if (tunable.getType() == 7) {
                if (!tunable.checkFlag(32)) {
                    this.addSubPanels(p, iter, tunable.getValue(), listener);
                } else {
                    tunable.addTunableValueListener(listener);
                    Boolean collapsed = (Boolean)tunable.getLowerBound();
                    if (!collapsed.booleanValue()) {
                        this.addSubPanels(p, iter, tunable.getValue(), listener);
                    } else {
                        this.addSubPanels(null, iter, tunable.getValue(), listener);
                    }
                }
            }
            if (p == null) continue;
            panel.add(p);
        }
    }

    @Override
    public void tunableChanged(Tunable tunable) {
        this.updateTunablePanel();
    }
}

